/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.ui;

import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.dialogs.ModuleSelectionDialog;
import com.google.gwt.eclipse.core.modules.IModule;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class EntryPointModulesSelectionBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_REMOVE = 1;
    private static final int IDX_SET_DEFAULTS = 3;
    private List<String> defaultModules;
    private IJavaProject javaProject;
    private final String labelText;
    private final IModulesChangeListener listener;
    private ListDialogField<String> modulesField;
    private Composite parent;

    public EntryPointModulesSelectionBlock(IModulesChangeListener listener) {
        this(null, listener);
    }

    public EntryPointModulesSelectionBlock(String labelText, IModulesChangeListener listener) {
        this.labelText = labelText;
        this.listener = listener;
        this.createListField();
    }

    public void doFillIntoGrid(Composite parent, int columns) {
        this.parent = parent;
        this.modulesField.doFillIntoGrid(parent, columns);
        GridData modulesFieldGridData = (GridData)this.modulesField.getListControl(parent).getLayoutData();
        modulesFieldGridData.grabExcessHorizontalSpace = true;
        modulesFieldGridData.grabExcessVerticalSpace = true;
        this.modulesField.getListControl(parent).setLayoutData((Object)modulesFieldGridData);
    }

    public List<String> getDefaultModules() {
        return this.defaultModules;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public List<String> getModules() {
        return this.modulesField.getElements();
    }

    public boolean isDefault() {
        return this.getModules().equals(this.defaultModules);
    }

    public void removeSelectedEntries() {
        this.modulesField.removeElements(this.modulesField.getSelectedElements());
    }

    public void setDefaultModules(List<String> modules) {
        this.defaultModules = modules;
    }

    public void setEnabled(boolean enabled) {
        this.modulesField.setEnabled(enabled);
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public void setModules(List<String> selectedModules) {
        List beforeModules = this.modulesField.getElements();
        if (selectedModules.isEmpty()) {
            this.setDefaults();
        } else {
            this.modulesField.setElements(selectedModules);
            this.modulesField.selectFirstElement();
        }
        this.notifyListenerIfChanged(beforeModules);
    }

    private void addEntry() {
        if (this.javaProject == null) {
            MessageDialog.openError((Shell)this.parent.getShell(), (String)"Module Selection Error", (String)"A valid Java project must be selected.");
            return;
        }
        IModule module = ModuleSelectionDialog.show(this.parent.getShell(), this.javaProject, false);
        if (module != null) {
            String moduleName = module.getQualifiedName();
            if (!this.modulesField.getElements().contains(moduleName)) {
                this.modulesField.addElement((Object)moduleName);
            }
        }
    }

    private void createListField() {
        String[] stringArray = new String[4];
        stringArray[0] = "Add...";
        stringArray[1] = "Remove";
        stringArray[3] = "Restore Defaults";
        String[] buttons = stringArray;
        this.modulesField = new ListDialogField((IListAdapter)new ModulesSelectionAdapter(), buttons, (ILabelProvider)new ModulesLabelProvider());
        this.modulesField.setLabelText(this.labelText);
        this.modulesField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        this.modulesField.enableButton(1, false);
    }

    private void notifyListenerIfChanged(List<String> beforeModules) {
        if (this.listener != null && !this.getModules().equals(beforeModules)) {
            this.listener.onModulesChanged();
        }
    }

    private void setDefaults() {
        this.modulesField.setElements(this.defaultModules);
        this.modulesField.selectFirstElement();
    }

    public static interface IModulesChangeListener {
        public void onModulesChanged();
    }

    private class ModulesLabelProvider
    extends LabelProvider {
        private final Image elementImage = GWTPlugin.getDefault().getImage("com.gwtplugins.gwt.eclipse.core.images.moduleIcon");

        public Image getImage(Object element) {
            return this.elementImage;
        }

        public String getText(Object element) {
            String qualifiedModuleName = (String)element;
            String moduleName = Signature.getSimpleName((String)qualifiedModuleName);
            String packageName = Signature.getQualifier((String)qualifiedModuleName);
            return String.valueOf(moduleName) + " - " + packageName;
        }
    }

    private class ModulesSelectionAdapter
    implements IListAdapter<String> {
        private ModulesSelectionAdapter() {
        }

        public void customButtonPressed(ListDialogField<String> field, int index) {
            List beforeModules = EntryPointModulesSelectionBlock.this.modulesField.getElements();
            if (index == 0) {
                EntryPointModulesSelectionBlock.this.addEntry();
            } else if (index == 1) {
                EntryPointModulesSelectionBlock.this.removeSelectedEntries();
            } else if (index == 3) {
                EntryPointModulesSelectionBlock.this.setDefaults();
            }
            EntryPointModulesSelectionBlock.this.notifyListenerIfChanged(beforeModules);
        }

        public void doubleClicked(ListDialogField<String> field) {
        }

        public void selectionChanged(ListDialogField<String> field) {
            EntryPointModulesSelectionBlock.this.modulesField.enableButton(1, !EntryPointModulesSelectionBlock.this.modulesField.getSelectedElements().isEmpty());
        }
    }
}

