/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.ui;

import com.google.gdt.eclipse.core.properties.WebAppProjectProperties;
import com.google.gwt.eclipse.core.GWTPluginLog;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.osgi.service.prefs.BackingStoreException;

public class LegacyGWTHostPageSelectionDialog
extends ElementTreeSelectionDialog {
    private static final IStatus OK_STATUS = new Status(0, "com.gwtplugins.gwt.eclipse.core", "");
    private static final IStatus NO_HOST_PAGES_STATUS = new Status(2, "com.gwtplugins.gwt.eclipse.core", "No host pages were found. Launch anyway?");
    private final boolean isExternal;
    private Text externalUrlPrefixText;
    private String externalUrlPrefixTextCache;
    private IProject project;
    private Button useHostPageCheckbox;
    private boolean useHostPage;
    private final boolean isEmpty;

    public static String getStartupUrl(Shell shell, IProject project, Map<String, Set<String>> hostPagesByModule, boolean isExternal) {
        LegacyGWTHostPageSelectionDialog dialog = new LegacyGWTHostPageSelectionDialog(shell, project, hostPagesByModule, isExternal);
        if (dialog.open() == 0) {
            try {
                WebAppProjectProperties.setLaunchConfigExternalUrlPrefix((IProject)project, (String)dialog.getExternalUrlPrefix());
            }
            catch (BackingStoreException e) {
                GWTPluginLog.logError(e);
            }
            return dialog.getUrl();
        }
        return null;
    }

    private LegacyGWTHostPageSelectionDialog(Shell parent, IProject project, Map<String, Set<String>> hostPagesByModule, boolean isExternal) {
        super(parent, (ILabelProvider)new LegacyHostPageSelectionLabelProvider(), (ITreeContentProvider)new LegacyGWTHostPageSelectionContentProvider());
        this.isExternal = isExternal;
        this.project = project;
        this.isEmpty = hostPagesByModule.isEmpty();
        this.useHostPage = !this.isEmpty;
        this.setValidator(new LegacyHostPageSelectionStatusValidator());
        this.setTitle("Host page selection");
        this.setMessage("Choose a host page to launch the application with:");
        this.setInput(LegacyGWTHostPageSelectionTreeItem.buildTree(hostPagesByModule));
        this.setComparator(new ViewerComparator());
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        if (this.isExternal) {
            Composite c = SWTFactory.createComposite((Composite)composite, (int)2, (int)1, (int)768);
            SWTFactory.createLabel((Composite)c, (String)"External server root", (int)1);
            this.externalUrlPrefixText = SWTFactory.createSingleText((Composite)c, (int)1);
            this.externalUrlPrefixTextCache = WebAppProjectProperties.getLaunchConfigExternalUrlPrefix((IProject)this.project);
            this.externalUrlPrefixText.setText(this.externalUrlPrefixTextCache);
            this.externalUrlPrefixText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LegacyGWTHostPageSelectionDialog.this.externalUrlPrefixTextCache = LegacyGWTHostPageSelectionDialog.this.externalUrlPrefixText.getText();
                    LegacyGWTHostPageSelectionDialog.this.updateOKStatus();
                }
            });
            this.useHostPageCheckbox = new Button(c, 32);
            this.useHostPageCheckbox.setText("Select a host page:");
            this.useHostPageCheckbox.setSelection(!this.isEmpty);
            this.useHostPageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LegacyGWTHostPageSelectionDialog.this.useHostPage = LegacyGWTHostPageSelectionDialog.this.useHostPageCheckbox.getSelection();
                    Tree tree = LegacyGWTHostPageSelectionDialog.this.getTreeViewer().getTree();
                    if (!LegacyGWTHostPageSelectionDialog.this.useHostPage) {
                        tree.setEnabled(false);
                    } else {
                        tree.setEnabled(!LegacyGWTHostPageSelectionDialog.this.isEmpty);
                    }
                    LegacyGWTHostPageSelectionDialog.this.updateOKStatus();
                }
            });
        }
        return label;
    }

    protected void updateStatus(IStatus status) {
        if (this.isEmpty) {
            super.updateStatus(NO_HOST_PAGES_STATUS);
        } else if (!this.useHostPage) {
            super.updateStatus(OK_STATUS);
        } else {
            super.updateStatus(status);
        }
    }

    private String getExternalUrlPrefix() {
        if (this.isExternal) {
            return this.externalUrlPrefixTextCache.trim();
        }
        return "";
    }

    private String getUrl() {
        LegacyGWTHostPageSelectionTreeItem selection = (LegacyGWTHostPageSelectionTreeItem)this.getFirstResult();
        Path url = Path.EMPTY;
        if (selection != null && selection.isHostPage()) {
            url = new Path(selection.getParent().getPath().toPortableString().replace('/', '.'));
            url = url.append(selection.getPath());
        }
        String urlString = url.toOSString();
        String externalURLPrefix = this.getExternalUrlPrefix();
        if (!(externalURLPrefix.length() <= 0 || url.equals((Object)Path.EMPTY) || externalURLPrefix.endsWith("/") || urlString.startsWith("/"))) {
            externalURLPrefix = String.valueOf(externalURLPrefix) + '/';
        }
        String firstSegment = new Path(externalURLPrefix).segment(0);
        if (!externalURLPrefix.startsWith("http://") && firstSegment != null && firstSegment.indexOf(58) >= 0) {
            try {
                externalURLPrefix = new URL("http://" + externalURLPrefix).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return String.valueOf(externalURLPrefix) + urlString;
    }

    private static class LegacyGWTHostPageSelectionContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private LegacyGWTHostPageSelectionContentProvider() {
        }

        public Object[] getChildren(Object element) {
            return ((LegacyGWTHostPageSelectionTreeItem)element).getChildren();
        }

        public Object getParent(Object element) {
            return ((LegacyGWTHostPageSelectionTreeItem)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private static class LegacyGWTHostPageSelectionTreeItem {
        private final List<LegacyGWTHostPageSelectionTreeItem> children = new ArrayList<LegacyGWTHostPageSelectionTreeItem>();
        private final IPath path;
        private final LegacyGWTHostPageSelectionTreeItem parent;

        static LegacyGWTHostPageSelectionTreeItem[] buildTree(Map<String, Set<String>> modulesHostPages) {
            ArrayList<LegacyGWTHostPageSelectionTreeItem> treeItems = new ArrayList<LegacyGWTHostPageSelectionTreeItem>();
            for (String moduleName : modulesHostPages.keySet()) {
                LegacyGWTHostPageSelectionTreeItem moduleItem = new LegacyGWTHostPageSelectionTreeItem(Path.fromPortableString((String)moduleName.replace('.', '/')));
                treeItems.add(moduleItem);
                for (String hostPage : modulesHostPages.get(moduleName)) {
                    new LegacyGWTHostPageSelectionTreeItem(Path.fromPortableString((String)hostPage), moduleItem);
                }
            }
            return treeItems.toArray(new LegacyGWTHostPageSelectionTreeItem[0]);
        }

        public LegacyGWTHostPageSelectionTreeItem(IPath modulePath) {
            this.parent = null;
            this.path = modulePath;
        }

        public LegacyGWTHostPageSelectionTreeItem(IPath hostPagePath, LegacyGWTHostPageSelectionTreeItem parentModule) {
            this.parent = parentModule;
            this.parent.children.add(this);
            this.path = hostPagePath;
        }

        public LegacyGWTHostPageSelectionTreeItem[] getChildren() {
            return this.children.toArray(new LegacyGWTHostPageSelectionTreeItem[0]);
        }

        public LegacyGWTHostPageSelectionTreeItem getParent() {
            return this.parent;
        }

        public IPath getPath() {
            return this.path;
        }

        public boolean isHostPage() {
            return this.parent != null;
        }
    }

    private static class LegacyHostPageSelectionLabelProvider
    extends LabelProvider {
        private LegacyHostPageSelectionLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            LegacyGWTHostPageSelectionTreeItem item = (LegacyGWTHostPageSelectionTreeItem)element;
            IPath itemPath = item.getPath();
            if (item.getParent() == null) {
                return String.valueOf(itemPath.lastSegment()) + " - " + itemPath.removeLastSegments(1).toPortableString().replace('/', '.');
            }
            return itemPath.toPortableString();
        }
    }

    private static class LegacyHostPageSelectionStatusValidator
    implements ISelectionStatusValidator {
        private LegacyHostPageSelectionStatusValidator() {
        }

        public IStatus validate(Object[] selection) {
            LegacyGWTHostPageSelectionTreeItem selectedItem;
            if (selection.length == 1 && (selectedItem = (LegacyGWTHostPageSelectionTreeItem)selection[0]).isHostPage()) {
                return OK_STATUS;
            }
            return new Status(4, "com.gwtplugins.gwt.eclipse.core", "");
        }
    }
}

