/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.ui;

import com.google.gdt.eclipse.core.AdapterUtilities;
import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.SWTUtilities;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gdt.eclipse.core.properties.WebAppProjectProperties;
import com.google.gwt.eclipse.core.GWTPluginLog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.osgi.service.prefs.BackingStoreException;

public class WebAppHostPageSelectionDialog
extends FilteredResourcesSelectionDialog {
    private static final String URL_LABEL_TEXT = "Final URL: ";
    private static final IStatus OK_STATUS = new Status(0, "com.gwtplugins.gwt.eclipse.core", "");
    private Text externalUrlPrefixText;
    private String externalUrlPrefixTextCache;
    private Group fileSelectionGroup;
    private final boolean isExternal;
    private IStatus oldStatus;
    private final IProject project;
    private IStatus status;
    private boolean useFile = true;
    private Button useProjectFileCheckbox;
    private Label urlLabel;
    private IFile currentSelection;
    private final IFolder warFolder;

    public static String show(IJavaProject javaProject, boolean isExternal) {
        block4: {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            try {
                WebAppHostPageSelectionDialog dialog;
                IProject project = javaProject.getProject();
                WebAppUtilities.verifyIsWebApp((IProject)project);
                IFolder warFolder = WebAppUtilities.getWarSrc((IProject)project);
                if (!warFolder.exists() || (dialog = new WebAppHostPageSelectionDialog(shell, javaProject, warFolder, isExternal)).open() != 0) break block4;
                Object[] result = dialog.getResult();
                IFile htmlFile = dialog.getSelectedFile(result);
                try {
                    WebAppProjectProperties.setLaunchConfigExternalUrlPrefix((IProject)project, (String)dialog.getExternalUrlPrefix());
                }
                catch (BackingStoreException e) {
                    GWTPluginLog.logError(e);
                }
                return dialog.getUrl(warFolder, htmlFile);
            }
            catch (CoreException e) {
                CorePluginLog.logError((Throwable)e);
            }
        }
        return null;
    }

    private WebAppHostPageSelectionDialog(Shell shell, IJavaProject project, IFolder warFolder, boolean isExternal) {
        super(shell, false, (IContainer)project.getProject(), 1);
        assert (warFolder != null);
        this.project = project.getProject();
        this.isExternal = isExternal;
        this.warFolder = warFolder;
        this.setTitle("HTML Page Selection");
        this.setMessage("");
    }

    protected Control createDialogArea(Composite parent) {
        SWTFactory.createVerticalSpacer((Composite)parent, (int)16);
        if (this.isExternal) {
            this.createExternalUI(parent);
        }
        this.fileSelectionGroup = new Group(parent, 16);
        GridData gd = new GridData(1808);
        this.fileSelectionGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fileSelectionGroup.setLayout((Layout)layout);
        Control controlToReturn = super.createDialogArea((Composite)this.fileSelectionGroup);
        SWTFactory.createVerticalSpacer((Composite)parent, (int)8);
        Composite urlComposite = new Composite(parent, 0);
        urlComposite.setLayout((Layout)layout);
        urlComposite.setLayoutData((Object)new GridData(768));
        new Label(urlComposite, 0).setText(URL_LABEL_TEXT);
        gd = new GridData(768);
        Group urlGroup = new Group(urlComposite, 16);
        urlGroup.setLayoutData((Object)gd);
        urlGroup.setLayout((Layout)layout);
        gd = new GridData(1808);
        this.urlLabel = new Label((Composite)urlGroup, 0);
        this.urlLabel.setLayoutData((Object)gd);
        return controlToReturn;
    }

    protected Control createExternalRootContentArea(Composite parent) {
        Composite c = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)768);
        SWTFactory.createLabel((Composite)c, (String)"External server root:", (int)1);
        this.externalUrlPrefixText = SWTFactory.createSingleText((Composite)c, (int)1);
        this.externalUrlPrefixTextCache = WebAppProjectProperties.getLaunchConfigExternalUrlPrefix((IProject)this.project);
        this.externalUrlPrefixText.setText(this.externalUrlPrefixTextCache);
        this.externalUrlPrefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebAppHostPageSelectionDialog.this.externalUrlPrefixTextCache = WebAppHostPageSelectionDialog.this.externalUrlPrefixText.getText();
                WebAppHostPageSelectionDialog.this.updateUrlLabelText();
            }
        });
        return c;
    }

    protected void createExternalUI(Composite parent) {
        this.createExternalRootContentArea(parent);
        SWTFactory.createVerticalSpacer((Composite)parent, (int)16);
        this.useProjectFileCheckbox = new Button(parent, 32);
        this.useProjectFileCheckbox.setText("Select an HTML page:");
        this.useProjectFileCheckbox.setSelection(true);
        this.useProjectFileCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = WebAppHostPageSelectionDialog.this.useProjectFileCheckbox.getSelection();
                WebAppHostPageSelectionDialog.this.useFile = enabled;
                SWTUtilities.setEnabledRecursive((Control)WebAppHostPageSelectionDialog.this.fileSelectionGroup, (boolean)enabled);
                if (enabled) {
                    WebAppHostPageSelectionDialog.this.updateStatus(WebAppHostPageSelectionDialog.this.oldStatus);
                } else {
                    if (WebAppHostPageSelectionDialog.this.status != null) {
                        WebAppHostPageSelectionDialog.this.oldStatus = WebAppHostPageSelectionDialog.this.status;
                    } else {
                        WebAppHostPageSelectionDialog.this.oldStatus = OK_STATUS;
                    }
                    WebAppHostPageSelectionDialog.this.updateStatus(OK_STATUS);
                }
                WebAppHostPageSelectionDialog.this.updateUrlLabelText();
            }
        });
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new HostPageFilter();
    }

    protected IFile getSelectedFile(Object[] result) {
        if (result.length == 1 && result[0] instanceof IFile) {
            return (IFile)result[0];
        }
        return null;
    }

    protected String getUrl(IFolder warFolder, IFile selectedFile) {
        String externalURLPrefix;
        if (!this.isExternal && this.useFile) {
            if (selectedFile == null) {
                return null;
            }
            return selectedFile.getName();
        }
        String url = "";
        if (this.useFile && selectedFile != null) {
            url = selectedFile.getFullPath().removeFirstSegments(warFolder.getFullPath().segmentCount()).toString();
        }
        if ((externalURLPrefix = this.getExternalUrlPrefix()).length() > 0 && !externalURLPrefix.endsWith("/")) {
            externalURLPrefix = String.valueOf(externalURLPrefix) + '/';
        }
        return String.valueOf(externalURLPrefix) + url;
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        Object[] objs = selection.toArray();
        this.currentSelection = objs.length == 1 ? (objs[0] instanceof IFile ? (IFile)objs[0] : null) : null;
        this.updateUrlLabelText();
    }

    protected void updateStatus(IStatus status) {
        this.status = status;
        super.updateStatus(status);
    }

    protected void updateUrlLabelText() {
        String url = this.getUrl(this.warFolder, this.currentSelection);
        if (url == null) {
            url = "";
        }
        this.urlLabel.setText(url);
    }

    private String getExternalUrlPrefix() {
        if (this.isExternal) {
            return this.externalUrlPrefixTextCache.trim();
        }
        return "";
    }

    private class HostPageFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        public HostPageFilter() {
            super((FilteredResourcesSelectionDialog)WebAppHostPageSelectionDialog.this);
            this.patternMatcher.setPattern(String.valueOf(this.patternMatcher.getPattern()) + "*");
        }

        public boolean matchItem(Object item) {
            IFile file = (IFile)AdapterUtilities.getAdapter((Object)item, IFile.class);
            if (!super.matchItem(item) || file == null) {
                return false;
            }
            if (!ResourceUtils.hasJspOrHtmlExtension((IResource)file)) {
                return false;
            }
            return WebAppHostPageSelectionDialog.this.warFolder.equals((Object)file.getParent());
        }
    }
}

