/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.ui.tabs;

import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTJUnitLaunchDelegate;
import com.google.gwt.eclipse.core.launch.GWTLaunchConstants;
import com.google.gwt.eclipse.core.launch.processors.LogLevelArgumentProcessor;
import com.google.gwt.eclipse.core.launch.util.GWTJUnitLaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class GWTJUnitSettingsTab
extends JavaLaunchTab {
    private Button notHeadlessButton;
    private Button webModeButton;
    private Button standardsModeButton;
    private ComboViewer logLevelComboViewer;
    private ComboViewer outputStyleComboViewer;
    private Composite comp;
    private Text outputDirectoryField;
    private SettingChangedListener settingChangedListener = new SettingChangedListener();

    public void createControl(Composite parent) {
        this.comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)this.comp.getLayout()).verticalSpacing = 0;
        this.setControl((Control)this.comp);
        this.createVerticalSpacer(this.comp, 1);
        this.createGWTJUnitSettingsComponent(this.comp);
        SWTFactory.createHorizontalSpacer((Composite)this.comp, (int)1);
    }

    public Image getImage() {
        return GWTPlugin.getDefault().getImage("com.gwtplugins.gwt.eclipse.core.images.gwtIcon");
    }

    public String getName() {
        return "GWT JUnit";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.initializeLogLevel(config);
        this.initializeOutputStyle(config);
        this.initializeNotHeadless(config);
        this.initializeWebMode(config);
        this.initializeStandardsMode(config);
        this.initializeOutputDirectory(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        StructuredSelection logLevelSelection = (StructuredSelection)this.logLevelComboViewer.getSelection();
        config.setAttribute("com.gwtplugins.gwt.eclipse.core.LOG_LEVEL", logLevelSelection.getFirstElement().toString());
        StructuredSelection outputStyleSelection = (StructuredSelection)this.outputStyleComboViewer.getSelection();
        config.setAttribute("com.gwtplugins.gwt.eclipse.core.STYLE", outputStyleSelection.getFirstElement().toString());
        config.setAttribute("com.gwtplugins.gwt.eclipse.core.NOT_HEADLESS", this.notHeadlessButton.getSelection());
        config.setAttribute("com.gwtplugins.gwt.eclipse.core.WEB_MODE", Boolean.toString(this.webModeButton.getSelection()));
        config.setAttribute("com.gwtplugins.gwt.eclipse.core.STANDARDS_MODE", this.standardsModeButton.getSelection());
        config.setAttribute("com.gwtplugins.gwt.eclipse.core.OUT_DIR", this.outputDirectoryField.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        GWTJUnitLaunchUtils.setDefaults(configuration);
    }

    protected void createGWTJUnitSettingsComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"GWT JUnit Settings", (int)2, (int)1, (int)768);
        SWTFactory.createLabel((Composite)group, (String)"Log level:", (int)1);
        this.logLevelComboViewer = new ComboViewer((Composite)group, 8);
        this.logLevelComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.logLevelComboViewer.setLabelProvider((IBaseLabelProvider)new DefaultComboLabelProvider());
        this.logLevelComboViewer.setInput((Object)LogLevelArgumentProcessor.LOG_LEVELS);
        this.logLevelComboViewer.addSelectionChangedListener((ISelectionChangedListener)this.settingChangedListener);
        SWTFactory.createLabel((Composite)group, (String)"Output style:", (int)1);
        this.outputStyleComboViewer = new ComboViewer((Composite)group, 8);
        this.outputStyleComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.outputStyleComboViewer.setLabelProvider((IBaseLabelProvider)new DefaultComboLabelProvider());
        this.outputStyleComboViewer.setInput((Object)GWTLaunchConstants.OUTPUT_STYLES);
        this.outputStyleComboViewer.addSelectionChangedListener((ISelectionChangedListener)this.settingChangedListener);
        this.notHeadlessButton = SWTFactory.createCheckButton((Composite)group, (String)"Display the log window and browser windows (useful for debugging)", null, (boolean)true, (int)2);
        this.notHeadlessButton.addSelectionListener((SelectionListener)this.settingChangedListener);
        this.webModeButton = SWTFactory.createCheckButton((Composite)group, (String)"Run tests in production mode", null, (boolean)false, (int)2);
        this.webModeButton.addSelectionListener((SelectionListener)this.settingChangedListener);
        this.standardsModeButton = SWTFactory.createCheckButton((Composite)group, (String)"Use standards mode", null, (boolean)false, (int)2);
        this.standardsModeButton.addSelectionListener((SelectionListener)this.settingChangedListener);
        GridData standardsModeButtonData = new GridData(1, 1, false, false, 2, 1);
        this.standardsModeButton.setLayoutData((Object)standardsModeButtonData);
        SWTFactory.createLabel((Composite)group, (String)"Output directory:", (int)1);
        this.outputDirectoryField = new Text((Composite)group, 2048);
        this.outputDirectoryField.setLayoutData((Object)new GridData(768));
        this.outputDirectoryField.addModifyListener((ModifyListener)this.settingChangedListener);
    }

    private void initializeLogLevel(ILaunchConfiguration config) {
        String logLevel = GWTLaunchConstants.Defaults.LOG_LEVEL;
        try {
            logLevel = config.getAttribute("com.gwtplugins.gwt.eclipse.core.LOG_LEVEL", logLevel);
        }
        catch (CoreException ce) {
            GWTPluginLog.logError(ce);
        }
        this.logLevelComboViewer.setSelection((ISelection)new StructuredSelection((Object)logLevel));
    }

    private void initializeNotHeadless(ILaunchConfiguration config) {
        boolean notHeadless = false;
        try {
            notHeadless = config.getAttribute("com.gwtplugins.gwt.eclipse.core.NOT_HEADLESS", notHeadless);
        }
        catch (CoreException ce) {
            GWTPluginLog.logError(ce);
        }
        this.notHeadlessButton.setSelection(notHeadless);
    }

    private void initializeOutputDirectory(ILaunchConfiguration config) {
        String outDir = "www-test";
        try {
            outDir = config.getAttribute("com.gwtplugins.gwt.eclipse.core.OUT_DIR", outDir);
        }
        catch (CoreException ce) {
            GWTPluginLog.logError(ce);
        }
        this.outputDirectoryField.setText(outDir);
    }

    private void initializeOutputStyle(ILaunchConfiguration config) {
        String outStyle = GWTLaunchConstants.Defaults.OBFUSCATION;
        try {
            outStyle = config.getAttribute("com.gwtplugins.gwt.eclipse.core.STYLE", outStyle);
        }
        catch (CoreException ce) {
            GWTPluginLog.logError(ce);
        }
        this.outputStyleComboViewer.setSelection((ISelection)new StructuredSelection((Object)outStyle));
    }

    private void initializeStandardsMode(ILaunchConfiguration config) {
        block2: {
            this.standardsModeButton.setSelection(GWTJUnitLaunchDelegate.getStandardsMode(config));
            try {
                boolean visible = GWTJUnitLaunchDelegate.isGwtSdkVersionAtLeast("2.0.0", config);
                this.standardsModeButton.setVisible(visible);
                GridData layoutData = (GridData)this.standardsModeButton.getLayoutData();
                layoutData.exclude = !visible;
            }
            catch (CoreException e) {
                if (e.getStatus().getSeverity() <= 1) break block2;
                GWTPluginLog.logWarning(e, "Could not determine whether standards mode checkbox should be visible");
            }
        }
    }

    private void initializeWebMode(ILaunchConfiguration config) {
        String webMode = "false";
        try {
            webMode = config.getAttribute("com.gwtplugins.gwt.eclipse.core.WEB_MODE", webMode);
            assert ("true".equals(webMode) || "false".equals(webMode));
        }
        catch (CoreException ce) {
            GWTPluginLog.logError(ce);
        }
        this.webModeButton.setSelection(Boolean.parseBoolean(webMode));
    }

    private static class DefaultComboLabelProvider
    extends LabelProvider {
        private DefaultComboLabelProvider() {
        }

        public String getText(Object element) {
            String element2 = (String)element;
            return String.valueOf(element2.toUpperCase().charAt(0)) + element2.toLowerCase().substring(1);
        }
    }

    private class SettingChangedListener
    extends SelectionAdapter
    implements ModifyListener,
    ISelectionChangedListener {
        private SettingChangedListener() {
        }

        public void modifyText(ModifyEvent e) {
            GWTJUnitSettingsTab.this.updateLaunchConfigurationDialog();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            GWTJUnitSettingsTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            GWTJUnitSettingsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

