/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.ui.tabs;

import com.google.gdt.eclipse.core.SWTUtilities;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchArgumentsContainer;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gdt.eclipse.core.launch.UpdateLaunchConfigurationDialogBatcher;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfigurationWorkingCopy;
import com.google.gwt.eclipse.core.launch.LegacyGWTLaunchShortcutStrategy;
import com.google.gwt.eclipse.core.launch.WebAppLaunchShortcutStrategy;
import com.google.gwt.eclipse.core.launch.processors.DevModeCodeServerPortArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.LogLevelArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.ModuleArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.NoServerArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.RemoteUiArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.StartupUrlArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.SuperDevModeArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.XStartOnFirstThreadArgumentProcessor;
import com.google.gwt.eclipse.core.launch.ui.EntryPointModulesSelectionBlock;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;

public class GWTSettingsTab
extends JavaLaunchTab
implements ILaunchArgumentsContainer.ArgumentsListener,
UpdateLaunchConfigurationDialogBatcher.Listener {
    protected Composite comp;
    protected DevelopmentModeBlock developmentModeBlock;
    protected EntryPointModulesSelectionBlock entryPointModulesSelectionBlock;
    protected Button performGwtCompileButton;
    protected SelectionBlock selectionBlock;
    protected boolean updateLaunchConfigurationDialogBlock;
    protected UrlSelectionBlock urlSelectionBlock;
    private final boolean showDevelopmentModeBlock;
    private final boolean showPerformGwtCompileSetting;
    private final boolean showUrlSelectionBlock;
    private final UpdateLaunchConfigurationDialogBatcher updateLaunchConfigurationDialogBatcher = new UpdateLaunchConfigurationDialogBatcher((UpdateLaunchConfigurationDialogBatcher.Listener)this);

    public GWTSettingsTab(ILaunchArgumentsContainer argsContainer) {
        this(argsContainer, true, true, false);
    }

    public GWTSettingsTab(ILaunchArgumentsContainer argsContainer, boolean showDevelopmentModeBlock, boolean showUrlSelectionBlock, boolean showPerformGwtCompileSetting) {
        this.showDevelopmentModeBlock = showDevelopmentModeBlock;
        this.showUrlSelectionBlock = showUrlSelectionBlock;
        this.showPerformGwtCompileSetting = showPerformGwtCompileSetting;
        if (argsContainer != null) {
            this.registerProgramArgsListener(argsContainer);
        }
    }

    protected GWTSettingsTab() {
        this(null, true, true, false);
    }

    public void callSuperUpdateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite parent) {
        this.comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)this.comp.getLayout()).verticalSpacing = 0;
        this.setControl((Control)this.comp);
        this.createVerticalSpacer(this.comp, 1);
        this.selectionBlock = new SelectionBlock(this.comp);
        this.createVerticalSpacer(this.comp, 1);
        if (this.showUrlSelectionBlock) {
            this.createVerticalSpacer(this.comp, 1);
            this.urlSelectionBlock = new UrlSelectionBlock(this.comp);
        }
        if (this.showDevelopmentModeBlock) {
            this.createVerticalSpacer(this.comp, 1);
            this.developmentModeBlock = new DevelopmentModeBlock(this.comp);
        }
        if (this.showPerformGwtCompileSetting) {
            this.createVerticalSpacer(this.comp, 1);
            this.performGwtCompileButton = SWTFactory.createCheckButton((Composite)this.comp, (String)"Perform GWT compile", null, (boolean)true, (int)1);
            this.performGwtCompileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GWTSettingsTab.this.updateLaunchConfigurationDialog();
                    GWTSettingsTab.this.updateEnabledState();
                }
            });
        }
        this.createVerticalSpacer(this.comp, 1);
        this.createStartupModuleComponent(this.comp);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.updateLaunchConfigurationDialogBatcher.deactivatedCalled(workingCopy);
        super.deactivated(workingCopy);
    }

    public void dispose() {
        this.updateLaunchConfigurationDialogBatcher.disposeCalled();
        super.dispose();
    }

    public void doPerformApply(ILaunchConfigurationWorkingCopy configuration) {
        this.persistModules(configuration, this.entryPointModulesSelectionBlock.getModules());
        LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new ModuleArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
        if (this.selectionBlock != null) {
            this.selectionBlock.performApply(configuration);
        }
        if (this.developmentModeBlock != null) {
            this.developmentModeBlock.performApply(configuration);
        }
        if (this.urlSelectionBlock != null) {
            this.urlSelectionBlock.performApply(configuration);
        }
        this.enableSuperDevModeSelection(configuration);
    }

    public Image getImage() {
        return GWTPlugin.getDefault().getImage("com.gwtplugins.gwt.eclipse.core.images.gwtIcon");
    }

    public String getName() {
        return "GWT";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateLaunchConfigurationDialogBlock = true;
        IJavaProject javaProject = null;
        try {
            super.initializeFrom(config);
            try {
                if (this.selectionBlock != null) {
                    this.selectionBlock.initializeFrom(config);
                }
                if (this.developmentModeBlock != null) {
                    this.developmentModeBlock.initializeFrom(config);
                    this.developmentModeBlock.setTitle();
                }
                if (this.urlSelectionBlock != null) {
                    this.urlSelectionBlock.initializeFrom(config);
                }
                javaProject = this.getJavaProject();
                this.entryPointModulesSelectionBlock.setJavaProject(javaProject);
                if (javaProject != null) {
                    IProject project = javaProject.getProject();
                    this.entryPointModulesSelectionBlock.setDefaultModules(ModuleArgumentProcessor.getDefaultModules(project, config));
                    List<String> launchConfigModules = GWTLaunchConfiguration.getEntryPointModules(config);
                    this.entryPointModulesSelectionBlock.setModules(launchConfigModules);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.maybeGrayControls(javaProject);
            this.updateEnabledState();
        }
        finally {
            this.updateLaunchConfigurationDialogBlock = false;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (!((Object)((Object)this)).equals(this.getLaunchConfigurationDialog().getActiveTab())) {
            return;
        }
        this.doPerformApply(configuration);
    }

    public void persistFromArguments(List<String> args, ILaunchConfigurationWorkingCopy config) {
        String logLevel = LogLevelArgumentProcessor.getValidLogLevel(args);
        GWTLaunchConfigurationWorkingCopy.setLogLevel(config, logLevel);
        try {
            List<String> modules = ModuleArgumentProcessor.getModules(args, (ILaunchConfiguration)config, this.getProject());
            this.persistModules(config, modules);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e, "Could not persist entry point modules");
        }
        try {
            String startupUrl = StartupUrlArgumentProcessor.getStartupUrl(args, this.getCurrentLaunchConfiguration());
            GWTLaunchConfigurationWorkingCopy.setStartupUrl(config, startupUrl);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e, "Could not persist startup URL");
        }
        String port = DevModeCodeServerPortArgumentProcessor.getPort(args);
        if (port.equalsIgnoreCase("auto")) {
            GWTLaunchConfigurationWorkingCopy.setClassicDevModeCodeServerPortAuto(config, true);
        } else {
            GWTLaunchConfigurationWorkingCopy.setClassicDevModeCodeServerPort(config, port);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void createStartupModuleComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"Available Modules:", (int)3, (int)1, (int)1808);
        GridLayout groupLayout = (GridLayout)group.getLayout();
        groupLayout.marginBottom = 8;
        group.setLayout((Layout)groupLayout);
        EntryPointModulesSelectionBlock.IModulesChangeListener listener = new EntryPointModulesSelectionBlock.IModulesChangeListener(){

            @Override
            public void onModulesChanged() {
                GWTSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.entryPointModulesSelectionBlock = new EntryPointModulesSelectionBlock(listener);
        this.entryPointModulesSelectionBlock.doFillIntoGrid((Composite)group, 3);
    }

    protected IJavaProject getJavaProject() throws CoreException {
        return JavaRuntime.getJavaProject((ILaunchConfiguration)this.getCurrentLaunchConfiguration());
    }

    protected void maybeGrayControls(IJavaProject javaProject) {
        boolean isGWTProject = javaProject != null && GWTNature.isGWTProject(javaProject.getProject());
        String message = isGWTProject ? null : "GWT is not enabled for this project. You can enable it in the project's properties.";
        this.setMessage(message);
        SWTUtilities.setEnabledRecursive((Control)this.comp, (boolean)isGWTProject);
    }

    protected void persistModules(ILaunchConfigurationWorkingCopy configuration, List<String> modules) {
        GWTLaunchConfigurationWorkingCopy.setEntryPointModules(configuration, modules, Collections.emptyList());
    }

    protected void registerProgramArgsListener(ILaunchArgumentsContainer argsContainer) {
        argsContainer.registerProgramArgsListener((ILaunchArgumentsContainer.ArgumentsListener)this);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.updateLaunchConfigurationDialogBlock) {
            this.updateLaunchConfigurationDialogBatcher.updateLaunchConfigurationDialogCalled();
        }
    }

    private boolean canSdkVersionUseSuperDevMode(String version) {
        return version.matches("^2.[5-9].*") || version.matches("^[3-9].*");
    }

    private void enableSuperDevModeSelection(ILaunchConfigurationWorkingCopy configuration) {
        GwtSdk sdk = null;
        try {
            sdk = GwtSdk.findSdkFor(this.getJavaProject());
        }
        catch (CoreException e) {
            this.selectionBlock.setVisible(false);
        }
        String version = sdk.getVersion();
        if (this.canSdkVersionUseSuperDevMode(version)) {
            this.selectionBlock.setVisible(true);
        } else {
            this.selectionBlock.setVisible(false);
            GWTLaunchConfigurationWorkingCopy.setSuperDevModeEnabled(configuration, false);
        }
        if (this.developmentModeBlock != null) {
            this.developmentModeBlock.setTitle();
        }
    }

    private IProject getProject() throws CoreException {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null || !javaProject.exists()) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", "Could not get a valid Java project"));
        }
        return javaProject.getProject();
    }

    private void updateEnabledState() {
        if (this.performGwtCompileButton != null) {
            this.entryPointModulesSelectionBlock.setEnabled(this.performGwtCompileButton.getSelection());
        }
        if (this.developmentModeBlock != null) {
            this.developmentModeBlock.updateEnabledState();
        }
    }

    private static class DefaultComboLabelProvider
    extends LabelProvider {
        private DefaultComboLabelProvider() {
        }

        public String getText(Object element) {
            String element2 = (String)element;
            return String.valueOf(element2.toUpperCase().charAt(0)) + element2.toLowerCase().substring(1);
        }
    }

    protected class DevelopmentModeBlock {
        private static final String GROUP_TITLE_DEVMODE = "Legacy Development Mode";
        private static final String GROUP_TITLE_SUPERDEVMODE = "Super Development Mode";
        private final Button buttonDevModeAutoPort;
        private final ComboViewer comboDevModeLogLevelViewer;
        private final Group groupDevMode;
        private final Text textDevModeCodeServerPort;

        public DevelopmentModeBlock(Composite parent) {
            this.groupDevMode = SWTFactory.createGroup((Composite)parent, (String)GROUP_TITLE_DEVMODE, (int)2, (int)1, (int)768);
            SWTFactory.createLabel((Composite)this.groupDevMode, (String)"Log level:", (int)1);
            this.comboDevModeLogLevelViewer = new ComboViewer((Composite)this.groupDevMode, 8);
            this.comboDevModeLogLevelViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.comboDevModeLogLevelViewer.setLabelProvider((IBaseLabelProvider)new DefaultComboLabelProvider());
            this.comboDevModeLogLevelViewer.setInput((Object)LogLevelArgumentProcessor.LOG_LEVELS);
            this.comboDevModeLogLevelViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    GWTSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            GridData serverPortLabelGridData = new GridData();
            Label serverPortLabel = new Label((Composite)this.groupDevMode, 0);
            serverPortLabel.setLayoutData((Object)serverPortLabelGridData);
            serverPortLabel.setText("Code Server Port:");
            GridData gridDataCodeServer = new GridData(768);
            gridDataCodeServer.horizontalSpan = 1;
            Composite codeServerPortComposite = new Composite((Composite)this.groupDevMode, 0);
            codeServerPortComposite.setLayout((Layout)new GridLayout(2, false));
            codeServerPortComposite.setLayoutData((Object)gridDataCodeServer);
            GridData gridDataTextCodeServer = new GridData(4, 0x1000000, false, false);
            gridDataTextCodeServer.widthHint = 75;
            this.textDevModeCodeServerPort = new Text(codeServerPortComposite, 2048);
            this.textDevModeCodeServerPort.setLayoutData((Object)gridDataTextCodeServer);
            this.textDevModeCodeServerPort.setTextLimit(5);
            this.textDevModeCodeServerPort.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GWTSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.buttonDevModeAutoPort = new Button(codeServerPortComposite, 32);
            this.buttonDevModeAutoPort.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            this.buttonDevModeAutoPort.setText("Automatically select an unused port");
            this.buttonDevModeAutoPort.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DevelopmentModeBlock.this.updateEnabledState();
                    GWTSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
        }

        public String getDevModeCodeServerPort() {
            return this.textDevModeCodeServerPort.getText();
        }

        public boolean getDevModeCodeServerPortAuto() {
            return this.buttonDevModeAutoPort.getSelection();
        }

        public String getLogLevel() {
            StructuredSelection logLevelSelection = (StructuredSelection)this.comboDevModeLogLevelViewer.getSelection();
            return logLevelSelection.getFirstElement() != null ? logLevelSelection.getFirstElement().toString() : "INFO";
        }

        public void initializeFrom(ILaunchConfiguration config) throws CoreException {
            SWTUtilities.setText((Group)this.groupDevMode, (String)GROUP_TITLE_DEVMODE);
            this.comboDevModeLogLevelViewer.setSelection((ISelection)new StructuredSelection((Object)GWTLaunchConfiguration.getLogLevel(config)));
            this.textDevModeCodeServerPort.setText(GWTLaunchConfiguration.getClassicDevModeCodeServerPort(config));
            this.buttonDevModeAutoPort.setSelection(GWTLaunchConfiguration.getClassicDevModeCodeServerPortAuto(config));
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            GWTLaunchConfigurationWorkingCopy.setLogLevel(configuration, this.getLogLevel());
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new LogLevelArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
            GWTLaunchConfigurationWorkingCopy.setClassicDevModeCodeServerPort(configuration, this.getDevModeCodeServerPort());
            GWTLaunchConfigurationWorkingCopy.setClassicDevModeCodeServerPortAuto(configuration, this.getDevModeCodeServerPortAuto());
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new DevModeCodeServerPortArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
        }

        public void setTitle() {
            if (GWTSettingsTab.this.selectionBlock != null && GWTSettingsTab.this.selectionBlock.isVisible() && GWTSettingsTab.this.selectionBlock.isSuperDevModeSelected()) {
                this.groupDevMode.setText(GROUP_TITLE_SUPERDEVMODE);
            } else {
                this.groupDevMode.setText(GROUP_TITLE_DEVMODE);
            }
        }

        public void setVisible(boolean visible) {
            this.groupDevMode.setVisible(visible);
        }

        public void updateEnabledState() {
            this.textDevModeCodeServerPort.setEnabled(!this.buttonDevModeAutoPort.getSelection() && this.buttonDevModeAutoPort.getEnabled());
        }
    }

    public static interface IGWTSettingsTabFactory {
        public GWTSettingsTab newInstance(ILaunchArgumentsContainer var1);
    }

    protected class SelectionBlock {
        private static final String GROUP_TITLE_SELECTION = "Development Mode";
        private final Button buttonDevMode;
        private final Button buttonSuperDevMode;
        private final Group groupSelection;

        public SelectionBlock(Composite parent) {
            this.groupSelection = SWTFactory.createGroup((Composite)parent, (String)GROUP_TITLE_SELECTION, (int)3, (int)1, (int)768);
            this.buttonSuperDevMode = new Button((Composite)this.groupSelection, 16);
            this.buttonSuperDevMode.setText("Super Development Mode");
            this.buttonDevMode = new Button((Composite)this.groupSelection, 16);
            this.buttonDevMode.setSelection(true);
            this.buttonDevMode.setText("Legacy Development Mode");
            this.buttonSuperDevMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((SelectionBlock)SelectionBlock.this).GWTSettingsTab.this.developmentModeBlock != null) {
                        ((SelectionBlock)SelectionBlock.this).GWTSettingsTab.this.developmentModeBlock.setTitle();
                    }
                    GWTSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.buttonDevMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((SelectionBlock)SelectionBlock.this).GWTSettingsTab.this.developmentModeBlock != null) {
                        ((SelectionBlock)SelectionBlock.this).GWTSettingsTab.this.developmentModeBlock.setTitle();
                    }
                    GWTSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            Link link = new Link((Composite)this.groupSelection, 0);
            link.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 1));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String surl = "http://gwt-plugins.github.io/documentation/gwt-eclipse-plugin/GettingStarted.html";
                    SelectionBlock.this.gotoUrl(surl);
                }
            });
            link.setToolTipText("Find out how to use GWT with Eclipse.");
            link.setText("<a>GWT Eclipse Help</a>");
        }

        public void initializeFrom(ILaunchConfiguration config) throws CoreException {
            SWTUtilities.setText((Group)this.groupSelection, (String)GROUP_TITLE_SELECTION);
            boolean enabled = GWTLaunchConfiguration.getSuperDevModeEnabled(config);
            this.setSdmRadioEnabled(enabled);
        }

        public void setSdmRadioEnabled(boolean enabled) {
            this.buttonSuperDevMode.setSelection(enabled);
            this.buttonDevMode.setSelection(!enabled);
        }

        public boolean isSuperDevModeSelected() {
            return this.buttonSuperDevMode.getSelection();
        }

        public void resetSdmRadio(ILaunchConfigurationWorkingCopy configuration) {
            this.setSdmRadioEnabled(true);
            GWTLaunchConfigurationWorkingCopy.setSuperDevModeEnabled(configuration, true);
            if (GWTSettingsTab.this.developmentModeBlock != null) {
                GWTSettingsTab.this.developmentModeBlock.setTitle();
            }
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            GWTLaunchConfigurationWorkingCopy.setSuperDevModeEnabled(configuration, GWTSettingsTab.this.selectionBlock.isSuperDevModeSelected());
            try {
                configuration.doSave();
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"Error saving project", (String)"Please try hitting apply agian.");
            }
            this.updateArgumentProcessors(configuration);
        }

        public void setVisible(boolean visible) {
            this.groupSelection.setVisible(visible);
        }

        public boolean isVisible() {
            return this.groupSelection.isVisible();
        }

        public void updateArgumentProcessors(ILaunchConfigurationWorkingCopy configuration) {
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new SuperDevModeArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new RemoteUiArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new LogLevelArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new DevModeCodeServerPortArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new StartupUrlArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new XStartOnFirstThreadArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
        }

        private void gotoUrl(String surl) {
            try {
                URL url = new URL(surl);
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
            }
            catch (PartInitException ex) {
                MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"URL Error", (String)("Error navigating to " + surl));
            }
            catch (MalformedURLException ex) {
                MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"URL Error", (String)("Error navigating to " + surl));
            }
        }
    }

    protected class UrlSelectionBlock {
        private final Group browserGroup;
        private final Text urlField;

        public UrlSelectionBlock(Composite parent) {
            this.browserGroup = SWTFactory.createGroup((Composite)parent, (String)"Browsers:", (int)3, (int)1, (int)768);
            SWTFactory.createLabel((Composite)this.browserGroup, (String)"URL:", (int)1);
            this.urlField = SWTFactory.createSingleText((Composite)this.browserGroup, (int)1);
            this.urlField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GWTSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            Button urlBrowseButton = GWTSettingsTab.this.createPushButton((Composite)this.browserGroup, "&Browse...", null);
            urlBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        IJavaProject javaProject = GWTSettingsTab.this.getJavaProject();
                        if (javaProject == null) {
                            MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"No project found", (String)"Please make sure that this launch configuration has a valid project assigned.");
                            return;
                        }
                        Object strategy = WebAppUtilities.isWebApp((IProject)javaProject.getProject()) ? new WebAppLaunchShortcutStrategy() : new LegacyGWTLaunchShortcutStrategy();
                        String urlFromUser = strategy.getUrlFromUser((IResource)GWTSettingsTab.this.getJavaProject().getProject(), false);
                        if (urlFromUser != null) {
                            Path url = new Path(urlFromUser);
                            SWTUtilities.setText((Text)UrlSelectionBlock.this.urlField, (String)url.toString());
                        }
                    }
                    catch (CoreException ce) {
                        GWTPluginLog.logError(ce);
                        MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"Error while browsing for URL", (String)ce.getLocalizedMessage());
                    }
                }
            });
        }

        public String getUrl() {
            return this.urlField.getText();
        }

        public void initializeFrom(ILaunchConfiguration config) throws CoreException {
            boolean hasNoServerArg = NoServerArgumentProcessor.hasNoServerArg(LaunchConfigurationProcessorUtilities.parseProgramArgs((ILaunchConfiguration)config));
            boolean showStartupUrl = false;
            GridData layoutData = (GridData)this.browserGroup.getLayoutData();
            layoutData.exclude = !showStartupUrl;
            this.browserGroup.setVisible(showStartupUrl);
            SWTUtilities.setText((Text)this.urlField, (String)GWTLaunchConfiguration.getStartupUrl(config));
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            GWTLaunchConfigurationWorkingCopy.setStartupUrl(configuration, this.getUrl().trim());
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new StartupUrlArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new XStartOnFirstThreadArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
        }
    }
}

