/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.ui.tabs;

import com.google.gdt.eclipse.core.SWTUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchArgumentsContainer;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gdt.eclipse.core.launch.UpdateLaunchConfigurationDialogBatcher;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchAttributes;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfigurationWorkingCopy;
import com.google.gwt.eclipse.core.launch.processors.LogLevelArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.ModuleArgumentProcessor;
import com.google.gwt.eclipse.core.launch.ui.EntryPointModulesSelectionBlock;
import com.google.gwt.eclipse.core.launch.ui.tabs.IUpdateLaunchConfig;
import com.google.gwt.eclipse.core.launch.ui.tabs.blocks.CompilerBlock;
import com.google.gwt.eclipse.core.nature.GWTNature;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class GwtCompilerSettingsTab
extends JavaLaunchTab
implements ILaunchArgumentsContainer.ArgumentsListener,
UpdateLaunchConfigurationDialogBatcher.Listener {
    protected boolean blockUpdateLaunchConfigurationDialog;
    protected Composite comp;
    protected EntryPointModulesSelectionBlock entryPointModulesBlock;
    protected CompilerBlock compilerModeBlock;
    private final UpdateLaunchConfigurationDialogBatcher updateLaunchConfigurationDialogBatcher = new UpdateLaunchConfigurationDialogBatcher((UpdateLaunchConfigurationDialogBatcher.Listener)this);

    public GwtCompilerSettingsTab(ILaunchArgumentsContainer argsContainer) {
        if (argsContainer != null) {
            this.registerProgramArgsListener(argsContainer);
        }
    }

    protected GwtCompilerSettingsTab() {
        this(null);
    }

    public void callSuperUpdateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite parent) {
        this.comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        ((GridLayout)this.comp.getLayout()).verticalSpacing = 0;
        this.setControl((Control)this.comp);
        this.compilerModeBlock = new CompilerBlock(this.comp, 0);
        this.compilerModeBlock.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.compilerModeBlock.addUpdateLaunchConfigHandler(new IUpdateLaunchConfig(){

            @Override
            public void updateLaunchConfig() {
                GwtCompilerSettingsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createStartupModuleComponent(this.comp);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.updateLaunchConfigurationDialogBatcher.deactivatedCalled(workingCopy);
        super.deactivated(workingCopy);
    }

    public void dispose() {
        this.updateLaunchConfigurationDialogBatcher.disposeCalled();
        super.dispose();
    }

    public void doPerformApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.compilerModeBlock != null) {
            this.compilerModeBlock.performApply(configuration);
        }
        this.persistModules(configuration, this.entryPointModulesBlock.getModules());
        LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new ModuleArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public Image getImage() {
        return GWTPlugin.getDefault().getImage(".images.sdmCodeServerImage");
    }

    public String getName() {
        return "GWT";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.blockUpdateLaunchConfigurationDialog = true;
        IJavaProject javaProject = null;
        try {
            super.initializeFrom(config);
            try {
                if (this.compilerModeBlock != null) {
                    this.compilerModeBlock.initializeFrom(config);
                }
                javaProject = this.getJavaProject();
                this.entryPointModulesBlock.setJavaProject(javaProject);
                if (javaProject != null) {
                    IProject project = javaProject.getProject();
                    this.entryPointModulesBlock.setDefaultModules(ModuleArgumentProcessor.getDefaultModules(project, config));
                    List<String> launchConfigModules = GWTLaunchConfiguration.getEntryPointModules(config);
                    this.entryPointModulesBlock.setModules(launchConfigModules);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.maybeGrayControls(javaProject);
        }
        finally {
            this.blockUpdateLaunchConfigurationDialog = false;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (!((Object)((Object)this)).equals(this.getLaunchConfigurationDialog().getActiveTab())) {
            return;
        }
        this.doPerformApply(configuration);
    }

    public void persistFromArguments(List<String> args, ILaunchConfigurationWorkingCopy config) {
        String logLevel = LogLevelArgumentProcessor.getValidLogLevel(args);
        GWTLaunchConfigurationWorkingCopy.setLogLevel(config, logLevel);
        try {
            List<String> modules = ModuleArgumentProcessor.getModules(args, (ILaunchConfiguration)config, this.getProject());
            this.persistModules(config, modules);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e, "Could not persist entry point modules");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void createStartupModuleComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"Available Modules:", (int)3, (int)1, (int)1808);
        GridLayout groupLayout = (GridLayout)group.getLayout();
        groupLayout.marginBottom = 8;
        group.setLayout((Layout)groupLayout);
        EntryPointModulesSelectionBlock.IModulesChangeListener listener = new EntryPointModulesSelectionBlock.IModulesChangeListener(){

            @Override
            public void onModulesChanged() {
                GwtCompilerSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.entryPointModulesBlock = new EntryPointModulesSelectionBlock(listener);
        this.entryPointModulesBlock.doFillIntoGrid((Composite)group, 3);
    }

    protected IJavaProject getJavaProject() throws CoreException {
        return JavaRuntime.getJavaProject((ILaunchConfiguration)this.getCurrentLaunchConfiguration());
    }

    protected void maybeGrayControls(IJavaProject javaProject) {
        boolean isGWTProject = javaProject != null && GWTNature.isGWTProject(javaProject.getProject());
        String message = isGWTProject ? null : "GWT is not enabled for this project.";
        this.setMessage(message);
        SWTUtilities.setEnabledRecursive((Control)this.comp, (boolean)isGWTProject);
    }

    protected void persistModules(ILaunchConfigurationWorkingCopy configuration, List<String> modules) {
        if (modules.equals(this.entryPointModulesBlock.getDefaultModules())) {
            GWTLaunchConfigurationWorkingCopy.clearAttribute(configuration, GWTLaunchAttributes.ENTRY_POINT_MODULES);
        } else {
            GWTLaunchConfigurationWorkingCopy.setEntryPointModules(configuration, modules, Collections.emptyList());
        }
    }

    protected void registerProgramArgsListener(ILaunchArgumentsContainer argsContainer) {
        argsContainer.registerProgramArgsListener((ILaunchArgumentsContainer.ArgumentsListener)this);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.blockUpdateLaunchConfigurationDialog) {
            this.updateLaunchConfigurationDialogBatcher.updateLaunchConfigurationDialogCalled();
        }
    }

    private IProject getProject() throws CoreException {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null || !javaProject.exists()) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", "Could not get a valid Java project"));
        }
        return javaProject.getProject();
    }

    public static interface IGWTSettingsTabFactory {
        public GwtCompilerSettingsTab newInstance(ILaunchArgumentsContainer var1);
    }
}

