/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.ui.tabs;

import com.google.gdt.eclipse.core.SWTUtilities;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchArgumentsContainer;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gdt.eclipse.core.launch.UpdateLaunchConfigurationDialogBatcher;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.GWTLaunchAttributes;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfigurationWorkingCopy;
import com.google.gwt.eclipse.core.launch.LegacyGWTLaunchShortcutStrategy;
import com.google.gwt.eclipse.core.launch.WebAppLaunchShortcutStrategy;
import com.google.gwt.eclipse.core.launch.processors.LogLevelArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.ModuleArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.NoServerArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.StartupUrlArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.XStartOnFirstThreadArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.codeserver.SuperDevModeCodeServerLauncherDirArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.codeserver.SuperDevModeCodeServerPortArgumentProcessor;
import com.google.gwt.eclipse.core.launch.ui.EntryPointModulesSelectionBlock;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.Workbench;

public class GwtSuperDevModeCodeServerSettingsTab
extends JavaLaunchTab
implements ILaunchArgumentsContainer.ArgumentsListener,
UpdateLaunchConfigurationDialogBatcher.Listener {
    protected boolean blockUpdateLaunchConfigurationDialog;
    protected Composite comp;
    protected EntryPointModulesSelectionBlock entryPointModulesBlock;
    protected Button performGwtCompileButton;
    protected SdmModeBlock sdmModeBlock;
    protected UrlSelectionBlock urlSelectionBlock;
    private final boolean showDevelopmentModeBlock;
    private final boolean showPerformGwtCompileSetting;
    private final boolean showUrlSelectionBlock;
    private final UpdateLaunchConfigurationDialogBatcher updateLaunchConfigurationDialogBatcher = new UpdateLaunchConfigurationDialogBatcher((UpdateLaunchConfigurationDialogBatcher.Listener)this);

    public GwtSuperDevModeCodeServerSettingsTab(ILaunchArgumentsContainer argsContainer) {
        this(argsContainer, true, true, false);
    }

    public GwtSuperDevModeCodeServerSettingsTab(ILaunchArgumentsContainer argsContainer, boolean showDevelopmentModeBlock, boolean showUrlSelectionBlock, boolean showPerformGwtCompileSetting) {
        this.showDevelopmentModeBlock = showDevelopmentModeBlock;
        this.showUrlSelectionBlock = showUrlSelectionBlock;
        this.showPerformGwtCompileSetting = showPerformGwtCompileSetting;
        if (argsContainer != null) {
            this.registerProgramArgsListener(argsContainer);
        }
    }

    protected GwtSuperDevModeCodeServerSettingsTab() {
        this(null, true, true, false);
    }

    public void callSuperUpdateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite parent) {
        this.comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)2, (int)1808);
        ((GridLayout)this.comp.getLayout()).verticalSpacing = 0;
        this.setControl((Control)this.comp);
        if (this.showUrlSelectionBlock) {
            this.createVerticalSpacer(this.comp, 1);
            this.urlSelectionBlock = new UrlSelectionBlock(this.comp);
        }
        if (this.showDevelopmentModeBlock) {
            this.createVerticalSpacer(this.comp, 1);
            this.sdmModeBlock = new SdmModeBlock(this.comp);
        }
        if (this.showPerformGwtCompileSetting) {
            this.createVerticalSpacer(this.comp, 1);
            this.performGwtCompileButton = SWTFactory.createCheckButton((Composite)this.comp, (String)"Perform GWT compile", null, (boolean)true, (int)1);
            this.performGwtCompileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GwtSuperDevModeCodeServerSettingsTab.this.updateLaunchConfigurationDialog();
                    GwtSuperDevModeCodeServerSettingsTab.this.updateEnabledState();
                }
            });
        }
        this.createVerticalSpacer(this.comp, 1);
        this.createStartupModuleComponent(this.comp);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.updateLaunchConfigurationDialogBatcher.deactivatedCalled(workingCopy);
        super.deactivated(workingCopy);
    }

    public void dispose() {
        this.updateLaunchConfigurationDialogBatcher.disposeCalled();
        super.dispose();
    }

    public void doPerformApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.urlSelectionBlock != null) {
            this.urlSelectionBlock.performApply(configuration);
        }
        if (this.sdmModeBlock != null) {
            this.sdmModeBlock.performApply(configuration);
        }
        this.persistModules(configuration, this.entryPointModulesBlock.getModules());
        LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new ModuleArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public Image getImage() {
        return GWTPlugin.getDefault().getImage(".images.sdmCodeServerImage");
    }

    public String getName() {
        return "GWT";
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.blockUpdateLaunchConfigurationDialog = true;
        IJavaProject javaProject = null;
        try {
            super.initializeFrom(config);
            try {
                if (this.urlSelectionBlock != null) {
                    this.urlSelectionBlock.initializeForm(config);
                }
                if (this.sdmModeBlock != null) {
                    this.sdmModeBlock.initializeFrom(config);
                }
                javaProject = this.getJavaProject();
                this.entryPointModulesBlock.setJavaProject(javaProject);
                if (javaProject != null) {
                    IProject project = javaProject.getProject();
                    this.entryPointModulesBlock.setDefaultModules(ModuleArgumentProcessor.getDefaultModules(project, config));
                    List<String> launchConfigModules = GWTLaunchConfiguration.getEntryPointModules(config);
                    this.entryPointModulesBlock.setModules(launchConfigModules);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.maybeGrayControls(javaProject);
            this.updateEnabledState();
        }
        finally {
            this.blockUpdateLaunchConfigurationDialog = false;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (!((Object)((Object)this)).equals(this.getLaunchConfigurationDialog().getActiveTab())) {
            return;
        }
        this.doPerformApply(configuration);
    }

    public void persistFromArguments(List<String> args, ILaunchConfigurationWorkingCopy config) {
        String logLevel = LogLevelArgumentProcessor.getValidLogLevel(args);
        GWTLaunchConfigurationWorkingCopy.setLogLevel(config, logLevel);
        try {
            List<String> modules = ModuleArgumentProcessor.getModules(args, (ILaunchConfiguration)config, this.getProject());
            this.persistModules(config, modules);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e, "Could not persist entry point modules");
        }
        String port = SuperDevModeCodeServerPortArgumentProcessor.getPort(args);
        if (port.equalsIgnoreCase("auto")) {
            GWTLaunchConfigurationWorkingCopy.setSdmCodeServerPortAuto(config, true);
        } else {
            GWTLaunchConfigurationWorkingCopy.setSdmCodeServerPort(config, port);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    protected void createStartupModuleComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"Available Modules:", (int)3, (int)1, (int)1808);
        GridLayout groupLayout = (GridLayout)group.getLayout();
        groupLayout.marginBottom = 8;
        group.setLayout((Layout)groupLayout);
        EntryPointModulesSelectionBlock.IModulesChangeListener listener = new EntryPointModulesSelectionBlock.IModulesChangeListener(){

            @Override
            public void onModulesChanged() {
                GwtSuperDevModeCodeServerSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.entryPointModulesBlock = new EntryPointModulesSelectionBlock(listener);
        this.entryPointModulesBlock.doFillIntoGrid((Composite)group, 3);
    }

    protected IJavaProject getJavaProject() throws CoreException {
        return JavaRuntime.getJavaProject((ILaunchConfiguration)this.getCurrentLaunchConfiguration());
    }

    protected void maybeGrayControls(IJavaProject javaProject) {
        boolean isGWTProject = javaProject != null && GWTNature.isGWTProject(javaProject.getProject());
        String message = isGWTProject ? null : "GWT is not enabled for this project. You can enable it in the project's properties.";
        this.setMessage(message);
        SWTUtilities.setEnabledRecursive((Control)this.comp, (boolean)isGWTProject);
    }

    protected void persistModules(ILaunchConfigurationWorkingCopy configuration, List<String> modules) {
        if (modules.equals(this.entryPointModulesBlock.getDefaultModules())) {
            GWTLaunchConfigurationWorkingCopy.clearAttribute(configuration, GWTLaunchAttributes.ENTRY_POINT_MODULES);
        } else {
            GWTLaunchConfigurationWorkingCopy.setEntryPointModules(configuration, modules, Collections.emptyList());
        }
    }

    protected void registerProgramArgsListener(ILaunchArgumentsContainer argsContainer) {
        argsContainer.registerProgramArgsListener((ILaunchArgumentsContainer.ArgumentsListener)this);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.blockUpdateLaunchConfigurationDialog) {
            this.updateLaunchConfigurationDialogBatcher.updateLaunchConfigurationDialogCalled();
        }
    }

    private IProject getProject() throws CoreException {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null || !javaProject.exists()) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", "Could not get a valid Java project"));
        }
        return javaProject.getProject();
    }

    private GwtSdk getRuntime(IJavaProject javaProject) {
        GWTProjectsRuntime synthesizedRuntime;
        GwtSdk runtime = GwtSdk.findSdkFor(javaProject);
        if (runtime == null && GWTProjectsRuntime.isGWTRuntimeProject(javaProject) && ((GwtSdk)(synthesizedRuntime = GWTProjectsRuntime.syntheziseContributorRuntime())).validate().isOK()) {
            runtime = synthesizedRuntime;
        }
        return runtime;
    }

    private void updateEnabledState() {
        if (this.performGwtCompileButton != null) {
            this.entryPointModulesBlock.setEnabled(this.performGwtCompileButton.getSelection());
        }
        if (this.sdmModeBlock != null) {
            this.sdmModeBlock.updateEnabledState();
        }
    }

    private static class DefaultComboLabelProvider
    extends LabelProvider {
        private DefaultComboLabelProvider() {
        }

        public String getText(Object element) {
            String element2 = (String)element;
            return String.valueOf(element2.toUpperCase().charAt(0)) + element2.toLowerCase().substring(1);
        }
    }

    public static interface IGWTSettingsTabFactory {
        public GwtSuperDevModeCodeServerSettingsTab newInstance(ILaunchArgumentsContainer var1);
    }

    protected class SdmModeBlock {
        private static final String GROUP_DEVMODE_TITLE = "Super Development Mode";
        private final Group groupDevMode;
        private final ComboViewer logLevelComboViewer;
        private final Button portAutoSelectionButton;
        private final Text portServerText;

        public SdmModeBlock(Composite parent) {
            this.groupDevMode = SWTFactory.createGroup((Composite)parent, (String)GROUP_DEVMODE_TITLE, (int)2, (int)1, (int)768);
            SWTFactory.createLabel((Composite)this.groupDevMode, (String)"Log level:", (int)1);
            this.logLevelComboViewer = new ComboViewer((Composite)this.groupDevMode, 8);
            this.logLevelComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.logLevelComboViewer.setLabelProvider((IBaseLabelProvider)new DefaultComboLabelProvider());
            this.logLevelComboViewer.setInput((Object)LogLevelArgumentProcessor.LOG_LEVELS);
            this.logLevelComboViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    GwtSuperDevModeCodeServerSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            Label serverPortLabel = new Label((Composite)this.groupDevMode, 0);
            GridData serverPortLabelGridData = new GridData();
            serverPortLabel.setLayoutData((Object)serverPortLabelGridData);
            serverPortLabel.setText("Code Server Port:");
            Composite codeServerPortComposite = new Composite((Composite)this.groupDevMode, 0);
            codeServerPortComposite.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(768);
            gd.horizontalSpan = 1;
            codeServerPortComposite.setLayoutData((Object)gd);
            this.portServerText = new Text(codeServerPortComposite, 2048);
            GridData serverPortTextGridData = new GridData(4, 0x1000000, false, false);
            serverPortTextGridData.widthHint = 75;
            this.portServerText.setLayoutData((Object)serverPortTextGridData);
            this.portServerText.setTextLimit(5);
            this.portServerText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GwtSuperDevModeCodeServerSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.portAutoSelectionButton = new Button(codeServerPortComposite, 32);
            this.portAutoSelectionButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            this.portAutoSelectionButton.setText("Automatically select an unused port");
            this.portAutoSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SdmModeBlock.this.updateEnabledState();
                    GwtSuperDevModeCodeServerSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.portAutoSelectionButton.setVisible(false);
        }

        public String getCodeServerPort() {
            return this.portServerText.getText();
        }

        public boolean getCodeServerPortAuto() {
            return this.portAutoSelectionButton.getSelection();
        }

        public String getLogLevel() {
            StructuredSelection logLevelSelection = (StructuredSelection)this.logLevelComboViewer.getSelection();
            return logLevelSelection.getFirstElement() != null ? logLevelSelection.getFirstElement().toString() : "INFO";
        }

        public void initializeFrom(ILaunchConfiguration config) throws CoreException {
            SWTUtilities.setText((Group)this.groupDevMode, (String)GROUP_DEVMODE_TITLE);
            this.logLevelComboViewer.setSelection((ISelection)new StructuredSelection((Object)GWTLaunchConfiguration.getLogLevel(config)));
            this.portServerText.setText(GWTLaunchConfiguration.getSdmCodeServerPort(config));
            this.portAutoSelectionButton.setSelection(GWTLaunchConfiguration.getClassicDevModeCodeServerPortAuto(config));
        }

        public void performApply(ILaunchConfigurationWorkingCopy launchConfig) {
            GWTLaunchConfigurationWorkingCopy.setLogLevel(launchConfig, this.getLogLevel());
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new LogLevelArgumentProcessor(), (ILaunchConfigurationWorkingCopy)launchConfig);
            GWTLaunchConfigurationWorkingCopy.setSdmCodeServerPort(launchConfig, this.getCodeServerPort());
            GWTLaunchConfigurationWorkingCopy.setSdmCodeServerPortAuto(launchConfig, this.getCodeServerPortAuto());
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new SuperDevModeCodeServerPortArgumentProcessor(), (ILaunchConfigurationWorkingCopy)launchConfig);
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new SuperDevModeCodeServerLauncherDirArgumentProcessor(), (ILaunchConfigurationWorkingCopy)launchConfig);
        }

        public void updateEnabledState() {
            this.portServerText.setEnabled(!this.portAutoSelectionButton.getSelection() && this.portAutoSelectionButton.getEnabled());
        }
    }

    protected class UrlSelectionBlock {
        private final Group browserGroup;
        private final Text urlField;

        public UrlSelectionBlock(Composite parent) {
            this.browserGroup = SWTFactory.createGroup((Composite)parent, (String)"Browsers:", (int)3, (int)1, (int)768);
            SWTFactory.createLabel((Composite)this.browserGroup, (String)"URL:", (int)1);
            this.urlField = SWTFactory.createSingleText((Composite)this.browserGroup, (int)1);
            this.urlField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GwtSuperDevModeCodeServerSettingsTab.this.updateLaunchConfigurationDialog();
                }
            });
            Button urlBrowseButton = GwtSuperDevModeCodeServerSettingsTab.this.createPushButton((Composite)this.browserGroup, "&Browse...", null);
            urlBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        IJavaProject javaProject = GwtSuperDevModeCodeServerSettingsTab.this.getJavaProject();
                        if (javaProject == null) {
                            MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"No project found", (String)"Please make sure that this launch configuration has a valid project assigned.");
                            return;
                        }
                        Object strategy = WebAppUtilities.isWebApp((IProject)javaProject.getProject()) ? new WebAppLaunchShortcutStrategy() : new LegacyGWTLaunchShortcutStrategy();
                        String urlFromUser = strategy.getUrlFromUser((IResource)GwtSuperDevModeCodeServerSettingsTab.this.getJavaProject().getProject(), false);
                        if (urlFromUser != null) {
                            Path url = new Path(urlFromUser);
                            SWTUtilities.setText((Text)UrlSelectionBlock.this.urlField, (String)url.toString());
                        }
                    }
                    catch (CoreException ce) {
                        GWTPluginLog.logError(ce);
                        MessageDialog.openError((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)"Error while browsing for URL", (String)ce.getLocalizedMessage());
                    }
                }
            });
        }

        public String getUrl() {
            return this.urlField.getText();
        }

        public void initializeForm(ILaunchConfiguration config) throws CoreException {
            IJavaProject javaProject = GwtSuperDevModeCodeServerSettingsTab.this.getJavaProject();
            GwtSdk runtime = javaProject == null ? null : GwtSuperDevModeCodeServerSettingsTab.this.getRuntime(javaProject);
            boolean hasNoServerArg = NoServerArgumentProcessor.hasNoServerArg(LaunchConfigurationProcessorUtilities.parseProgramArgs((ILaunchConfiguration)config));
            boolean showStartupUrl = false;
            GridData layoutData = (GridData)this.browserGroup.getLayoutData();
            layoutData.exclude = !showStartupUrl;
            this.browserGroup.setVisible(showStartupUrl);
            SWTUtilities.setText((Text)this.urlField, (String)GWTLaunchConfiguration.getStartupUrl(config));
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            GWTLaunchConfigurationWorkingCopy.setStartupUrl(configuration, this.getUrl().trim());
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new StartupUrlArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
            LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new XStartOnFirstThreadArgumentProcessor(), (ILaunchConfigurationWorkingCopy)configuration);
        }
    }
}

