/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.ui.tabs.blocks;

import com.google.gdt.eclipse.core.SWTUtilities;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfiguration;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfigurationWorkingCopy;
import com.google.gwt.eclipse.core.launch.processors.LogLevelArgumentProcessor;
import com.google.gwt.eclipse.core.launch.ui.tabs.IUpdateLaunchConfig;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CompilerBlock
extends Composite {
    private static final String GROUP_COMPILER_TITLE = "Compiler Arguments";
    private final Group groupDevMode;
    private final ComboViewer logLevelComboViewer;
    private IUpdateLaunchConfig updateLaunchConfigHandler;

    public CompilerBlock(Composite root, int style) {
        super(root, style);
        this.setLayout((Layout)new FillLayout(256));
        Composite parent = new Composite((Composite)this, 0);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.groupDevMode = SWTFactory.createGroup((Composite)parent, (String)GROUP_COMPILER_TITLE, (int)2, (int)1, (int)768);
        Label label = SWTFactory.createLabel((Composite)this.groupDevMode, (String)"Log level:", (int)1);
        GridData gd_label = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_label.widthHint = 101;
        label.setLayoutData((Object)gd_label);
        this.logLevelComboViewer = new ComboViewer((Composite)this.groupDevMode, 8);
        new Label((Composite)this.groupDevMode, 0);
        this.logLevelComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.logLevelComboViewer.setLabelProvider((IBaseLabelProvider)new DefaultComboLabelProvider());
        this.logLevelComboViewer.setInput((Object)LogLevelArgumentProcessor.LOG_LEVELS);
        this.logLevelComboViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompilerBlock.this.updateLaunchConfigHandler.updateLaunchConfig();
            }
        });
    }

    public String getLogLevel() {
        StructuredSelection logLevelSelection = (StructuredSelection)this.logLevelComboViewer.getSelection();
        return logLevelSelection.getFirstElement() != null ? logLevelSelection.getFirstElement().toString() : "INFO";
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        SWTUtilities.setText((Group)this.groupDevMode, (String)GROUP_COMPILER_TITLE);
        this.logLevelComboViewer.setSelection((ISelection)new StructuredSelection((Object)GWTLaunchConfiguration.getLogLevel(config)));
    }

    public void performApply(ILaunchConfigurationWorkingCopy launchConfig) {
        GWTLaunchConfigurationWorkingCopy.setLogLevel(launchConfig, this.getLogLevel());
        LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new LogLevelArgumentProcessor(), (ILaunchConfigurationWorkingCopy)launchConfig);
    }

    protected void checkSubclass() {
    }

    public void addUpdateLaunchConfigHandler(IUpdateLaunchConfig updateLaunchConfigHandler) {
        this.updateLaunchConfigHandler = updateLaunchConfigHandler;
    }

    private static class DefaultComboLabelProvider
    extends LabelProvider {
        private DefaultComboLabelProvider() {
        }

        public String getText(Object element) {
            String element2 = (String)element;
            return String.valueOf(element2.toUpperCase().charAt(0)) + element2.toLowerCase().substring(1);
        }
    }
}

