/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.launch.util;

import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.launch.ILaunchConfigurationProcessor;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationProcessorUtilities;
import com.google.gdt.eclipse.core.launch.LaunchConfigurationUtilities;
import com.google.gwt.eclipse.core.launch.GWTLaunchConfigurationWorkingCopy;
import com.google.gwt.eclipse.core.launch.ModuleClasspathProvider;
import com.google.gwt.eclipse.core.launch.processors.ModuleArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.codeserver.SuperDevModeCodeServerLauncherDirArgumentProcessor;
import com.google.gwt.eclipse.core.launch.processors.codeserver.SuperDevModeCodeServerMainTypeProcessor;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GwtSuperDevModeCodeServerLaunchUtil {
    public static ILaunchConfiguration createLaunchConfig(String launchConfigName, IProject project) throws CoreException, OperationCanceledException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.gwtplugins.gwt.eclipse.core.sdmCodeServer");
        ILaunchConfigurationWorkingCopy launchConfig = type.newInstance(null, launchConfigName);
        LaunchConfigurationUtilities.setProjectName((ILaunchConfigurationWorkingCopy)launchConfig, (String)project.getName());
        launchConfig.setMappedResources(new IResource[]{project});
        GwtSuperDevModeCodeServerLaunchUtil.setDefaults(launchConfig, project);
        ILaunchConfiguration ilaunchConfig = launchConfig.doSave();
        return ilaunchConfig;
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy launchConfig, IProject project) {
        launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, ModuleClasspathProvider.computeProviderId(project));
        GWTLaunchConfigurationWorkingCopy.setSuperDevModeEnabled(launchConfig, true);
        LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new SuperDevModeCodeServerMainTypeProcessor(), (ILaunchConfigurationWorkingCopy)launchConfig);
        LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new ModuleArgumentProcessor(), (ILaunchConfigurationWorkingCopy)launchConfig);
    }

    private static ILaunchConfiguration findLaunchConfiguration(IProject project) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType typeid = launchManager.getLaunchConfigurationType("com.gwtplugins.gwt.eclipse.core.sdmCodeServer");
        ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(typeid);
        return GwtSuperDevModeCodeServerLaunchUtil.searchMatchingConfigWithProject(project, configs);
    }

    private static ILaunchConfiguration findOrCreateLaunchConfiguration(IProject project, String launcherDir, String launcherId) throws CoreException, OperationCanceledException {
        ILaunchConfiguration config = GwtSuperDevModeCodeServerLaunchUtil.findLaunchConfiguration(project);
        if (config == null) {
            config = GwtSuperDevModeCodeServerLaunchUtil.createNewLaunchConfiguration(project);
        }
        config = GwtSuperDevModeCodeServerLaunchUtil.addOrModifyLauncherArgs(config, launcherDir, launcherId);
        return config;
    }

    private static ILaunchConfiguration addOrModifyLauncherArgs(ILaunchConfiguration config, String launcherDir, String launcherId) throws CoreException {
        ILaunchConfigurationWorkingCopy launchConfigWc = config.getWorkingCopy();
        if (launcherDir != null && launcherDir.trim().isEmpty()) {
            launcherDir = null;
        }
        GWTLaunchConfigurationWorkingCopy.setCodeServerLauncherDir(launchConfigWc, launcherDir);
        LaunchConfigurationProcessorUtilities.updateViaProcessor((ILaunchConfigurationProcessor)new SuperDevModeCodeServerLauncherDirArgumentProcessor(), (ILaunchConfigurationWorkingCopy)launchConfigWc);
        if (launcherId != null) {
            launchConfigWc.setAttribute("com.gwtplugins.gwt.eclipse.core.launch.id", launcherId);
        }
        config = launchConfigWc.doSave();
        return config;
    }

    public static void launch(IProject project, String mode) {
        GwtSuperDevModeCodeServerLaunchUtil.launch(project, mode, null, null);
    }

    public static void launch(IProject project, String launchMode, String launcherDir, String launcherId) {
        try {
            ILaunchConfiguration launchConfig = GwtSuperDevModeCodeServerLaunchUtil.findOrCreateLaunchConfiguration(project, launcherDir, launcherId);
            DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)launchMode);
        }
        catch (CoreException e) {
            CorePluginLog.logError((Throwable)e, (String)"CoreException: Aborting GWT Super Dev Mode Code Server launcher.");
        }
        catch (OperationCanceledException e) {
            CorePluginLog.logError((Throwable)e, (String)"OperationCancelException: Aborting GWT Super Dev Mode Code Server launcher.");
        }
    }

    private static ILaunchConfiguration searchMatchingConfigWithProject(IProject project, ILaunchConfiguration[] configs) throws CoreException {
        ArrayList<ILaunchConfiguration> candidates = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (LaunchConfigurationUtilities.getProjectName((ILaunchConfiguration)config).equals(project.getName())) {
                candidates.add(config);
            }
            ++n2;
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ILaunchConfiguration)candidates.get(0);
        }
        return LaunchConfigurationUtilities.chooseConfiguration(candidates, (Shell)GwtSuperDevModeCodeServerLaunchUtil.getShell());
    }

    private static ILaunchConfiguration createNewLaunchConfiguration(IProject project) throws CoreException, OperationCanceledException {
        String initialName = GwtSuperDevModeCodeServerLaunchUtil.calculateLaunchConfigName(project);
        ILaunchConfiguration launchConfig = GwtSuperDevModeCodeServerLaunchUtil.createLaunchConfig(initialName, project);
        return launchConfig;
    }

    private static String calculateLaunchConfigName(IProject project) {
        return project.getName();
    }

    private static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

