/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.markers;

import com.google.gdt.eclipse.core.markers.GdtProblemCategory;
import com.google.gdt.eclipse.core.markers.GdtProblemSeverity;
import com.google.gdt.eclipse.core.markers.IGdtProblemType;

public enum GWTProblemType implements IGdtProblemType
{
    JSNI_JAVA_REF_UNRESOLVED_TYPE(101, "Unresolved type reference", "{0} could not be resolved to a type", GdtProblemSeverity.ERROR),
    JSNI_JAVA_REF_MISSING_METHOD(102, "Reference to non-existent method", "{0} does not contain a method named {1}", GdtProblemSeverity.ERROR),
    JSNI_JAVA_REF_MISSING_FIELD(103, "Reference to non-existent field", "{0} does not contain a field named {1}", GdtProblemSeverity.ERROR),
    JSNI_JAVA_REF_NO_MATCHING_METHOD(104, "Incorrect method signature", "The method {0} in the type {1} is undefined", GdtProblemSeverity.ERROR),
    JSNI_JAVA_REF_NO_MATCHING_CTOR(105, "Incorrect constructor signature", "The constructor {0} is undefined", GdtProblemSeverity.ERROR),
    JSNI_PARSE_ERROR(106, "JavaScript parsing error", "JavaScript parsing: {0}", GdtProblemSeverity.WARNING),
    REQ_FACTORY_SERVICE_METHOD_ERROR(107, "Request Factory Service Method validation error", "The method {0} is missing a client side implementation", GdtProblemSeverity.WARNING);

    private final GdtProblemSeverity defaultSeverity;
    private final String description;
    private final String message;
    private final int problemId;

    public static GWTProblemType getProblemType(int problemId) {
        GWTProblemType[] gWTProblemTypeArray = GWTProblemType.values();
        int n = gWTProblemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GWTProblemType type = gWTProblemTypeArray[n2];
            if (type.getProblemId() == problemId) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    private GWTProblemType(int problemId, String description, String message, GdtProblemSeverity defaultSeverity) {
        this.problemId = problemId;
        this.description = description;
        this.message = message;
        this.defaultSeverity = defaultSeverity;
    }

    public GdtProblemCategory getCategory() {
        return GdtProblemCategory.JSNI;
    }

    public GdtProblemSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMessage() {
        return this.message;
    }

    public int getProblemId() {
        return this.problemId;
    }

    public String toString() {
        return this.description;
    }
}

