/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.markers.quickfixes;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.platform.jdt.text.correction.proposals.ASTRewriteCorrectionProposal;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractUpdateSignatureProposal
extends ASTRewriteCorrectionProposal {
    private static final Image ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    private static final String LABEL_FORMAT = "Update method ''{0}'' in type ''{1}''";
    private static final int DEFAULT_RELEVANCE = 100;
    private static final int UNIQUE_RELEVANCE = 200;
    private final RpcPair rpcPair;

    protected static List<IJavaCompletionProposal> createProposal(RpcPair rpcPair, UpdateSignatureProposalBuilder builder) {
        if (rpcPair == null) {
            return Collections.emptyList();
        }
        int candidates = AbstractUpdateSignatureProposal.candidateCount(rpcPair.dstType, rpcPair.srcMethod.getName().getIdentifier());
        if (candidates == 0) {
            return Collections.emptyList();
        }
        int relevance = candidates == 1 ? 200 : 100;
        return Collections.singletonList(builder.createProposal(rpcPair, relevance));
    }

    protected static RpcPair resolveRpcPair(ASTNode node, PeerTypeResolver peerResolver) {
        MethodDeclaration methodDecl = ASTResolving.findParentMethodDeclaration((ASTNode)node);
        TypeDeclaration typeDecl = (TypeDeclaration)ASTResolving.findAncestor((ASTNode)node, (int)55);
        assert (typeDecl != null);
        IType dstType = peerResolver.getPeerType(typeDecl);
        if (dstType == null) {
            return null;
        }
        CompilationUnit astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)dstType.getCompilationUnit(), null);
        TypeDeclaration dstTypeDecl = JavaASTUtils.findTypeDeclaration((CompilationUnit)astRoot, (String)dstType.getFullyQualifiedName('.'));
        if (dstTypeDecl == null) {
            return null;
        }
        return new RpcPair(typeDecl, methodDecl, dstTypeDecl);
    }

    protected static RpcPair resolveRpcPair(ASTNode node, String methodBindingKey, PeerTypeResolver peerResolver) {
        TypeDeclaration dstTypeDecl = (TypeDeclaration)ASTResolving.findAncestor((ASTNode)node, (int)55);
        assert (dstTypeDecl != null);
        IType type = peerResolver.getPeerType(dstTypeDecl);
        if (type == null) {
            return null;
        }
        CompilationUnit targetAstRoot = ASTResolving.createQuickFixAST((ICompilationUnit)type.getCompilationUnit(), null);
        TypeDeclaration typeDecl = JavaASTUtils.findTypeDeclaration((CompilationUnit)targetAstRoot, (String)type.getFullyQualifiedName('.'));
        MethodDeclaration methodDecl = JavaASTUtils.findMethodDeclaration((ICompilationUnit)type.getCompilationUnit(), (String)methodBindingKey);
        if (typeDecl == null || methodDecl == null) {
            return null;
        }
        return new RpcPair(typeDecl, methodDecl, dstTypeDecl);
    }

    private static int candidateCount(TypeDeclaration type, String name) {
        int count = 0;
        MethodDeclaration[] methodDeclarationArray = type.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (name.equals(method.getName().getIdentifier())) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    protected AbstractUpdateSignatureProposal(RpcPair rpcPair, int relevance) {
        super(MessageFormat.format(LABEL_FORMAT, rpcPair.srcMethod.getName().getIdentifier(), rpcPair.dstType.getName().getIdentifier()), JavaASTUtils.getCompilationUnit((ASTNode)rpcPair.dstType), null, relevance, ICON);
        this.rpcPair = rpcPair;
    }

    protected abstract List<SingleVariableDeclaration> adjustDstParams(MethodDeclaration var1);

    protected abstract List<SingleVariableDeclaration> adjustSrcParams(MethodDeclaration var1);

    protected abstract List<SingleVariableDeclaration> computeParams(AST var1, MethodDeclaration var2, MethodDeclaration var3, ImportRewrite var4);

    protected abstract Type computeReturnType(AST var1, MethodDeclaration var2, MethodDeclaration var3, ImportRewrite var4);

    protected ASTRewrite getRewrite() {
        MethodDeclaration dstMethod = this.findBestUpdateMatch(this.rpcPair);
        CompilationUnit astRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
        this.createImportRewrite(astRoot);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        MethodDeclaration rewriterDstMethod = JavaASTUtils.findMethodDeclaration((CompilationUnit)astRoot, (String)dstMethod.resolveBinding().getKey());
        if (rewriterDstMethod == null) {
            return null;
        }
        MethodDeclaration newSignature = this.computeMethodSignature(rewrite.getAST(), this.rpcPair, rewriterDstMethod);
        rewrite.replace((ASTNode)rewriterDstMethod, (ASTNode)newSignature, null);
        return rewrite;
    }

    private MethodDeclaration computeMethodSignature(AST ast, RpcPair rpcPair, MethodDeclaration dstMethod) {
        MethodDeclaration method = ast.newMethodDeclaration();
        String methodName = rpcPair.srcMethod.getName().getIdentifier();
        method.setName(ast.newSimpleName(methodName));
        List params = method.parameters();
        params.addAll(this.computeParams(ast, rpcPair.srcMethod, dstMethod, this.getImportRewrite()));
        method.setReturnType2(this.computeReturnType(ast, rpcPair.srcMethod, dstMethod, this.getImportRewrite()));
        return method;
    }

    private MethodDeclaration findBestUpdateMatch(RpcPair rpcPair) {
        int minDistance = 0;
        String name = rpcPair.srcMethod.getName().getIdentifier();
        List<SingleVariableDeclaration> params = this.adjustSrcParams(rpcPair.srcMethod);
        MethodDeclaration[] methodDeclarationArray = rpcPair.dstType.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration dstMethod = methodDeclarationArray[n2];
            if (name.equals(dstMethod.getName().getIdentifier())) {
                List<SingleVariableDeclaration> targetParams = this.adjustDstParams(dstMethod);
                int distance = JavaASTUtils.editDistance(params, targetParams);
                if (rpcPair.dstMethod == null || distance < minDistance) {
                    rpcPair.dstMethod = dstMethod;
                    minDistance = distance;
                }
            }
            ++n2;
        }
        return rpcPair.dstMethod;
    }

    static enum PeerTypeResolver {
        ASYNC_RESOLVER{

            @Override
            IType getPeerType(TypeDeclaration decl) {
                return RemoteServiceUtilities.findAsyncType(decl);
            }
        }
        ,
        SYNC_RESOLVER{

            @Override
            IType getPeerType(TypeDeclaration decl) {
                return RemoteServiceUtilities.findSyncType(decl);
            }
        };


        abstract IType getPeerType(TypeDeclaration var1);
    }

    static class RpcPair {
        TypeDeclaration srcType;
        TypeDeclaration dstType;
        MethodDeclaration srcMethod;
        MethodDeclaration dstMethod;

        public RpcPair(TypeDeclaration srcType, MethodDeclaration srcMethod, TypeDeclaration dstType) {
            this.srcType = srcType;
            this.srcMethod = srcMethod;
            this.dstType = dstType;
        }
    }

    protected static interface UpdateSignatureProposalBuilder {
        public AbstractUpdateSignatureProposal createProposal(RpcPair var1, int var2);
    }
}

