/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.markers.quickfixes;

import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.platform.jdt.text.correction.proposals.NewCompilationUnitUsingWizardProposal;
import com.google.gdt.eclipse.platform.shared.ui.IPixelConverter;
import com.google.gdt.eclipse.platform.ui.PixelConverterFactory;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import com.google.gwt.eclipse.core.wizards.rpc.NewAsyncRemoteServiceInterfaceCreationWizard;
import com.google.gwt.eclipse.core.wizards.rpc.NewAsyncRemoteServiceInterfaceCreationWizardPage;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.ValidateEditException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;

public class CreateAsyncInterfaceProposal
extends NewCompilationUnitUsingWizardProposal {
    private final ICompilationUnit compilationUnit;
    private IType createdType;
    private Name node;
    private ITypeBinding syncTypeBinding;
    private final IJavaElement typeContainer;
    private final String typeNameWithParameters;

    public static List<IJavaCompletionProposal> createProposals(IInvocationContext context, IProblemLocation problem) throws JavaModelException {
        String syncTypeName = problem.getProblemArguments()[0];
        IJavaProject javaProject = context.getCompilationUnit().getJavaProject();
        IType syncType = JavaModelSearch.findType((IJavaProject)javaProject, (String)syncTypeName);
        if (syncType == null || !syncType.isInterface()) {
            return Collections.emptyList();
        }
        CompilationUnit cu = context.getASTRoot();
        ASTNode coveredNode = problem.getCoveredNode(cu);
        TypeDeclaration syncTypeDecl = (TypeDeclaration)coveredNode.getParent();
        assert (cu.getAST().hasResolvedBindings());
        ITypeBinding syncTypeBinding = syncTypeDecl.resolveBinding();
        assert (syncTypeBinding != null);
        String asyncName = RemoteServiceUtilities.computeAsyncTypeName(problem.getProblemArguments()[0]);
        AST ast = context.getASTRoot().getAST();
        Name name = ast.newName(asyncName);
        ast.newAssignment().setLeftHandSide((Expression)name);
        IJavaElement typeContainer = syncType.getParent();
        if (typeContainer.getElementType() == 5) {
            typeContainer = syncType.getPackageFragment();
        }
        CreateAsyncInterfaceProposal createAsyncInterfaceProposal = new CreateAsyncInterfaceProposal(context.getCompilationUnit(), name, 2, typeContainer, 2, syncTypeBinding);
        NewCompilationUnitUsingWizardProposal fallbackProposal = new NewCompilationUnitUsingWizardProposal(context.getCompilationUnit(), name, 2, context.getCompilationUnit().getParent(), 1);
        return Arrays.asList(new IJavaCompletionProposal[]{createAsyncInterfaceProposal, fallbackProposal});
    }

    public CreateAsyncInterfaceProposal(ICompilationUnit cu, Name node, int typeKind, IJavaElement typeContainer, int severity, ITypeBinding syncTypeBinding) {
        super(cu, node, typeKind, typeContainer, severity);
        this.compilationUnit = cu;
        this.node = node;
        this.syncTypeBinding = syncTypeBinding;
        this.typeContainer = typeContainer;
        this.typeNameWithParameters = this.computeTypeNameWithParameters();
        String displayName = this.computeDisplayName();
        this.setDisplayName(displayName);
        this.setImage(GWTPlugin.getDefault().getImageRegistry().get("com.gwtplugins.gwt.eclipse.core.images.newAsyncInterfaceSmall"));
    }

    public void apply(IDocument document) {
        StructuredSelection selection = new StructuredSelection((Object)this.compilationUnit);
        NewElementWizard wizard = this.createWizard(selection);
        wizard.init(JavaPlugin.getDefault().getWorkbench(), (IStructuredSelection)selection);
        IType localCreatedType = null;
        if (this.isShowDialog()) {
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            IPixelConverter converter = PixelConverterFactory.createPixelConverter((Font)JFaceResources.getDialogFont());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            dialog.getShell().setText("New Asynchronous Remote Service Interface");
            if (dialog.open() == 0) {
                localCreatedType = (IType)wizard.getCreatedElement();
            }
        } else {
            wizard.addPages();
            try {
                NewTypeWizardPage page = this.getPage(wizard);
                page.createType(null);
                localCreatedType = page.getCreatedType();
            }
            catch (CoreException e) {
                JavaPlugin.log((Throwable)e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (localCreatedType != null) {
            IJavaElement container = localCreatedType.getParent();
            if (container instanceof ICompilationUnit) {
                container = container.getParent();
            }
            if (!container.equals(this.typeContainer)) {
                try {
                    ImportRewrite rewrite = StubUtility.createImportRewrite((ICompilationUnit)this.compilationUnit, (boolean)true);
                    rewrite.addImport(localCreatedType.getFullyQualifiedName('.'));
                    CreateAsyncInterfaceProposal.applyEdit(this.compilationUnit, rewrite.rewriteImports(null), false, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            this.createdType = localCreatedType;
        }
    }

    private static void applyEdit(ICompilationUnit cu, TextEdit edit, boolean save, IProgressMonitor monitor) throws CoreException, ValidateEditException {
        IFile file = (IFile)cu.getResource();
        if (!save || !file.exists()) {
            cu.applyTextEdit(edit, monitor);
        } else {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(CorextMessages.JavaModelUtil_applyedit_operation, 2);
            try {
                IStatus status = Resources.makeCommittable((IResource)file, null);
                if (!status.isOK()) {
                    throw new ValidateEditException(status);
                }
                cu.applyTextEdit(edit, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                cu.save((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1), true);
            }
            finally {
                monitor.done();
            }
        }
    }

    public String getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuilder buf = new StringBuilder();
        buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_info);
        buf.append("<br>");
        buf.append("<br>");
        if (this.typeContainer instanceof IType) {
            buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_tooltip_enclosingtype);
        } else {
            buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_tooltip_package);
        }
        buf.append(" <b>");
        buf.append(JavaElementLabels.getElementLabel((IJavaElement)this.typeContainer, (long)262144L));
        buf.append("</b><br>");
        buf.append("public ");
        buf.append("interface <b>");
        this.nameToHTML(this.typeNameWithParameters, buf);
        ITypeBinding superclass = this.getPossibleSuperTypeBinding((ASTNode)this.node);
        if (superclass != null) {
            buf.append("</b> extends <b>");
        }
        buf.append("</b> {");
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setProject(this.compilationUnit.getJavaProject());
        parser.setResolveBindings(true);
        StringBuilder sb = new StringBuilder();
        IPackageFragment packageFragment = (IPackageFragment)this.compilationUnit.getAncestor(4);
        if (packageFragment != null) {
            sb.append("package ");
            sb.append(packageFragment.getElementName());
            sb.append(";\n");
        }
        sb.append("public interface ");
        sb.append(this.typeNameWithParameters);
        sb.append("{}\n");
        IPath fullPath = this.compilationUnit.getResource().getFullPath();
        String extension = fullPath.getFileExtension();
        fullPath = fullPath.removeFileExtension();
        parser.setUnitName(String.valueOf(fullPath.toString()) + "Async." + extension);
        parser.setSource(sb.toString().toCharArray());
        CompilationUnit astNode = (CompilationUnit)parser.createAST(null);
        TypeDeclaration asyncTypeDecl = (TypeDeclaration)astNode.types().get(0);
        List<IMethodBinding> methodsToConvert = NewAsyncRemoteServiceInterfaceCreationWizardPage.computeSyncMethodsThatNeedAsyncVersions(this.syncTypeBinding, asyncTypeDecl.resolveBinding());
        NewAsyncRemoteServiceInterfaceCreationWizardPage.ImportManagerAdapter importAdapter = new NewAsyncRemoteServiceInterfaceCreationWizardPage.ImportManagerAdapter(){

            @Override
            public String addImport(ITypeBinding typeBinding) {
                return typeBinding.getName();
            }

            @Override
            public String addImport(String qualifiedTypeName) {
                return Signature.getSimpleName((String)qualifiedTypeName);
            }
        };
        for (IMethodBinding methodToConvert : methodsToConvert) {
            try {
                buf.append("<br><pre>  </pre>");
                String methodContents = NewAsyncRemoteServiceInterfaceCreationWizardPage.createMethodContents(null, importAdapter, methodToConvert, false);
                this.nameToHTML(methodContents, buf);
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
            }
            catch (CoreException e) {
                GWTPluginLog.logError(e);
            }
        }
        buf.append("<br>}<br>");
        return buf.toString();
    }

    public IType getCreatedType() {
        return this.createdType;
    }

    private String computeDisplayName() {
        String typeName = this.typeNameWithParameters;
        String containerName = ASTNodes.getQualifier((Name)this.node);
        String containerLabel = this.asLabel(containerName);
        String typeLabel = this.asLabel(typeName);
        boolean isInnerType = this.typeContainer instanceof IType;
        String displayName = isInnerType ? (containerName.length() == 0 ? MessageFormat.format("Create member asynchronous RemoteService interface ''{0}''", typeLabel) : MessageFormat.format("Create member asynchronous RemoteService interface ''{0}'' in type ''{1}''", typeLabel, containerLabel)) : (containerName.length() == 0 ? MessageFormat.format("Create asynchronous RemoteService interface ''{0}'' in type ''{1}''", typeLabel) : MessageFormat.format("Create asynchronous RemoteService interface ''{0}'' in package ''{1}''", typeLabel, containerLabel));
        return displayName;
    }

    private String computeTypeNameWithParameters() {
        StringBuilder sb = new StringBuilder();
        if (this.syncTypeBinding.getTypeParameters().length > 0) {
            sb.append("<");
            ITypeBinding[] typeParameters = this.syncTypeBinding.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(typeParameters[i].getName());
                sb.append(" extends ");
                ITypeBinding[] typeBounds = typeParameters[i].getTypeBounds();
                int j = 0;
                while (j < typeBounds.length) {
                    if (j != 0) {
                        sb.append(" & ");
                    }
                    sb.append(typeBounds[i].getQualifiedName());
                    ++j;
                }
                ++i;
            }
            sb.append(">");
        }
        return String.valueOf(ASTNodes.getSimpleNameIdentifier((Name)this.node)) + sb.toString();
    }

    private void configureWizardPage(NewTypeWizardPage page) {
        page.setTypeName(this.typeNameWithParameters, false);
        boolean isInEnclosingType = this.typeContainer instanceof IType;
        if (isInEnclosingType) {
            page.setEnclosingType((IType)this.typeContainer, false);
        } else {
            page.setPackageFragment((IPackageFragment)this.typeContainer, false);
        }
        page.setEnclosingTypeSelection(isInEnclosingType, false);
    }

    private NewElementWizard createWizard(StructuredSelection selection) {
        NewAsyncRemoteServiceInterfaceCreationWizardPage page = new NewAsyncRemoteServiceInterfaceCreationWizardPage(this.syncTypeBinding);
        page.init((IStructuredSelection)selection);
        this.configureWizardPage((NewTypeWizardPage)page);
        return new NewAsyncRemoteServiceInterfaceCreationWizard(page, true);
    }

    private NewTypeWizardPage getPage(NewElementWizard wizard) {
        IWizardPage[] pages = wizard.getPages();
        Assert.isTrue((pages.length > 0 && pages[0] instanceof NewTypeWizardPage ? 1 : 0) != 0);
        return (NewTypeWizardPage)pages[0];
    }

    private ITypeBinding getPossibleSuperTypeBinding(ASTNode node) {
        ITypeBinding binding = ASTResolving.guessBindingForTypeReference((ASTNode)node);
        if (binding != null && !binding.isRecovered()) {
            return binding;
        }
        return null;
    }

    private void nameToHTML(String name, StringBuilder sb) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch == '>') {
                sb.append("&gt;");
            } else if (ch == '<') {
                sb.append("&lt;");
            } else {
                sb.append(ch);
            }
            ++i;
        }
    }
}

