/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.markers.quickfixes;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gwt.eclipse.core.markers.quickfixes.AbstractCreateMethodProposal;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;

public class CreateAsyncMethodProposal
extends AbstractCreateMethodProposal {
    public static List<IJavaCompletionProposal> createProposalsForProblemOnAsyncType(ICompilationUnit asyncCompilationUnit, ASTNode problemNode, String syncMethodBindingKey) {
        TypeDeclaration asyncTypeDecl = (TypeDeclaration)ASTResolving.findAncestor((ASTNode)problemNode, (int)55);
        assert (asyncTypeDecl != null);
        String asyncQualifiedTypeName = asyncTypeDecl.resolveBinding().getQualifiedName();
        IType syncType = RemoteServiceUtilities.findSyncType(asyncTypeDecl);
        if (syncType == null) {
            return Collections.emptyList();
        }
        MethodDeclaration syncMethodDecl = JavaASTUtils.findMethodDeclaration((ICompilationUnit)syncType.getCompilationUnit(), (String)syncMethodBindingKey);
        if (syncMethodDecl == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateAsyncMethodProposal(asyncCompilationUnit, asyncQualifiedTypeName, syncMethodDecl));
    }

    public static List<IJavaCompletionProposal> createProposalsForProblemOnSyncMethod(ASTNode problemNode) {
        MethodDeclaration syncMethodDecl = ASTResolving.findParentMethodDeclaration((ASTNode)problemNode);
        TypeDeclaration syncTypeDecl = (TypeDeclaration)ASTResolving.findAncestor((ASTNode)syncMethodDecl, (int)55);
        assert (syncTypeDecl != null);
        IType asyncType = RemoteServiceUtilities.findAsyncType(syncTypeDecl);
        if (asyncType == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateAsyncMethodProposal(asyncType.getCompilationUnit(), asyncType.getFullyQualifiedName('.'), syncMethodDecl));
    }

    private CreateAsyncMethodProposal(ICompilationUnit asyncCompilationUnit, String asyncQualifiedTypeName, MethodDeclaration syncMethodDecl) {
        super(asyncCompilationUnit, asyncQualifiedTypeName, syncMethodDecl);
    }

    @Override
    protected MethodDeclaration createMethodDeclaration(AST ast) {
        MethodDeclaration asyncMethodDecl = ast.newMethodDeclaration();
        String methodName = this.getSyncMethodDeclaration().getName().getIdentifier();
        asyncMethodDecl.setName(ast.newSimpleName(methodName));
        asyncMethodDecl.setReturnType2((Type)ast.newPrimitiveType(PrimitiveType.VOID));
        this.addAsyncParameters(ast, asyncMethodDecl);
        return asyncMethodDecl;
    }

    private void addAsyncParameters(AST ast, MethodDeclaration asyncMethodDecl) {
        List asyncMethodParams = asyncMethodDecl.parameters();
        asyncMethodParams.addAll(JavaASTUtils.cloneParameters((AST)ast, (List)this.getSyncMethodDeclaration().parameters(), (ImportRewrite)this.getImportRewrite()));
        ArrayList<String> existingParamNames = new ArrayList<String>();
        for (SingleVariableDeclaration param : asyncMethodParams) {
            existingParamNames.add(param.getName().getIdentifier());
        }
        String callbackParameterName = StringUtilities.computeUniqueName((String[])existingParamNames.toArray(new String[0]), (String)"callback");
        asyncMethodParams.add(Util.createAsyncCallbackParameter(ast, this.getSyncMethodDeclaration().getReturnType2(), callbackParameterName, this.getImportRewrite()));
    }

    private MethodDeclaration getSyncMethodDeclaration() {
        return this.sourceMethodDecl;
    }
}

