/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.markers.quickfixes;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gwt.eclipse.core.markers.quickfixes.AbstractCreateMethodProposal;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;

public class CreateSyncMethodProposal
extends AbstractCreateMethodProposal {
    public static List<IJavaCompletionProposal> createProposalsForProblemOnAsyncMethod(ASTNode problemNode) {
        MethodDeclaration asyncMethodDecl = ASTResolving.findParentMethodDeclaration((ASTNode)problemNode);
        TypeDeclaration asyncTypeDecl = (TypeDeclaration)ASTResolving.findAncestor((ASTNode)asyncMethodDecl, (int)55);
        assert (asyncTypeDecl != null);
        IType syncType = RemoteServiceUtilities.findSyncType(asyncTypeDecl);
        if (syncType == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateSyncMethodProposal(syncType.getCompilationUnit(), syncType.getFullyQualifiedName('.'), asyncMethodDecl));
    }

    public static List<IJavaCompletionProposal> createProposalsForProblemOnSyncType(ICompilationUnit syncCompilationUnit, ASTNode problemNode, String asyncMethodBindingKey) {
        TypeDeclaration syncTypeDecl = (TypeDeclaration)ASTResolving.findAncestor((ASTNode)problemNode, (int)55);
        assert (syncTypeDecl != null);
        String syncQualifiedTypeName = syncTypeDecl.resolveBinding().getQualifiedName();
        IType asyncType = RemoteServiceUtilities.findAsyncType(syncTypeDecl);
        if (asyncType == null) {
            return Collections.emptyList();
        }
        MethodDeclaration asyncMethodDecl = JavaASTUtils.findMethodDeclaration((ICompilationUnit)asyncType.getCompilationUnit(), (String)asyncMethodBindingKey);
        if (asyncMethodDecl == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateSyncMethodProposal(syncCompilationUnit, syncQualifiedTypeName, asyncMethodDecl));
    }

    public CreateSyncMethodProposal(ICompilationUnit syncCompilationUnit, String syncQualifiedTypeName, MethodDeclaration asyncMethodDecl) {
        super(syncCompilationUnit, syncQualifiedTypeName, asyncMethodDecl);
    }

    @Override
    protected MethodDeclaration createMethodDeclaration(AST ast) {
        MethodDeclaration syncMethodDecl = ast.newMethodDeclaration();
        String methodName = this.getAsyncMethodDeclaration().getName().getIdentifier();
        syncMethodDecl.setName(ast.newSimpleName(methodName));
        syncMethodDecl.setReturnType2(Util.computeSyncReturnType(ast, this.getAsyncMethodDeclaration(), this.getImportRewrite()));
        this.addSyncParameters(ast, syncMethodDecl);
        return syncMethodDecl;
    }

    private void addSyncParameters(AST ast, MethodDeclaration syncMethodDecl) {
        List asyncParameters = this.getAsyncMethodDeclaration().parameters();
        syncMethodDecl.parameters().addAll(JavaASTUtils.cloneParameters((AST)ast, asyncParameters.subList(0, asyncParameters.size() - 1), (ImportRewrite)this.getImportRewrite()));
    }

    private MethodDeclaration getAsyncMethodDeclaration() {
        return this.sourceMethodDecl;
    }
}

