/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.markers.quickfixes;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gdt.eclipse.core.markers.ProjectStructureOrSdkProblemType;
import com.google.gdt.eclipse.core.markers.quickfixes.ConfigureProjectSdkMarkerResolution;
import com.google.gdt.eclipse.core.markers.quickfixes.StopManagingWarOutputDirectoryResolution;
import com.google.gdt.eclipse.core.markers.quickfixes.SynchronizeSdkWebappClasspathMarkerResolution;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gdt.eclipse.core.sdk.UpdateWebInfFolderCommand;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.sdk.GWTUpdateWebInfFolderCommand;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class GWTValidatorMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<Object> markerResolutions = new ArrayList<Object>();
        int problemId = marker.getAttribute("problemTypeId", -1);
        if (problemId == -1) {
            return new IMarkerResolution[0];
        }
        ProjectStructureOrSdkProblemType sdkProblemType = ProjectStructureOrSdkProblemType.getProblemType((int)problemId);
        switch (sdkProblemType) {
            case INVALID_SDK: 
            case NO_SDK: {
                markerResolutions.add(new ConfigureProjectSdkMarkerResolution("GWT", "com.gwtplugins.gwt.eclipse.core.properties.ui.gwtProjectPropertyPage"));
                break;
            }
            case SDK_FILE_SIZE_MISMATCH: 
            case SDK_LIBRARY_MISSING_FROM_WEBINF_LIB: {
                GwtSdk sdk;
                IProject project = marker.getResource().getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)javaProject) && (sdk = GwtSdk.findSdkFor(javaProject)) != null && sdk.validate().isOK()) {
                    markerResolutions.add(new SynchronizeSdkWebappClasspathMarkerResolution((UpdateWebInfFolderCommand)new GWTUpdateWebInfFolderCommand(javaProject, (Sdk)sdk)));
                }
                markerResolutions.add(new StopManagingWarOutputDirectoryResolution(project));
                break;
            }
            case WAR_WITH_PRE_GWT_16: {
                markerResolutions.add(new ConfigureProjectSdkMarkerResolution("GWT", "com.gwtplugins.gwt.eclipse.core.properties.ui.gwtProjectPropertyPage"));
                break;
            }
        }
        return markerResolutions.toArray(new IMarkerResolution[0]);
    }
}

