/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.markers.quickfixes;

import com.google.gdt.eclipse.core.markers.quickfixes.JavaMarkerResolutionGenerator;
import com.google.gwt.eclipse.core.markers.quickfixes.ChangeAsyncMethodReturnTypeProposal;
import com.google.gwt.eclipse.core.markers.quickfixes.CreateAsyncInterfaceProposal;
import com.google.gwt.eclipse.core.markers.quickfixes.CreateAsyncMethodProposal;
import com.google.gwt.eclipse.core.markers.quickfixes.CreateSyncMethodProposal;
import com.google.gwt.eclipse.core.markers.quickfixes.DeleteMethodProposal;
import com.google.gwt.eclipse.core.markers.quickfixes.UpdateAsyncSignatureProposal;
import com.google.gwt.eclipse.core.markers.quickfixes.UpdateSyncSignatureProposal;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceProblemType;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class RemoteServiceProblemMarkerResolutionGenerator
extends JavaMarkerResolutionGenerator {
    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation problem = iProblemLocationArray[n2];
            RemoteServiceProblemType problemType = RemoteServiceProblemType.getProblemType(problem.getProblemId());
            if (problemType != null) {
                switch (problemType) {
                    case MISSING_ASYNC_TYPE: {
                        proposals.addAll(CreateAsyncInterfaceProposal.createProposals(context, problem));
                        break;
                    }
                    case MISSING_ASYNC_METHOD: {
                        if (problem.getProblemArguments()[0].equals("async")) {
                            String syncMethodBindingKey = problem.getProblemArguments()[1];
                            proposals.addAll(CreateAsyncMethodProposal.createProposalsForProblemOnAsyncType(context.getCompilationUnit(), context.getCoveringNode(), syncMethodBindingKey));
                            proposals.addAll(DeleteMethodProposal.createProposalsForProblemOnAsyncType(context.getCoveringNode(), syncMethodBindingKey));
                            proposals.addAll(UpdateAsyncSignatureProposal.createProposalsForProblemsOnAsyncType(context.getCoveringNode(), syncMethodBindingKey));
                            break;
                        }
                        proposals.addAll(CreateAsyncMethodProposal.createProposalsForProblemOnSyncMethod(context.getCoveringNode()));
                        proposals.addAll(DeleteMethodProposal.createProposalsForProblemOnExtraMethod(context.getCoveringNode()));
                        proposals.addAll(UpdateAsyncSignatureProposal.createProposalsForProblemsOnSyncMethod(context.getCoveringNode()));
                        break;
                    }
                    case MISSING_SYNC_METHOD: {
                        if (problem.getProblemArguments()[0].equals("sync")) {
                            String asyncMethodBindingKey = problem.getProblemArguments()[1];
                            proposals.addAll(CreateSyncMethodProposal.createProposalsForProblemOnSyncType(context.getCompilationUnit(), context.getCoveringNode(), asyncMethodBindingKey));
                            proposals.addAll(DeleteMethodProposal.createProposalsForProblemOnSyncType(context.getCoveringNode(), asyncMethodBindingKey));
                            proposals.addAll(UpdateSyncSignatureProposal.createProposalsForProblemsOnSyncType(context.getCoveringNode(), asyncMethodBindingKey));
                            break;
                        }
                        proposals.addAll(CreateSyncMethodProposal.createProposalsForProblemOnAsyncMethod(context.getCoveringNode()));
                        proposals.addAll(DeleteMethodProposal.createProposalsForProblemOnExtraMethod(context.getCoveringNode()));
                        proposals.addAll(UpdateSyncSignatureProposal.createProposalsForProblemsOnAsyncMethod(context.getCoveringNode()));
                        break;
                    }
                    case INVALID_ASYNC_RETURN_TYPE: {
                        proposals.addAll(ChangeAsyncMethodReturnTypeProposal.createProposals(context.getCoveringNode()));
                        break;
                    }
                    case ASYNCCALLBACK_TYPE_ARGUMENT_MISMATCH: {
                        if (problem.getProblemArguments()[0].equals("sync")) {
                            proposals.addAll(UpdateAsyncSignatureProposal.createProposalsForProblemsOnSyncMethod(context.getCoveringNode()));
                            break;
                        }
                        proposals.addAll(UpdateSyncSignatureProposal.createProposalsForProblemsOnAsyncMethod(context.getCoveringNode()));
                        break;
                    }
                }
            }
            ++n2;
        }
        return proposals.toArray(new IJavaCompletionProposal[0]);
    }

    public boolean hasCorrections(ICompilationUnit cu, int problemId) {
        RemoteServiceProblemType problemType = RemoteServiceProblemType.getProblemType(problemId);
        if (problemType != null) {
            switch (problemType) {
                case MISSING_ASYNC_TYPE: 
                case MISSING_ASYNC_METHOD: 
                case MISSING_SYNC_METHOD: 
                case ASYNCCALLBACK_TYPE_ARGUMENT_MISMATCH: 
                case INVALID_ASYNC_RETURN_TYPE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

