/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.modules;

import com.google.gdt.eclipse.core.properties.WebAppProjectProperties;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import com.google.gwt.eclipse.core.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

abstract class AbstractModule
implements IModule {
    protected static final String ADD_LINKER = "add-linker";
    protected static final String CLASS_ATTRIBUTE_NAME = "class";
    protected static final String ENTRY_POINT_TAG_NAME = "entry-point";
    protected static final String INHERITS_TAG_NAME = "inherits";
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected static final String PATH_ATTRIBUTE_NAME = "path";
    protected static final String PUBLIC_PATH_TAG_NAME = "public";
    protected static final String RENAME_TO_ATTRIBUTE = "rename-to";
    protected static final String SET_CONFIGURATION_PROPERTY = "set-configuration-property";
    protected static final String SOURCE_PATH_TAG_NAME = "source";
    protected final IStorage storage;
    private String qualifiedName;

    private static List<String> getElementsAttributes(Document doc, String elementName, String attrName, String defaultValue) {
        ArrayList<String> attrValues = new ArrayList<String>();
        NodeList elements = doc.getElementsByTagName(elementName);
        if (elements != null && elements.getLength() > 0) {
            int i = 0;
            while (i < elements.getLength()) {
                Element element = (Element)elements.item(i);
                String attrValue = element.getAttribute(attrName);
                if (attrValue != null) {
                    attrValues.add(attrValue);
                }
                ++i;
            }
        }
        if (defaultValue != null && attrValues.size() == 0) {
            attrValues.add(defaultValue);
        }
        return attrValues;
    }

    protected AbstractModule(IStorage storage) {
        assert (storage != null);
        this.storage = storage;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractModule)) {
            return false;
        }
        return this.getQualifiedName().equals(((AbstractModule)o).getQualifiedName());
    }

    @Override
    public List<String> getAddLinkers() {
        final ArrayList<String> ret = new ArrayList<String>();
        new ReadModelOperation(this){

            @Override
            public void readModel(IDOMModel model) {
                IDOMDocument doc = model.getDocument();
                ret.addAll(AbstractModule.getElementsAttributes((Document)doc, AbstractModule.ADD_LINKER, AbstractModule.NAME_ATTRIBUTE_NAME, null));
            }
        }.run();
        return ret;
    }

    @Override
    public String getCompiledName() {
        final String[] compiledName = new String[]{this.getQualifiedName()};
        new ReadModelOperation(this){

            @Override
            public void readModel(IDOMModel model) {
                IDOMDocument doc = model.getDocument();
                Element moduleElement = doc.getDocumentElement();
                String renameTo = moduleElement.getAttribute(AbstractModule.RENAME_TO_ATTRIBUTE);
                if (renameTo != null) {
                    compiledName[0] = renameTo;
                }
            }
        }.run();
        return compiledName[0];
    }

    @Override
    public List<String> getEntryPoints() {
        final ArrayList<String> ret = new ArrayList<String>();
        new ReadModelOperation(this){

            @Override
            public void readModel(IDOMModel model) {
                IDOMDocument doc = model.getDocument();
                ret.addAll(AbstractModule.getElementsAttributes((Document)doc, AbstractModule.ENTRY_POINT_TAG_NAME, AbstractModule.CLASS_ATTRIBUTE_NAME, null));
            }
        }.run();
        return ret;
    }

    @Override
    public Set<IModule> getInheritedModules(final IJavaProject javaProject) {
        final HashSet<IModule> modules = new HashSet<IModule>();
        new ReadModelOperation(this){

            @Override
            protected void readModel(IDOMModel model) {
                IDOMDocument doc = model.getDocument();
                for (String moduleName : AbstractModule.getElementsAttributes((Document)doc, AbstractModule.INHERITS_TAG_NAME, AbstractModule.NAME_ATTRIBUTE_NAME, null)) {
                    AbstractModule module = (AbstractModule)ModuleUtils.findModule(javaProject, moduleName, false);
                    if (module == null) continue;
                    modules.add(module);
                }
            }
        }.run();
        return modules;
    }

    @Override
    public String getPackageName() {
        return Signature.getQualifier((String)this.getQualifiedName());
    }

    @Override
    public List<IPath> getPublicPaths() {
        final ArrayList<IPath> ret = new ArrayList<IPath>();
        new ReadModelOperation(this){

            @Override
            public void readModel(IDOMModel model) {
                IDOMDocument doc = model.getDocument();
                List publicPathNames = AbstractModule.getElementsAttributes((Document)doc, AbstractModule.PUBLIC_PATH_TAG_NAME, AbstractModule.PATH_ATTRIBUTE_NAME, AbstractModule.PUBLIC_PATH_TAG_NAME);
                for (String publicPathName : publicPathNames) {
                    ret.add(new Path(publicPathName));
                }
            }
        }.run();
        return ret;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            String shortName = this.getShortName();
            if (shortName != null && !shortName.isEmpty()) {
                this.qualifiedName = this.getGWtMaven2ModuleName();
                return this.qualifiedName;
            }
            this.qualifiedName = Util.removeFileExtension(this.storage.getName());
            String modulePckg = this.doGetPackageName();
            if (modulePckg != null) {
                this.qualifiedName = String.valueOf(modulePckg) + "." + this.qualifiedName;
            }
        }
        return this.qualifiedName;
    }

    private String getShortName() {
        IFile file = (IFile)this.storage;
        IFolder moduleFolder = (IFolder)file.getParent();
        String shortName = WebAppProjectProperties.getGwtMavenModuleShortName((IProject)moduleFolder.getProject());
        return shortName;
    }

    private String getModuleNameGwtMaven2() {
        IFile file = (IFile)this.storage;
        IFolder moduleFolder = (IFolder)file.getParent();
        String moduleName = WebAppProjectProperties.getGwtMavenModuleName((IProject)moduleFolder.getProject());
        moduleName = moduleName.replaceAll(".*\\.(.*)", "$1");
        return moduleName;
    }

    private String getGWtMaven2ModuleName() {
        IFile file = (IFile)this.storage;
        IFolder moduleFolder = (IFolder)file.getParent();
        String moduleName = WebAppProjectProperties.getGwtMavenModuleName((IProject)moduleFolder.getProject());
        return moduleName;
    }

    @Override
    public List<String> getSetConfigurationProperty(final String propertyName) {
        final ArrayList<String> ret = new ArrayList<String>();
        new ReadModelOperation(this){

            @Override
            public void readModel(IDOMModel model) {
                IDOMDocument doc = model.getDocument();
                ret.addAll(AbstractModule.getElementsAttributes((Document)doc, AbstractModule.SET_CONFIGURATION_PROPERTY, propertyName, null));
            }
        }.run();
        return ret;
    }

    @Override
    public String getSimpleName() {
        return Signature.getSimpleName((String)this.getQualifiedName());
    }

    @Override
    public List<IPath> getSourcePaths() {
        final ArrayList<IPath> ret = new ArrayList<IPath>();
        new ReadModelOperation(this){

            @Override
            public void readModel(IDOMModel model) {
                IDOMDocument doc = model.getDocument();
                List sourcePathNames = AbstractModule.getElementsAttributes((Document)doc, AbstractModule.SOURCE_PATH_TAG_NAME, AbstractModule.PATH_ATTRIBUTE_NAME, "client");
                for (String sourcePathName : sourcePathNames) {
                    ret.add(new Path(sourcePathName));
                }
            }
        }.run();
        return ret;
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    protected abstract IDOMModel doGetModelForRead() throws IOException, CoreException;

    protected abstract String doGetPackageName();

    protected abstract class ReadModelOperation {
        protected ReadModelOperation() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            IDOMModel model = null;
            try {
                try {
                    model = AbstractModule.this.doGetModelForRead();
                    this.readModel(model);
                    return;
                }
                catch (IOException e) {
                    GWTPluginLog.logError(e);
                    if (model == null) return;
                    model.releaseFromRead();
                    return;
                }
                catch (CoreException e) {
                    GWTPluginLog.logError(e);
                    if (model == null) return;
                    model.releaseFromRead();
                    return;
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }

        protected abstract void readModel(IDOMModel var1);
    }
}

