/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.modules;

import com.google.gdt.eclipse.core.properties.WebAppProjectProperties;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.modules.AbstractModule;
import com.google.gwt.eclipse.core.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Element;

public class ModuleFile
extends AbstractModule {
    protected ModuleFile(IFile file) {
        super((IStorage)file);
    }

    public void addEntryPoint(final String qualifiedTypeName) throws Exception {
        new EditModelOperation(this){

            @Override
            public void editModel(IDOMModel model) {
                IDOMDocument editDoc = model.getDocument();
                Element entryPointElement = editDoc.createElement("entry-point");
                entryPointElement.setAttribute("class", qualifiedTypeName);
                editDoc.getDocumentElement().appendChild(entryPointElement);
                new FormatProcessorXML().formatModel((IStructuredModel)model);
            }
        }.run();
    }

    public IFile getFile() {
        return (IFile)this.storage;
    }

    public IFolder getFolder(IPath moduleRelativePath) {
        IPath moduleFolderPath = this.storage.getFullPath().removeLastSegments(1);
        IPath folderPath = moduleFolderPath.append(moduleRelativePath);
        IResource folder = Util.getWorkspaceRoot().findMember(folderPath);
        return (IFolder)folder;
    }

    public int getLineOfOffset(final int offset) {
        final int[] line = new int[1];
        new AbstractModule.ReadModelOperation(this){

            @Override
            protected void readModel(IDOMModel model) {
                line[0] = model.getStructuredDocument().getLineOfOffset(offset);
            }
        }.run();
        return line[0];
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    public boolean isPublicPath(IFolder folder) {
        IFolder[] publicFolders = this.getFolders(this.getPublicPaths());
        IContainer moduleContainer = this.getFile().getParent();
        IFolder container = folder;
        while (container.getType() == 2) {
            if (container.equals((Object)moduleContainer)) {
                return false;
            }
            IFolder[] iFolderArray = publicFolders;
            int n = publicFolders.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder publicFolder = iFolderArray[n2];
                if (container.equals((Object)publicFolder)) {
                    return true;
                }
                ++n2;
            }
            container = container.getParent();
        }
        return false;
    }

    public boolean isSourcePackage(IPackageFragment pckg) {
        IResource resource = pckg.getResource();
        if (resource.getType() == 2) {
            IPath pckgFolderPath = resource.getFullPath();
            IFolder[] iFolderArray = this.getFolders(this.getSourcePaths());
            int n = iFolderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder clientFolder = iFolderArray[n2];
                IPath clientFolderPath = clientFolder.getFullPath();
                if (clientFolderPath.isPrefixOf(pckgFolderPath)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    protected IDOMModel doGetModelForRead() throws IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        return (IDOMModel)modelManager.getModelForRead(this.getFile());
    }

    @Override
    protected String doGetPackageName() {
        IFolder moduleFolder = (IFolder)this.getFile().getParent();
        IJavaElement javaElement = JavaCore.create((IFolder)moduleFolder);
        String mavenModuleName = WebAppProjectProperties.getGwtMavenModuleName((IProject)moduleFolder.getProject());
        String shortName = WebAppProjectProperties.getGwtMavenModuleShortName((IProject)moduleFolder.getProject());
        if (mavenModuleName != null && !mavenModuleName.isEmpty() && shortName != null && !shortName.isEmpty() && mavenModuleName.contains(".")) {
            String gwtMavenPackage2 = mavenModuleName.replaceAll("(.*)\\..*", "$1");
            return gwtMavenPackage2;
        }
        if (javaElement != null && javaElement.getElementType() == 4) {
            return javaElement.getElementName();
        }
        return "";
    }

    private IJavaElement getGwtMavenModuleNameForGwtMavenPlugin2(IProject project) {
        if (project == null) {
            return null;
        }
        IFolder moduleFolder = (IFolder)this.getFile().getParent();
        if (!moduleFolder.toString().contains("src/main")) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        String moduleName = WebAppProjectProperties.getGwtMavenModuleName((IProject)project);
        if (moduleName == null || !moduleName.contains(".")) {
            return null;
        }
        String[] moduleNameParts = moduleName.split("\\.");
        IPath path = moduleFolder.getFullPath().append("java");
        int i = 0;
        while (i < moduleNameParts.length - 1) {
            path = path.append(moduleNameParts[i]);
            ++i;
        }
        try {
            return javaProject.findPackageFragment(path);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    private IJavaElement findSourceFolderElement(IFolder moduleFolder) {
        IFolder folderSourcePackage = this.findSourcePackage(moduleFolder, "client");
        if (folderSourcePackage == null) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)folderSourcePackage.getProject());
        if (javaProject == null) {
            return null;
        }
        try {
            IPackageFragment clientPackage = javaProject.findPackageFragment(folderSourcePackage.getFullPath());
            return clientPackage;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IFolder[] getFolders(List<IPath> paths) {
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        for (IPath path : paths) {
            IFolder folder = this.getFolder(path);
            if (folder == null) continue;
            folders.add(folder);
        }
        return folders.toArray(new IFolder[0]);
    }

    private IFolder findSourcePackage(IFolder folder, String name) {
        IResource[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException e) {
            return null;
        }
        if (members == null) {
            return null;
        }
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getType() == 2) {
                if (member.getName().equals(name)) {
                    return folder;
                }
                return this.findSourcePackage((IFolder)member, name);
            }
            ++n2;
        }
        return null;
    }

    private abstract class EditModelOperation {
        private EditModelOperation() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            IDOMModel model = null;
            try {
                try {
                    model = this.getModelForEdit();
                    model.aboutToChangeModel();
                    this.editModel(model);
                    model.changedModel();
                    if (model.isSharedForEdit() || !model.isSaveNeeded()) return;
                    model.save();
                    return;
                }
                catch (IOException e) {
                    GWTPluginLog.logError(e);
                    if (model == null) return;
                    model.releaseFromEdit();
                    return;
                }
                catch (CoreException e) {
                    GWTPluginLog.logError(e);
                    if (model == null) return;
                    model.releaseFromEdit();
                    return;
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromEdit();
                }
            }
        }

        protected abstract void editModel(IDOMModel var1);

        private IDOMModel getModelForEdit() throws IOException, CoreException {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            return (IDOMModel)modelManager.getModelForEdit(ModuleFile.this.getFile());
        }
    }
}

