/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.modules;

import com.google.gdt.eclipse.core.AdapterUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.modules.ModuleJarResource;
import com.google.gwt.eclipse.core.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public final class ModuleUtils {
    private static final String FILE_EXTENSION = ".gwt.xml";

    public static ModuleFile create(IFile file) {
        if (!ModuleUtils.isModuleXml((IResource)file)) {
            return null;
        }
        return new ModuleFile(file);
    }

    public static ModuleJarResource create(IJarEntryResource jarResource) {
        if (!ModuleUtils.isModuleXml(jarResource)) {
            return null;
        }
        return new ModuleJarResource(jarResource);
    }

    public static IModule[] findAllModules(IJavaProject javaProject, final boolean includeJars) {
        final HashMap<String, IModule> modules = new HashMap<String, IModule>();
        ModuleUtils.visitFragments(javaProject, includeJars, new IPackageFragmentVisitor<Void>(){

            @Override
            public Void visit(IPackageFragment pckg) throws JavaModelException {
                ModuleUtils.testNonJavaResourcesForModules(pckg, modules, includeJars);
                return null;
            }
        });
        try {
            ModuleUtils.checkGwtMavenPlugin2SrcMain(javaProject, modules);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modules.values().toArray(new IModule[modules.size()]);
    }

    protected static void testNonJavaResourcesForModules(IPackageFragment pckg, Map<String, IModule> modules, boolean includeJars) throws JavaModelException {
        Object[] objectArray = pckg.getNonJavaResources();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String moduleName;
            Object resource = objectArray[n2];
            IModule module = ModuleUtils.create(resource, includeJars);
            if (module != null && !modules.containsKey(moduleName = module.getQualifiedName())) {
                modules.put(moduleName, module);
            }
            ++n2;
        }
    }

    private static void checkGwtMavenPlugin2SrcMain(IJavaProject javaProject, Map<String, IModule> modules) throws CoreException {
        IFolder folderSrc = javaProject.getProject().getFolder("src");
        if (folderSrc == null) {
            return;
        }
        IFolder folderMain = folderSrc.getFolder("main");
        if (folderMain == null) {
            return;
        }
        IResource[] resourcesFiles = folderMain.members();
        if (resourcesFiles == null) {
            return;
        }
        IResource[] iResourceArray = resourcesFiles;
        int n = resourcesFiles.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleFile module;
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1 && (module = ModuleUtils.create((IFile)resource)) != null) {
                String moduleName = module.getQualifiedName();
                modules.put(moduleName, module);
            }
            ++n2;
        }
    }

    public static IModule[] findChildModules(IContainer container) {
        final ArrayList modules = new ArrayList();
        IResourceVisitor moduleVisitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                ModuleFile module;
                if (resource.getType() == 1 && (module = ModuleUtils.create((IFile)resource)) != null) {
                    modules.add(module);
                }
                return true;
            }
        };
        try {
            container.accept(moduleVisitor, 1, false);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
        }
        return modules.toArray(new IModule[modules.size()]);
    }

    public static IModule findModule(IJavaProject javaProject, String qualifiedName, final boolean includeJars) {
        final String modulePckg = Signature.getQualifier((String)qualifiedName);
        final String simpleName = Signature.getSimpleName((String)qualifiedName);
        return ModuleUtils.visitFragments(javaProject, includeJars, new IPackageFragmentVisitor<IModule>(){

            @Override
            public IModule visit(IPackageFragment pckg) throws JavaModelException {
                if (modulePckg.equals(pckg.getElementName())) {
                    Object[] objectArray = pckg.getNonJavaResources();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object resource = objectArray[n2];
                        IModule module = ModuleUtils.create(resource, includeJars);
                        if (module != null && module.getSimpleName().equals(simpleName)) {
                            return module;
                        }
                        ++n2;
                    }
                }
                return null;
            }
        });
    }

    public static boolean isModuleXml(IJarEntryResource jarResource) {
        return jarResource.isFile() && jarResource.getName().endsWith(FILE_EXTENSION);
    }

    public static boolean isModuleXml(IResource resource) {
        if (resource.getType() != 1) {
            return false;
        }
        if (resource.getParent().getType() != 2) {
            return false;
        }
        return resource.getName().endsWith(FILE_EXTENSION);
    }

    public static IStatus validateQualifiedModuleName(String qualifiedName) {
        String pckg = Signature.getQualifier((String)qualifiedName);
        if (!Util.isValidPackageName(pckg)) {
            return Util.newErrorStatus("The module package name is invalid");
        }
        return ModuleUtils.validateSimpleModuleName(Signature.getSimpleName((String)qualifiedName));
    }

    public static IStatus validateSimpleModuleName(String simpleName) {
        String complianceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        String sourceLevel = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        if (simpleName.indexOf(46) != -1) {
            return Util.newErrorStatus("Module name should not contain dots.");
        }
        IStatus nameStatus = JavaConventions.validateJavaTypeName((String)simpleName, (String)complianceLevel, (String)sourceLevel);
        if (nameStatus.matches(4)) {
            return Util.newErrorStatus("The module name is invalid");
        }
        return Status.OK_STATUS;
    }

    private static IModule create(Object resource, boolean allowModulesInJars) {
        IFile file = (IFile)AdapterUtilities.getAdapter((Object)resource, IFile.class);
        if (file != null) {
            return ModuleUtils.create(file);
        }
        IJarEntryResource jarEntryRes = (IJarEntryResource)AdapterUtilities.getAdapter((Object)resource, IJarEntryResource.class);
        if (jarEntryRes != null && allowModulesInJars) {
            return ModuleUtils.create(jarEntryRes);
        }
        return null;
    }

    private static <T> T visitFragments(IJavaProject project, boolean includeJars, IPackageFragmentVisitor<T> visitor) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot pckgRoot = iPackageFragmentRootArray[n2];
                if (!pckgRoot.isArchive() || includeJars) {
                    IJavaElement[] iJavaElementArray = pckgRoot.getChildren();
                    int n3 = iJavaElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement elem = iJavaElementArray[n4];
                        T result = visitor.visit((IPackageFragment)elem);
                        if (result != null) {
                            return result;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
        }
        return null;
    }

    private ModuleUtils() {
    }

    private static interface IPackageFragmentVisitor<T> {
        public T visit(IPackageFragment var1) throws JavaModelException;
    }
}

