/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.nature;

import com.google.gdt.eclipse.core.BuilderUtilities;
import com.google.gdt.eclipse.core.MarkerUtilities;
import com.google.gdt.eclipse.core.natures.NatureUtils;
import com.google.gdt.eclipse.core.validators.WebAppProjectValidator;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.validators.java.JavaCompilationParticipant;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class GWTNature
implements IProjectNature {
    public static final String NATURE_ID = "com.gwtplugins.gwt.eclipse.core.gwtNature";
    private IProject project;

    public static void addNatureToProject(IProject project) throws CoreException {
        NatureUtils.addNature((IProject)project, (String)NATURE_ID);
    }

    public static boolean isGWTProject(IProject project) {
        boolean isAccessible = project.isAccessible();
        boolean hasGwtNature = false;
        boolean hasGwtFacet = false;
        try {
            hasGwtNature = project.hasNature(NATURE_ID);
        }
        catch (CoreException e) {
            GWTPluginLog.logError("isGWTProject(project) hasGwtnature exception " + e.getMessage());
        }
        try {
            hasGwtFacet = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"com.gwtplugins.gwt.facet");
        }
        catch (CoreException e) {
            GWTPluginLog.logError("isGWTProject(project) hasGwtFacet exception " + e.getMessage());
        }
        return isAccessible && (hasGwtNature || hasGwtFacet);
    }

    public static void removeNatureFromProject(IProject project) throws CoreException {
        if (!project.hasNature(NATURE_ID)) {
            return;
        }
        JavaCompilationParticipant.cleanBuildArtifacts(project);
        MarkerUtilities.clearMarkers((String)"com.gwtplugins.gwt.eclipse.core.gwtProjectProblemMarker", (IProject)project);
        NatureUtils.removeNature((IProject)project, (String)NATURE_ID);
    }

    private static void resetDefaultEditors() {
        Util.resetDefaultEditor("java");
        Util.resetDefaultEditor("xml");
    }

    public void configure() throws CoreException {
        BuilderUtilities.addBuilderToProject((IProject)this.project, (String)"com.gwtplugins.gdt.eclipse.core.webAppProjectValidator");
        BuilderUtilities.addBuilderToProject((IProject)this.project, (String)"com.gwtplugins.gwt.eclipse.core.gwtProjectValidator");
        GWTNature.resetDefaultEditors();
    }

    public void deconfigure() throws CoreException {
        BuilderUtilities.removeBuilderFromProject((IProject)this.project, (String)"com.gwtplugins.gwt.eclipse.core.gwtProjectValidator");
        WebAppProjectValidator.removeBuilderIfNoGwtNature((IProject)this.project);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

