/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.preferences;

import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gdt.eclipse.core.sdk.ClasspathContainerUpdateJob;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gdt.eclipse.core.sdk.SdkManager;
import com.google.gdt.eclipse.core.sdk.SdkSet;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.sdk.GWTUpdateWebInfFolderCommand;
import java.io.FileNotFoundException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.osgi.service.prefs.BackingStoreException;

public class GWTPreferences {
    private static final String REMOVE_TERMINATED_LAUNCHES = "removeTerminatedLaunches";
    private static SdkManager<GwtSdk> sdkManager = new SdkManager("com.gwtplugins.gwt.eclipse.core.GWT_CONTAINER", GWTPreferences.getEclipsePreferences(), GwtSdk.getFactory());
    private static final String SOURCE_VIEWER_SERVER_PORT = "sourceViewerServerPort";
    private static final String JSO_PROPERTY_TYPE = "com.google.gwt.core.client.debug.JsoInspector$JsoProperty";

    static {
        sdkManager.addSdkUpdateListener((SdkManager.SdkUpdateListener)new SdkManager.SdkUpdateListener<GwtSdk>(){

            public void onSdkUpdate(SdkManager.SdkUpdateEvent<GwtSdk> sdkUpdateEvent) throws CoreException {
                IJavaProject[] projects;
                SdkManager sdkManager = sdkManager;
                sdkManager.getClass();
                SdkManager.SdkUpdateEventProcessor sdkUpdateEventProcessor = new SdkManager.SdkUpdateEventProcessor(sdkManager, sdkUpdateEvent);
                IJavaProject[] iJavaProjectArray = projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject project = iJavaProjectArray[n2];
                    if (GWTNature.isGWTProject(project.getProject()) && !GWTProjectsRuntime.isGWTRuntimeProject(project)) {
                        try {
                            GwtSdk sdk = (GwtSdk)sdkUpdateEventProcessor.getUpdatedSdkForProject(project);
                            if (sdk != null && WebAppUtilities.hasManagedWarOut((IProject)project.getProject())) {
                                new GWTUpdateWebInfFolderCommand(project, (Sdk)sdk).execute();
                            }
                        }
                        catch (FileNotFoundException e) {
                            GWTPluginLog.logError(e);
                        }
                        catch (BackingStoreException e) {
                            GWTPluginLog.logError(e);
                        }
                    }
                    ++n2;
                }
                ClasspathContainerUpdateJob classpathContainerUpdateJob = new ClasspathContainerUpdateJob("ClasspathContainerUpdateJob", "com.gwtplugins.gwt.eclipse.core.GWT_CONTAINER");
                classpathContainerUpdateJob.schedule();
            }
        });
    }

    public static GwtSdk getDefaultRuntime() {
        SdkSet<GwtSdk> sdkSet = GWTPreferences.getSdks();
        return (GwtSdk)sdkSet.getDefault();
    }

    public static boolean getJsoDetailFormatting() {
        String[] formatters;
        String[] stringArray = formatters = JavaDebugOptionsManager.parseList((String)JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
        int n = formatters.length;
        int n2 = 0;
        while (n2 < n) {
            String formatter = stringArray[n2];
            if (JSO_PROPERTY_TYPE.equals(formatter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean getRemoveTerminatedLaunches() {
        return GWTPreferences.getEclipsePreferences().getBoolean(REMOVE_TERMINATED_LAUNCHES, true);
    }

    public static GwtSdk getRuntime(String name) {
        SdkSet<GwtSdk> sdkSet = GWTPreferences.getSdks();
        for (GwtSdk runtime : sdkSet) {
            if (!runtime.getName().equals(name)) continue;
            return runtime;
        }
        return null;
    }

    public static SdkManager<GwtSdk> getSdkManager() {
        return sdkManager;
    }

    public static SdkSet<GwtSdk> getSdks() {
        return GWTPreferences.getSdkManager().getSdks();
    }

    public static int getSourceViewerServerPort() {
        return GWTPreferences.getEclipsePreferences().getInt(SOURCE_VIEWER_SERVER_PORT, 50313);
    }

    public static boolean getUiBinderWizardGenerateContentDefault() {
        return GWTPreferences.getEclipsePreferences().getBoolean("com.gwtplugins.gwt.eclipse.core.uiBinderWizardGenerateContentDefault", false);
    }

    public static boolean hasRuntime(String name) {
        return GWTPreferences.getRuntime(name) != null;
    }

    public static void setJsoDetailFormatting(boolean formatting) {
        DetailFormatter formatter = new DetailFormatter(JSO_PROPERTY_TYPE, "toString()", true);
        if (formatting) {
            JavaDetailFormattersManager.getDefault().setAssociatedDetailFormatter(formatter);
            JDIDebugUIPlugin.getDefault().getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_SHOW_DETAILS, "INLINE_FORMATTERS");
        } else {
            JavaDetailFormattersManager.getDefault().removeAssociatedDetailFormatter(formatter);
        }
    }

    public static void setRemoveTerminatedLaunches(boolean remove) {
        IEclipsePreferences workspacePreferences = GWTPreferences.getEclipsePreferences();
        workspacePreferences.putBoolean(REMOVE_TERMINATED_LAUNCHES, remove);
        try {
            workspacePreferences.flush();
        }
        catch (BackingStoreException e) {
            CorePluginLog.logError((Throwable)e);
        }
    }

    public static void setSdks(SdkSet<GwtSdk> sdkSet) {
        try {
            GWTPreferences.getSdkManager().setSdks(sdkSet);
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
        }
    }

    public static void setSourceViewerServerPort(int port) {
        IEclipsePreferences workspacePreferences = GWTPreferences.getEclipsePreferences();
        workspacePreferences.putInt(SOURCE_VIEWER_SERVER_PORT, port);
        try {
            workspacePreferences.flush();
        }
        catch (BackingStoreException e) {
            CorePluginLog.logError((Throwable)e);
        }
    }

    public static void setUiBinderWizardGenerateContentDefault(boolean generateComments) {
        GWTPreferences.getEclipsePreferences().putBoolean("com.gwtplugins.gwt.eclipse.core.uiBinderWizardGenerateContentDefault", generateComments);
    }

    private static IEclipsePreferences getEclipsePreferences() {
        IEclipsePreferences workspacePrefs = InstanceScope.INSTANCE.getNode("com.gwtplugins.gwt.eclipse.core");
        return workspacePrefs;
    }

    private GWTPreferences() {
    }
}

