/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.preferences.ui;

import com.google.gdt.eclipse.core.browser.BrowserUtilities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gdt.eclipse.core.sdk.SdkSet;
import com.google.gdt.eclipse.core.ui.SdkTable;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.preferences.GWTPreferences;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.sdk.ui.AddGwtSdkDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GwtPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.gwtplugins.gwt.eclipse.core.preferences.ui.GwtPreferencePage";
    private SdkSet<GwtSdk> sdkSet;

    public GwtPreferencePage() {
    }

    public GwtPreferencePage(String title) {
        super(title);
    }

    public GwtPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        assert (this.sdkSet != null);
        GWTPreferences.setSdks(this.sdkSet);
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.sdkSet = GWTPreferences.getSdks();
        return new SdkTable<GwtSdk>(parent, 0, this.sdkSet, null, (DialogPage)this){

            protected IStatus doAddSdk() {
                AddGwtSdkDialog addGwtSdkDialog = new AddGwtSdkDialog(this.getShell(), (SdkSet<GwtSdk>)GwtPreferencePage.this.sdkSet, "com.gwtplugins.gwt.eclipse.core", "Add GWT SDK", GwtSdk.getFactory());
                if (addGwtSdkDialog.open() == 0) {
                    GwtSdk newSdk = (GwtSdk)addGwtSdkDialog.getSdk();
                    if (newSdk != null) {
                        GwtPreferencePage.this.sdkSet.add((Sdk)newSdk);
                    }
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }

            protected IStatus doDownloadSdk() {
                MessageDialog dialog = new MessageDialog(GWTPlugin.getActiveWorkbenchShell(), "GWT Eclipse Plugin", null, "Would you like to open the GWT download page in your web browser?\n\nFrom there, you can download the latest GWT SDK and extract it to the location of your choice. Add it to Eclipse with the \"Add...\" button.", 3, new String[]{"Open Browser", IDialogConstants.CANCEL_LABEL}, 0);
                if (dialog.open() == 0) {
                    if (BrowserUtilities.launchBrowserAndHandleExceptions((String)GWTPlugin.SDK_DOWNLOAD_URL) == null) {
                        return Status.CANCEL_STATUS;
                    }
                } else {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
    }
}

