/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.properties;

import com.google.gdt.eclipse.core.PropertiesUtilities;
import com.google.gwt.eclipse.core.compile.GWTCompileSettings;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.service.prefs.BackingStoreException;

public final class GWTProjectProperties {
    private static final String ENTRY_POINT_MODULES = "entryPointModules";
    private static final String FILES_COPIED_TO_WEB_INF_LIB = "filesCopiedToWebInfLib";
    private static final String GWT_COMPILE_SETTINGS_XML = "gwtCompileSettings";
    private static final String SYNC_CODESERVER_RUNNING = "gwtSyncCodeServer";

    public static List<String> getDefaultEntryPointModules(IProject project) {
        ArrayList<String> moduleNames = new ArrayList<String>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        HashMap<String, Set<IModule>> inheritedModulesCache = new HashMap<String, Set<IModule>>();
        HashMap<String, List<String>> entryPointsCache = new HashMap<String, List<String>>();
        IModule[] iModuleArray = ModuleUtils.findAllModules(javaProject, false);
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (GWTProjectProperties.getEntryPoints(javaProject, module, entryPointsCache).size() > 0 || GWTProjectProperties.getInheritedEntryPoints(javaProject, module, inheritedModulesCache, entryPointsCache).size() > 0) {
                moduleNames.add(module.getQualifiedName());
            }
            ++n2;
        }
        return moduleNames;
    }

    public static List<String> getDefinedEntryPointModules(IProject project) {
        String rawPropVal = GWTProjectProperties.getProjectProperties(project).get(ENTRY_POINT_MODULES, null);
        return PropertiesUtilities.deserializeStrings((String)rawPropVal);
    }

    public static List<String> getEntryPointModules(IProject project) {
        List<String> moduleNames = GWTProjectProperties.getDefinedEntryPointModules(project);
        if (moduleNames.isEmpty()) {
            moduleNames = GWTProjectProperties.getDefaultEntryPointModules(project);
        }
        return moduleNames;
    }

    public static List<String> getFileNamesCopiedToWebInfLib(IProject project) {
        IEclipsePreferences prefs = GWTProjectProperties.getProjectProperties(project);
        String rawPropVal = prefs.get(FILES_COPIED_TO_WEB_INF_LIB, null);
        if (rawPropVal == null || rawPropVal.length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(rawPropVal.split("\\|"));
    }

    public static GWTCompileSettings getGwtCompileSettings(IProject project) {
        IEclipsePreferences prefs = GWTProjectProperties.getProjectProperties(project);
        byte[] settingsBytes = prefs.getByteArray(GWT_COMPILE_SETTINGS_XML, new byte[0]);
        GWTCompileSettings settings = GWTCompileSettings.deserialize(settingsBytes, project);
        if (settings == null) {
            settings = new GWTCompileSettings(project);
        }
        return settings;
    }

    public static void setFacetSyncCodeServer(IProject project, Boolean syncCodeServer) throws BackingStoreException {
        IEclipsePreferences prefs = GWTProjectProperties.getProjectProperties(project);
        prefs.put(SYNC_CODESERVER_RUNNING, syncCodeServer.toString());
        prefs.flush();
    }

    public static boolean getFacetSyncCodeServer(IProject project) {
        IEclipsePreferences prefs = GWTProjectProperties.getProjectProperties(project);
        String valueStr = prefs.get(SYNC_CODESERVER_RUNNING, "true");
        Boolean b = Boolean.valueOf(valueStr);
        return b;
    }

    public static void setEntryPointModules(IProject project, List<String> modules) throws BackingStoreException {
        IEclipsePreferences prefs = GWTProjectProperties.getProjectProperties(project);
        String rawPropVal = PropertiesUtilities.serializeStrings(modules);
        prefs.put(ENTRY_POINT_MODULES, rawPropVal);
        prefs.flush();
    }

    public static void setFileNamesCopiedToWebInfLib(IProject project, List<String> fileNamesCopiedToWebInfLib) throws BackingStoreException {
        IEclipsePreferences prefs = GWTProjectProperties.getProjectProperties(project);
        StringBuilder sb = new StringBuilder();
        boolean addPipe = false;
        for (String fileNameCopiedToWebInfLib : fileNamesCopiedToWebInfLib) {
            if (addPipe) {
                sb.append("|");
            } else {
                addPipe = true;
            }
            sb.append(fileNameCopiedToWebInfLib);
        }
        prefs.put(FILES_COPIED_TO_WEB_INF_LIB, sb.toString());
        prefs.flush();
    }

    public static void setFilesCopiedToWebInfLib(IProject project, List<File> filesCopiedToWebInfLib) throws BackingStoreException {
        GWTProjectProperties.setFileNamesCopiedToWebInfLib(project, GWTProjectProperties.toFileNames(filesCopiedToWebInfLib));
    }

    public static void setGwtCompileSettings(IProject project, GWTCompileSettings settings) throws BackingStoreException {
        IEclipsePreferences prefs = GWTProjectProperties.getProjectProperties(project);
        prefs.putByteArray(GWT_COMPILE_SETTINGS_XML, settings.toByteArray());
        prefs.flush();
    }

    private static Set<IModule> getAllInheritedModules(IJavaProject javaProject, IModule module, Map<String, Set<IModule>> inheritedModulesCache) {
        return GWTProjectProperties.getAllInheritedModulesRecurse(javaProject, module, new HashSet<String>(), inheritedModulesCache);
    }

    private static Set<IModule> getAllInheritedModulesRecurse(IJavaProject javaProject, IModule module, Set<String> explored, Map<String, Set<IModule>> inheritedModulesCache) {
        String moduleName = module.getQualifiedName();
        if (explored.contains(moduleName)) {
            return Collections.emptySet();
        }
        explored.add(moduleName);
        HashSet<IModule> inheritedModules = new HashSet<IModule>();
        for (IModule m : GWTProjectProperties.getInheritedModules(javaProject, module, inheritedModulesCache)) {
            inheritedModules.add(m);
            inheritedModules.addAll(GWTProjectProperties.getAllInheritedModulesRecurse(javaProject, m, explored, inheritedModulesCache));
        }
        return inheritedModules;
    }

    private static List<String> getEntryPoints(IJavaProject javaproject, IModule module, Map<String, List<String>> cache) {
        String moduleName = module.getQualifiedName();
        List<String> res = cache.get(moduleName);
        if (res == null) {
            res = module.getEntryPoints();
            cache.put(moduleName, res);
        }
        return res;
    }

    private static List<String> getInheritedEntryPoints(IJavaProject javaProject, IModule module, Map<String, Set<IModule>> inheritedModulesCache, Map<String, List<String>> entryPointsCache) {
        ArrayList<String> entryPoints = new ArrayList<String>();
        for (IModule m : GWTProjectProperties.getAllInheritedModules(javaProject, module, inheritedModulesCache)) {
            entryPoints.addAll(GWTProjectProperties.getEntryPoints(javaProject, m, entryPointsCache));
        }
        return entryPoints;
    }

    private static Set<IModule> getInheritedModules(IJavaProject javaProject, IModule module, Map<String, Set<IModule>> cache) {
        String moduleName = module.getQualifiedName();
        Set<IModule> res = cache.get(moduleName);
        if (res == null) {
            res = module.getInheritedModules(javaProject);
            cache.put(moduleName, res);
        }
        return res;
    }

    private static IEclipsePreferences getProjectProperties(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        return projectScope.getNode("com.gwtplugins.gwt.eclipse.core");
    }

    private static List<String> toFileNames(List<File> files) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : files) {
            fileNames.add(file.getName());
        }
        return fileNames;
    }

    private GWTProjectProperties() {
    }
}

