/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.properties.ui;

import com.google.gdt.eclipse.core.BuilderUtilities;
import com.google.gdt.eclipse.core.ClasspathUtilities;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.extensions.ExtensionQuery;
import com.google.gdt.eclipse.core.properties.WebAppProjectProperties;
import com.google.gdt.eclipse.core.sdk.SdkManager;
import com.google.gdt.eclipse.core.sdk.UpdateProjectSdkCommand;
import com.google.gdt.eclipse.core.ui.AbstractProjectPropertyPage;
import com.google.gdt.eclipse.core.ui.ProjectSdkSelectionBlock;
import com.google.gdt.eclipse.core.ui.SdkSelectionBlock;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.launch.ui.EntryPointModulesSelectionBlock;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.preferences.GWTPreferences;
import com.google.gwt.eclipse.core.properties.GWTProjectProperties;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.sdk.GWTUpdateProjectSdkCommand;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;

public class GWTProjectPropertyPage
extends AbstractProjectPropertyPage {
    public static final String ID = "com.gwtplugins.gwt.eclipse.core.properties.ui.gwtProjectPropertyPage";
    private EntryPointModulesSelectionBlock entryPointModulesBlock;
    private List<String> initialEntryPointModules;
    private boolean initialUseGWT;
    private ProjectSdkSelectionBlock<GwtSdk> sdkSelectionBlock;
    private boolean useGWT;
    private Button useGWTCheckbox;

    public GWTProjectPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        this.useGWTCheckbox = new Button(panel, 32);
        this.useGWTCheckbox.setText("Use GWT");
        this.createSdkComponent(panel);
        this.createEntryPointModuleComponent(panel);
        this.recordInitialSettings();
        this.initializeControls();
        this.addEventHandlers();
        this.fieldChanged();
        return panel;
    }

    protected void saveProjectProperties() throws BackingStoreException, CoreException, FileNotFoundException {
        if (this.hasNatureChanged() || this.hasSdkChanged()) {
            if (this.useGWT) {
                this.addGWT();
            } else {
                this.removeGWT();
            }
        }
        if (this.useGWT) {
            this.saveChangesToEntryPointModules();
        }
    }

    private void addEventHandlers() {
        this.useGWTCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GWTProjectPropertyPage.this.fieldChanged();
            }
        });
    }

    private void addGWT() throws CoreException, BackingStoreException, FileNotFoundException {
        MessageDialog dlg;
        IEditorReference[] openEditors;
        IProject project = this.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        WebAppProjectProperties.maybeSetWebAppPropertiesForDynamicWebProject((IProject)project);
        if (this.sdkSelectionBlock.hasSdkChanged() && !GWTProjectsRuntime.isGWTRuntimeProject(javaProject)) {
            SdkSelectionBlock.SdkSelection sdkSelection = this.sdkSelectionBlock.getSdkSelection();
            boolean isDefault = false;
            GwtSdk newSdk = null;
            if (sdkSelection != null) {
                newSdk = (GwtSdk)sdkSelection.getSelectedSdk();
                isDefault = sdkSelection.isDefault();
            }
            GwtSdk oldSdk = (GwtSdk)this.sdkSelectionBlock.getInitialSdk();
            UpdateProjectSdkCommand.UpdateType updateType = GWTUpdateProjectSdkCommand.computeUpdateType(oldSdk, newSdk, isDefault);
            GWTUpdateProjectSdkCommand updateProjectSdkCommand = new GWTUpdateProjectSdkCommand(javaProject, oldSdk, newSdk, updateType, null);
            updateProjectSdkCommand.execute();
        }
        GWTNature.addNatureToProject(project);
        BuilderUtilities.scheduleRebuild((IProject)project);
        if (!this.initialUseGWT && this.useGWT && (openEditors = GWTProjectPropertyPage.getOpenJavaEditors(project)).length > 0 && (dlg = new MessageDialog(GWTPlugin.getActiveWorkbenchShell(), GWTPlugin.getName(), null, "GWT editing functionality, such as syntax-colored JSNI blocks, will only be enabled after you re-open your Java editors.\n\nDo you want to re-open your editors now?", 3, new String[]{"Re-open Java editors", "No"}, 0)).open() == 0) {
            GWTProjectPropertyPage.reopenWithGWTJavaEditor(openEditors);
        }
    }

    private void createEntryPointModuleComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"Entry Point Modules", (int)3, (int)1, (int)1808);
        GridLayout groupLayout = (GridLayout)group.getLayout();
        groupLayout.marginBottom = 8;
        group.setLayout((Layout)groupLayout);
        this.entryPointModulesBlock = new EntryPointModulesSelectionBlock(null);
        this.entryPointModulesBlock.doFillIntoGrid((Composite)group, 3);
    }

    private void createSdkComponent(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)"GWT SDK", (int)1, (int)1, (int)768);
        this.sdkSelectionBlock = new ProjectSdkSelectionBlock<GwtSdk>((Composite)group, 0, this.getJavaProject()){

            protected void doConfigure() {
                if (PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"com.gwtplugins.gwt.eclipse.core.preferences.ui.GwtPreferencePage", (String[])new String[]{"com.gwtplugins.gwt.eclipse.core.preferences.ui.GwtPreferencePage"}, null).open() == 0) {
                    GWTProjectPropertyPage.this.fieldChanged();
                }
            }

            protected GwtSdk doFindSdkFor(IJavaProject javaProject) {
                return GwtSdk.findSdkFor(javaProject);
            }

            protected String doGetContainerId() {
                return "com.gwtplugins.gwt.eclipse.core.GWT_CONTAINER";
            }

            protected SdkManager<GwtSdk> doGetSdkManager() {
                return GWTPreferences.getSdkManager();
            }
        };
    }

    private void fieldChanged() {
        this.validateFields();
        this.updateControls();
    }

    public static IEditorReference[] getOpenJavaEditors(IProject project) {
        ArrayList<IEditorReference> projectOpenJavaEditors = new ArrayList<IEditorReference>();
        try {
            IWorkbenchPage page = JavaPlugin.getActivePage();
            if (page != null) {
                IEditorReference[] openEditors;
                IEditorReference[] iEditorReferenceArray = openEditors = page.getEditorReferences();
                int n = openEditors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorInput input;
                    IJavaProject inputProject;
                    IEditorReference openEditor = iEditorReferenceArray[n2];
                    IEditorPart editor = openEditor.getEditor(false);
                    if (editor instanceof CompilationUnitEditor && (inputProject = EditorUtility.getJavaProject((IEditorInput)(input = openEditor.getEditorInput()))) != null && inputProject.getProject().equals((Object)project)) {
                        projectOpenJavaEditors.add(openEditor);
                    }
                    ++n2;
                }
            }
        }
        catch (PartInitException e) {
            GWTPluginLog.logError(e);
        }
        return projectOpenJavaEditors.toArray(new IEditorReference[0]);
    }

    private boolean hasNatureChanged() {
        return this.useGWT ^ this.initialUseGWT;
    }

    private boolean hasSdkChanged() {
        return this.sdkSelectionBlock.hasSdkChanged();
    }

    private void initializeControls() {
        this.useGWTCheckbox.setSelection(this.initialUseGWT);
        this.entryPointModulesBlock.setJavaProject(this.getJavaProject());
        this.entryPointModulesBlock.setDefaultModules(GWTProjectProperties.getDefaultEntryPointModules(this.getProject()));
        this.entryPointModulesBlock.setModules(this.initialEntryPointModules);
    }

    private void recordInitialSettings() {
        this.initialUseGWT = GWTNature.isGWTProject(this.getProject());
        this.initialEntryPointModules = GWTProjectProperties.getEntryPointModules(this.getProject());
    }

    public void removeGWT() throws BackingStoreException, CoreException {
        GWTNature.removeNatureFromProject(this.getProject());
        ClasspathUtilities.replaceContainerWithClasspathEntries((IJavaProject)this.getJavaProject(), (String)"com.gwtplugins.gwt.eclipse.core.GWT_CONTAINER");
        GWTProjectProperties.setFileNamesCopiedToWebInfLib(this.getProject(), Collections.emptyList());
        GWTPluginLog.logInfo("Removed GWT from project " + this.getProject().getName() + ".");
    }

    public static void reopenWithGWTJavaEditor(IEditorReference[] openEditors) {
        IWorkbenchPage page = JavaPlugin.getActivePage();
        IEditorReference[] iEditorReferenceArray = openEditors;
        int n = openEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            try {
                IEditorPart editor = editorRef.getEditor(false);
                IEditorInput input = editorRef.getEditorInput();
                if (page.closeEditor(editor, true)) {
                    IEditorPart gwtEditor = page.openEditor(input, "com.gwtplugins.gwt.eclipse.core.editors.gwtJavaEditor");
                    gwtEditor.doSave(null);
                }
            }
            catch (PartInitException e) {
                GWTPluginLog.logError(e, "Could not open GWT Java editor on {0}", editorRef.getTitleToolTip());
            }
            ++n2;
        }
    }

    private void saveChangesToEntryPointModules() throws BackingStoreException {
        List<String> userEntryPointModules = new ArrayList<String>();
        if (!this.entryPointModulesBlock.isDefault()) {
            userEntryPointModules = this.entryPointModulesBlock.getModules();
        }
        GWTProjectProperties.setEntryPointModules(this.getProject(), userEntryPointModules);
    }

    private void updateControls() {
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        boolean shouldEnable = !GWTProjectsRuntime.isGWTRuntimeProject(javaProject);
        ExtensionQuery extQuery = new ExtensionQuery("com.gwtplugins.gwt.eclipse.core", "gwtSdkSelectionEnablementFinder", "class");
        List enablementFinders = extQuery.getData();
        for (ExtensionQuery.Data enablementFinder : enablementFinders) {
            shouldEnable = ((GwtSdkSelectionEnablementFinder)enablementFinder.getExtensionPointData()).shouldEnableGwtSdkSelection(javaProject.getProject());
        }
        if (shouldEnable) {
            this.sdkSelectionBlock.setEnabled(this.useGWT);
            this.entryPointModulesBlock.setEnabled(this.useGWT);
        } else {
            this.sdkSelectionBlock.setEnabled(false);
            this.entryPointModulesBlock.setEnabled(false);
        }
    }

    private void validateFields() {
        IStatus useGWTStatus = this.validateUseGWT();
        IStatus sdkStatus = this.validateSdk();
        this.updateStatus(new IStatus[]{useGWTStatus, sdkStatus});
    }

    private IStatus validateSdk() {
        if (!this.useGWT) {
            return StatusUtilities.OK_STATUS;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
        if (!GWTProjectsRuntime.isGWTRuntimeProject(javaProject) && this.sdkSelectionBlock.getSdks().isEmpty()) {
            return StatusUtilities.newErrorStatus((String)"Please configure an SDK", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        return StatusUtilities.OK_STATUS;
    }

    private IStatus validateUseGWT() {
        this.useGWT = this.useGWTCheckbox.getSelection();
        return StatusUtilities.OK_STATUS;
    }

    public void addGWT(IProject project, GwtSdk runtime) throws BackingStoreException, FileNotFoundException, CoreException {
        MessageDialog dlg;
        IEditorReference[] openEditors;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        WebAppProjectProperties.maybeSetWebAppPropertiesForDynamicWebProject((IProject)project);
        boolean isDefault = false;
        GwtSdk newSdk = runtime;
        GwtSdk oldSdk = runtime;
        UpdateProjectSdkCommand.UpdateType updateType = GWTUpdateProjectSdkCommand.computeUpdateType(oldSdk, newSdk, isDefault);
        GWTUpdateProjectSdkCommand updateProjectSdkCommand = new GWTUpdateProjectSdkCommand(javaProject, oldSdk, newSdk, updateType, null);
        updateProjectSdkCommand.execute();
        GWTNature.addNatureToProject(project);
        BuilderUtilities.scheduleRebuild((IProject)project);
        if (!this.initialUseGWT && this.useGWT && (openEditors = GWTProjectPropertyPage.getOpenJavaEditors(project)).length > 0 && (dlg = new MessageDialog(GWTPlugin.getActiveWorkbenchShell(), GWTPlugin.getName(), null, "GWT editing functionality, such as syntax-colored JSNI blocks, will only be enabled after you re-open your Java editors.\n\nDo you want to re-open your editors now?", 3, new String[]{"Re-open Java editors", "No"}, 0)).open() == 0) {
            GWTProjectPropertyPage.reopenWithGWTJavaEditor(openEditors);
        }
    }

    public void removeGWTSdkForFacet(IProject project) throws BackingStoreException, CoreException {
        GWTNature.removeNatureFromProject(project);
        ClasspathUtilities.replaceContainerWithClasspathEntries((IJavaProject)JavaCore.create((IProject)project), (String)"com.gwtplugins.gwt.eclipse.core.GWT_CONTAINER");
        GWTProjectProperties.setFileNamesCopiedToWebInfLib(project, Collections.emptyList());
        GWTPluginLog.logInfo("Removed GWT from project " + project.getName() + ".");
    }

    public static interface GwtSdkSelectionEnablementFinder {
        public boolean shouldEnableGwtSdkSelection(IProject var1);
    }
}

