/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.propertytesters;

import com.google.gdt.eclipse.core.AdapterUtilities;
import com.google.gdt.eclipse.core.CorePluginLog;
import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gwt.eclipse.core.launch.GWTJUnitPropertyTester;
import com.google.gwt.eclipse.core.nature.GWTNature;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;

public class GwtLaunchTargetTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        assert (receiver != null);
        IResource resource = (IResource)AdapterUtilities.getAdapter((Object)receiver, IResource.class);
        if (resource == null) {
            return false;
        }
        resource = ResourceUtils.resolveTargetResource((IResource)resource);
        try {
            return this.isGwtProject(resource) && (this.resourceIsProject(resource) || this.receiverIsJavaButNotTestCase(receiver) || this.resourceIsDeploymentDescriptor(resource) || this.resourceIsHostPage(resource) || this.resourceIsGwtXmlAndInGwt(resource));
        }
        catch (CoreException ce) {
            CorePluginLog.logError((Throwable)ce);
            return false;
        }
    }

    private boolean isGwtProject(IResource resource) {
        return GWTNature.isGWTProject(resource.getProject());
    }

    private boolean receiverIsJavaButNotTestCase(Object receiver) {
        if (AdapterUtilities.getAdapter((Object)receiver, IJavaElement.class) == null) {
            return false;
        }
        GWTJUnitPropertyTester tester = new GWTJUnitPropertyTester();
        return !tester.test(receiver, "isGWTTest", null, null);
    }

    private boolean resourceIsDeploymentDescriptor(IResource resource) {
        IFolder webInf;
        IProject project = resource.getProject();
        if (WebAppUtilities.isWebApp((IProject)project) && (webInf = WebAppUtilities.getWebInfSrc((IProject)project)).exists() && resource.getParent().equals((Object)webInf)) {
            String name = resource.getName();
            return name.equals("web.xml") || name.equals("appengine-web.xml");
        }
        return false;
    }

    private boolean resourceIsGwtXmlAndInGwt(IResource resource) throws CoreException {
        return GWTNature.isGWTProject(resource.getProject()) && resource.getName().endsWith(".gwt.xml");
    }

    private boolean resourceIsHostPage(IResource resource) {
        IProject project = resource.getProject();
        if (WebAppUtilities.isWebApp((IProject)project)) {
            IFolder war = WebAppUtilities.getWarSrc((IProject)project);
            if (war != null && war.getFullPath().isPrefixOf(resource.getFullPath())) {
                return ResourceUtils.hasJspOrHtmlExtension((IResource)resource);
            }
        } else {
            return "html".equalsIgnoreCase(resource.getFileExtension());
        }
        return false;
    }

    private boolean resourceIsProject(IResource resource) {
        if (resource == null) {
            return false;
        }
        IProject proj = resource.getProject();
        boolean out = proj == resource;
        return out;
    }
}

