/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring;

import com.google.gwt.eclipse.core.refactoring.ChangeUtilities;
import com.google.gwt.eclipse.core.refactoring.RefactoringException;
import com.google.gwt.eclipse.core.refactoring.RefactoringUtilities;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class ChangeBuilder<D extends RefactoringDescriptor> {
    private final Class<D> descriptorType;
    private final String contributionId;
    private Refactoring refactoring;
    private Change change;
    private final IWorkspace workspace;

    public ChangeBuilder(Class<D> descriptorType, String contributionId, IWorkspace workspace) {
        this.descriptorType = descriptorType;
        this.contributionId = contributionId;
        this.workspace = workspace;
    }

    public Change createChange() throws RefactoringException {
        if (this.change != null) {
            return this.change;
        }
        if (this.refactoring == null) {
            this.refactoring = this.createRefactoring();
        }
        this.change = ChangeUtilities.createChange(this.workspace, (IProgressMonitor)new NullProgressMonitor(), this.refactoring, 4);
        return this.change;
    }

    public Refactoring createRefactoring() throws RefactoringException {
        if (this.refactoring != null) {
            return this.refactoring;
        }
        RefactoringStatus status = new RefactoringStatus();
        D descriptor = this.createDescriptor();
        try {
            this.refactoring = descriptor.createRefactoring(status);
        }
        catch (CoreException e) {
            throw new RefactoringException(e);
        }
        if (this.refactoring == null) {
            throw new RefactoringException(String.format("The refactoring descriptor (%s) was unable to create a refactoring.", descriptor.getClass().getSimpleName()));
        }
        if (status.hasError()) {
            throw new RefactoringException(status.getMessageMatchingSeverity(3));
        }
        return this.refactoring;
    }

    protected abstract void configureDescriptor(D var1);

    protected void validateDescriptor(RefactoringDescriptor descriptor) throws RefactoringException {
        if (!this.descriptorType.isInstance(descriptor)) {
            throw new RefactoringException(String.format("The refactoring descriptor (%s) is an unexpected type (expecting %s).", descriptor.getClass().getSimpleName(), this.descriptorType.getSimpleName()));
        }
    }

    private D createDescriptor() throws RefactoringException {
        RefactoringDescriptor refactoringDescriptor = RefactoringUtilities.createDescriptor(this.contributionId);
        this.validateDescriptor(refactoringDescriptor);
        RefactoringDescriptor descriptor = refactoringDescriptor;
        this.configureDescriptor(descriptor);
        return (D)descriptor;
    }
}

