/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring;

import com.google.gwt.eclipse.core.refactoring.RefactoringException;
import com.google.gwt.eclipse.core.refactoring.TextEditUtilities;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;

public class ChangeUtilities {
    public static void acceptOnChange(Change change, ChangeVisitor visitor) {
        if (change instanceof CompositeChange) {
            CompositeChange compositeChange = (CompositeChange)change;
            Change[] changeArray = compositeChange.getChildren();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change curChange = changeArray[n2];
                ChangeUtilities.acceptOnChange(curChange, visitor);
                ++n2;
            }
        }
        visitor.visit(change);
    }

    public static CompilationUnitChange cloneCompilationUnitChangeWithDifferentCu(TextFileChange originalChange, ICompilationUnit cu) {
        CompilationUnitChange newChange = new CompilationUnitChange(originalChange.getName(), cu);
        newChange.setEdit(originalChange.getEdit());
        newChange.setEnabledShallow(originalChange.isEnabled());
        newChange.setKeepPreviewEdits(originalChange.getKeepPreviewEdits());
        newChange.setSaveMode(originalChange.getSaveMode());
        newChange.setTextType(originalChange.getTextType());
        TextEditUtilities.moveTextEditGroupsIntoChange(originalChange.getChangeGroups(), (TextChange)newChange);
        return newChange;
    }

    public static Change createChange(IWorkspace workspace, IProgressMonitor pm, Refactoring refactoring, int errorLevel) throws RefactoringException {
        CreateChangeOperation createChangeOperation = ChangeUtilities.createCreateChangeOperation(refactoring, errorLevel);
        try {
            workspace.run((IWorkspaceRunnable)createChangeOperation, pm);
            RefactoringStatus status = createChangeOperation.getConditionCheckingStatus();
            if (status.getSeverity() >= errorLevel) {
                throw new RefactoringException(status.getMessageMatchingSeverity(status.getSeverity()));
            }
        }
        catch (CoreException e) {
            throw new RefactoringException(e);
        }
        return createChangeOperation.getChange();
    }

    public static void insertChange(Change change, int insertIndex, CompositeChange parentChange) {
        Change[] changes = parentChange.getChildren();
        if (insertIndex >= changes.length) {
            parentChange.add(change);
        } else {
            Change[] changeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                Change curChange = changeArray[n2];
                parentChange.remove(curChange);
                ++n2;
            }
            int i = 0;
            while (i < changes.length) {
                if (i == insertIndex) {
                    parentChange.add(change);
                }
                parentChange.add(changes[i]);
                ++i;
            }
        }
    }

    public static boolean mergeParticipantTextChanges(final RefactoringParticipant participant, Change rootChange) {
        final ArrayList dupChanges = new ArrayList();
        ChangeUtilities.acceptOnChange(rootChange, new ChangeVisitor(){

            @Override
            public void visit(Change change) {
                if (change instanceof TextEditBasedChange) {
                    TextEditBasedChange textChange = (TextEditBasedChange)change;
                    TextChange existingTextChange = participant.getTextChange(textChange.getModifiedElement());
                    if (existingTextChange == null) {
                        return;
                    }
                    TextEditUtilities.moveTextEditGroupsIntoChange(textChange.getChangeGroups(), existingTextChange);
                    dupChanges.add(textChange);
                }
            }
        });
        for (Change dupChange : dupChanges) {
            ChangeUtilities.removeChange(dupChange, (CompositeChange)dupChange.getParent());
        }
        return dupChanges.contains(rootChange);
    }

    public static Change performChange(IWorkspace workspace, IProgressMonitor pm, Change change) throws CoreException {
        PerformChangeOperation performChangeOperation = new PerformChangeOperation(change);
        try {
            workspace.run((IWorkspaceRunnable)performChangeOperation, pm);
        }
        finally {
            if (!performChangeOperation.changeExecuted()) {
                change.dispose();
            }
        }
        return performChangeOperation.getUndoChange();
    }

    public static int removeChange(Change change, CompositeChange parentChange) {
        Change[] changes = parentChange.getChildren();
        int index = 0;
        while (index < changes.length) {
            if (changes[index] == change) {
                parentChange.remove(change);
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static boolean replaceChange(Change originalChange, ReplacementChangeFactory replacementChangeFactory) {
        Change parentChange = originalChange.getParent();
        if (parentChange == null || !(parentChange instanceof CompositeChange)) {
            return false;
        }
        int oldIndex = ChangeUtilities.removeChange(originalChange, (CompositeChange)parentChange);
        if (oldIndex == -1) {
            return false;
        }
        Change newChange = replacementChangeFactory.createChange(originalChange);
        if (newChange == null) {
            return false;
        }
        ChangeUtilities.insertChange(newChange, oldIndex, (CompositeChange)parentChange);
        return true;
    }

    private static CreateChangeOperation createCreateChangeOperation(Refactoring refactoring, int errorLevel) {
        CheckConditionsOperation checkConditionsOperation = new CheckConditionsOperation(refactoring, 6);
        return new CreateChangeOperation(checkConditionsOperation, errorLevel);
    }

    public static interface ChangeVisitor {
        public void visit(Change var1);
    }

    public static class EmptyChange
    extends Change {
        public Object getModifiedElement() {
            return null;
        }

        public String getName() {
            return "Empty change";
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            return null;
        }
    }

    public static interface ReplacementChangeFactory {
        public Change createChange(Change var1);
    }
}

