/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring;

import com.google.gwt.eclipse.core.refactoring.IRefactoringChangeFactory;
import com.google.gwt.eclipse.core.search.IIndexedJavaRef;
import com.google.gwt.eclipse.core.search.JavaQueryParticipant;
import com.google.gwt.eclipse.core.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public abstract class GWTRefactoringSupport {
    private IJavaElement newElement;
    private IJavaElement oldElement;
    private boolean updateReferences;

    public CompositeChange createChange(RefactoringParticipant participant, IRefactoringChangeFactory changeFactory) {
        if (!this.updateReferences) {
            return null;
        }
        CompositeChange result = null;
        Set<IIndexedJavaRef> refs = JavaQueryParticipant.findWorkspaceReferences(this.oldElement, true);
        Map<IPath, Set<TextEdit>> edits = this.createEdits(refs);
        for (IPath source : edits.keySet()) {
            IFile file = Util.getWorkspaceRoot().getFile(source);
            TextFileChange change = changeFactory.createChange(file);
            MultiTextEdit rootEdit = new MultiTextEdit();
            change.setEdit((TextEdit)rootEdit);
            change.setKeepPreviewEdits(true);
            for (TextEdit edit : edits.get(source)) {
                rootEdit.addChild(edit);
                change.addTextEditGroup(new TextEditGroup(this.getEditDescription(), edit));
            }
            if (result == null) {
                result = new CompositeChange(participant.getName());
            }
            result.add((Change)change);
        }
        return result;
    }

    public Map<IPath, Set<TextEdit>> createEdits(Set<IIndexedJavaRef> refs) {
        HashMap<IPath, Set<TextEdit>> edits = new HashMap<IPath, Set<TextEdit>>();
        for (IIndexedJavaRef ref : refs) {
            TextEdit edit = this.createEdit(ref);
            IPath source = ref.getSource();
            if (edits.containsKey(source)) {
                ((Set)edits.get(source)).add(edit);
                continue;
            }
            HashSet<TextEdit> sourcEdits = new HashSet<TextEdit>();
            sourcEdits.add(edit);
            edits.put(source, sourcEdits);
        }
        return edits;
    }

    public IJavaElement getNewElement() {
        return this.newElement;
    }

    public IJavaElement getOldElement() {
        return this.oldElement;
    }

    public boolean getUpdateReferences() {
        return this.updateReferences;
    }

    public void setNewElement(IJavaElement newElement) {
        this.newElement = newElement;
    }

    public void setOldElement(IJavaElement oldElement) {
        this.oldElement = oldElement;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.updateReferences = updateReferences;
    }

    protected abstract TextEdit createEdit(IIndexedJavaRef var1);

    protected abstract String getEditDescription();
}

