/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.refactoring.GWTRefactoringSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

abstract class GWTRenameParticipant
extends RenameParticipant {
    private GWTRefactoringSupport refactoringSupport;

    GWTRenameParticipant() {
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public final GWTRefactoringSupport getRefactoringSupport() {
        if (this.refactoringSupport == null) {
            this.refactoringSupport = this.createRefactoringSupport();
        }
        return this.refactoringSupport;
    }

    protected abstract GWTRefactoringSupport createRefactoringSupport();

    protected JavaRenameProcessor getRenameProcessor() {
        JavaRenameProcessor processor = (JavaRenameProcessor)this.getProcessor();
        if (processor instanceof RenameCompilationUnitProcessor) {
            return ((RenameCompilationUnitProcessor)processor).getRenameTypeProcessor();
        }
        return processor;
    }

    protected boolean initialize(Object element) {
        if (element instanceof IType || element instanceof IMethod || element instanceof IField) {
            GWTRefactoringSupport support = this.getRefactoringSupport();
            IMember oldMember = (IMember)element;
            support.setOldElement((IJavaElement)oldMember);
            try {
                JavaRenameProcessor processor = this.getRenameProcessor();
                IJavaElement newElement = (IJavaElement)processor.getNewElement();
                IType declaringType = oldMember.getDeclaringType();
                String newElementName = newElement.getElementName();
                if (element instanceof IField) {
                    newElement = declaringType.getField(newElementName);
                } else if (element instanceof IMethod) {
                    IMethod method = (IMethod)newElement;
                    newElement = declaringType.getMethod(newElementName, method.getParameterTypes());
                } else assert (element instanceof IType);
                support.setNewElement(newElement);
                support.setUpdateReferences(this.getArguments().getUpdateReferences());
                return true;
            }
            catch (CoreException e) {
                GWTPluginLog.logError(e);
            }
        }
        return false;
    }
}

