/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.platformproxy.refactoring.IJsniReferenceChange;
import com.google.gwt.eclipse.core.search.IIndexedJavaRef;
import com.google.gwt.eclipse.core.search.IndexedJsniJavaRef;
import com.google.gwt.eclipse.core.search.JavaQueryParticipant;
import com.google.gwt.eclipse.core.validators.java.JavaCompilationParticipant;
import com.google.gwt.eclipse.core.validators.java.JsniJavaRef;
import com.google.gwt.eclipse.core.validators.java.UnresolvedJsniJavaRefException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JsniReferenceChangeHelper {
    private final IJsniReferenceChange jsniReferenceChange;

    public JsniReferenceChangeHelper(IJsniReferenceChange jsniReferenceChange) {
        this.jsniReferenceChange = jsniReferenceChange;
    }

    public void perform(IProgressMonitor pm, ICompilationUnit cu, TextEdit rootEdit) throws CoreException {
        TextEdit[] oldEdits = rootEdit.removeChildren();
        RefactoringASTParser parser = new RefactoringASTParser(4);
        CompilationUnit astNode = parser.parse((ITypeRoot)cu, false);
        JavaCompilationParticipant.validateCompilationUnit((ASTNode)astNode);
        IJavaElement oldElement = this.jsniReferenceChange.getRefactoringSupport().getOldElement();
        Set<IIndexedJavaRef> refs = JavaQueryParticipant.findWorkspaceReferences(oldElement, false);
        Iterator<IIndexedJavaRef> iterator = refs.iterator();
        while (iterator.hasNext()) {
            IIndexedJavaRef ref = iterator.next();
            if (ref.getSource().equals((Object)cu.getPath()) && this.resolvesToRefactoredElement(cu, ref)) continue;
            iterator.remove();
        }
        Set<TextEdit> newEdits = this.jsniReferenceChange.getRefactoringSupport().createEdits(refs).get(cu.getPath());
        assert (newEdits != null);
        assert (oldEdits.length == newEdits.size());
        rootEdit.addChildren(newEdits.toArray(new TextEdit[0]));
    }

    public JsniJavaRef refactorJavaRef(IIndexedJavaRef ref) {
        JsniJavaRef tempRef = new JsniJavaRef((JsniJavaRef)((Object)ref));
        tempRef.setOffset(0);
        Document dummyDoc = new Document(tempRef.toString());
        TextEdit edit = this.jsniReferenceChange.getRefactoringSupport().createEdit(new IndexedJsniJavaRef(tempRef));
        try {
            edit.apply((IDocument)dummyDoc);
        }
        catch (Exception e) {
            GWTPluginLog.logError(e);
            return null;
        }
        return JsniJavaRef.parse(dummyDoc.get());
    }

    public boolean resolvesToRefactoredElement(ICompilationUnit cu, IIndexedJavaRef ref) {
        IJavaElement refactoredElement = this.jsniReferenceChange.getRefactoringSupport().getNewElement();
        if (refactoredElement == null) {
            return false;
        }
        if (refactoredElement.getElementType() == 7) {
            return true;
        }
        JsniJavaRef refactoredRef = this.refactorJavaRef(ref);
        if (refactoredRef != null) {
            try {
                assert (refactoredElement instanceof IMethod || refactoredElement instanceof IField);
                IJavaProject javaProject = cu.getJavaProject();
                IJavaElement refactoredRefElement = refactoredRef.resolveJavaElement(javaProject);
                return refactoredElement.equals(refactoredRefElement);
            }
            catch (UnresolvedJsniJavaRefException unresolvedJsniJavaRefException) {
                // empty catch block
            }
        }
        return false;
    }
}

