/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring;

import com.google.gwt.eclipse.core.platformproxy.refactoring.IJsniTypeReferenceChange;
import com.google.gwt.eclipse.core.search.JavaRefIndex;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;

public class JsniTypeReferenceChangeHelper {
    private final IJsniTypeReferenceChange jsniTypeReferenceChange;

    public JsniTypeReferenceChangeHelper(IJsniTypeReferenceChange jsniTypeReferenceChange) {
        this.jsniTypeReferenceChange = jsniTypeReferenceChange;
    }

    public ICompilationUnit getNewCompilationUnit() {
        return this.jsniTypeReferenceChange.getRefactoringSupport().getNewType().getCompilationUnit();
    }

    public boolean hasCompilationUnitPathChanged(ICompilationUnit cu) {
        IType oldType = this.jsniTypeReferenceChange.getRefactoringSupport().getOldType();
        return oldType.getDeclaringType() == null && oldType.getCompilationUnit().getPath().equals((Object)cu.getPath());
    }

    public void perform(IProgressMonitor pm, ICompilationUnit cu) throws CoreException {
        IPath oldCuPath = this.jsniTypeReferenceChange.getRefactoringSupport().getOldType().getPath();
        JavaRefIndex.getInstance().clear(oldCuPath);
        if (this.hasCompilationUnitPathChanged(cu)) {
            ICompilationUnit newCu = this.getNewCompilationUnit();
            this.jsniTypeReferenceChange.setCompilationUnit(newCu);
        }
    }
}

