/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public final class TextEditUtilities {
    public static TextEditGroup findTextEditGroup(TextEditBasedChange change, TextEdit edit) {
        for (TextEditGroup group : TextEditUtilities.getTextEditGroups(change.getChangeGroups())) {
            TextEdit[] textEditArray = group.getTextEdits();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit curEdit = textEditArray[n2];
                if (edit == curEdit) {
                    return group;
                }
                ++n2;
            }
        }
        return null;
    }

    public static List<TextEditGroup> getTextEditGroups(TextEditBasedChangeGroup[] changeGroups) {
        ArrayList<TextEditGroup> textEditGroups = new ArrayList<TextEditGroup>(changeGroups.length);
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = changeGroups;
        int n = changeGroups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditBasedChangeGroup changeGroup = textEditBasedChangeGroupArray[n2];
            textEditGroups.add(changeGroup.getTextEditGroup());
            ++n2;
        }
        return textEditGroups;
    }

    public static void moveTextEditGroupsIntoChange(TextEditBasedChangeGroup[] groups, TextChange textChange) {
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditBasedChangeGroup changeGroup = textEditBasedChangeGroupArray[n2];
            TextEditGroup group = changeGroup.getTextEditGroup();
            TextEdit[] textEditArray = group.getTextEdits();
            int n3 = textEditArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TextEdit edit = textEditArray[n4];
                if (edit.getParent() != null) {
                    edit.getParent().removeChild(edit);
                }
                textChange.addEdit(edit);
                ++n4;
            }
            TextEditBasedChangeGroup newChangeGroup = new TextEditBasedChangeGroup((TextEditBasedChange)textChange, group);
            newChangeGroup.setEnabled(changeGroup.isEnabled());
            textChange.addChangeGroup(newChangeGroup);
            ++n2;
        }
    }

    public static boolean removeTextEdit(TextEdit edit, TextEditGroup group, TextEditBasedChange change) {
        Change parentChange;
        TextFileChange textFileChange;
        boolean removed = false;
        boolean removeChange = false;
        TextEdit parentEdit = edit.getParent();
        if (parentEdit != null) {
            removed |= parentEdit.removeChild(edit);
            if (!parentEdit.hasChildren()) {
                edit = parentEdit;
            }
        }
        if (group != null) {
            TextEditBasedChangeGroup[] changeGroups;
            removed |= group.removeTextEdit(edit);
            if (group.getTextEdits().length == 0 && change != null && (changeGroups = change.getChangeGroups()).length == 1 && changeGroups[0].getTextEditGroup().equals(group)) {
                removeChange = true;
            }
        }
        if (!removeChange && change != null && change instanceof TextFileChange && edit.equals((Object)(textFileChange = (TextFileChange)change).getEdit())) {
            removeChange = true;
        }
        if (removeChange && change != null && (parentChange = change.getParent()) instanceof CompositeChange) {
            removed |= ((CompositeChange)parentChange).remove((Change)change);
        }
        return removed;
    }

    public static boolean replaceTextEdit(List<TextEditGroup> textEditGroups, TextEdit oldEdit, TextEdit newEdit) {
        TextEdit parentEdit = oldEdit.getParent();
        if (parentEdit != null) {
            return TextEditUtilities.replaceTextEdit(parentEdit, oldEdit, newEdit);
        }
        for (TextEditGroup group : textEditGroups) {
            TextEdit[] edits = group.getTextEdits();
            if (!TextEditUtilities.replaceTextEdit(oldEdit, newEdit, edits)) {
                return false;
            }
            group.clearTextEdits();
            TextEdit[] textEditArray = edits;
            int n = edits.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit edit = textEditArray[n2];
                group.addTextEdit(edit);
                ++n2;
            }
        }
        return true;
    }

    private static boolean replaceTextEdit(TextEdit parentEdit, TextEdit oldEdit, TextEdit newEdit) {
        TextEdit[] children = parentEdit.removeChildren();
        TextEditUtilities.replaceTextEdit(oldEdit, newEdit, children);
        parentEdit.addChildren(children);
        return true;
    }

    private static boolean replaceTextEdit(TextEdit oldEdit, TextEdit newEdit, TextEdit[] children) {
        int index = 0;
        while (index < children.length) {
            if (children[index] == oldEdit) {
                children[index] = newEdit;
                break;
            }
            ++index;
        }
        return index != children.length;
    }

    private TextEditUtilities() {
    }
}

