/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.regionupdater;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.refactoring.regionupdater.ReferenceUpdater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;

public class CompilationUnitRenamedReferenceUpdater
extends ReferenceUpdater {
    private final String oldElementName;
    private final String newElementName;
    private final String oldCuName;
    private final String newCuName;

    public CompilationUnitRenamedReferenceUpdater(String oldElementName, String newElementName, String oldCompilationUnitName, String newCompilationUnitName) {
        this.oldElementName = oldElementName;
        this.newElementName = newElementName;
        this.oldCuName = oldCompilationUnitName;
        this.newCuName = newCompilationUnitName;
    }

    @Override
    public String getUpdatedBindingKey(String bindingKey) {
        String paddedBindingKey = "@" + bindingKey + "@";
        Pattern pattern = Pattern.compile(String.format("([L/])%s(;)", Pattern.quote(this.oldElementName)));
        Matcher matcher = pattern.matcher(paddedBindingKey);
        String newPaddedBindingKey = matcher.replaceAll(String.format("$1%s$2", Matcher.quoteReplacement(this.newElementName)));
        return newPaddedBindingKey.substring(1, newPaddedBindingKey.length() - 1);
    }

    @Override
    public ICompilationUnit getUpdatedCompilationUnit(ICompilationUnit compilationUnit) {
        if (!compilationUnit.getElementName().equals(this.oldCuName)) {
            return compilationUnit;
        }
        if (!(compilationUnit.getParent() instanceof IPackageFragment)) {
            GWTPluginLog.logWarning(String.format("The parent of %s is not a package fragment (it is %s of type %s).", compilationUnit.getElementName(), compilationUnit.getParent().getElementName(), compilationUnit.getParent().getClass().getSimpleName()));
            return compilationUnit;
        }
        IPackageFragment pkgFragment = (IPackageFragment)compilationUnit.getParent();
        ICompilationUnit newCu = pkgFragment.getCompilationUnit(this.newCuName);
        return newCu;
    }
}

