/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.regionupdater;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class EquivalentNodeFinder {
    private static final int NOT_FROM_LIST = -2;
    private final ASTNode originalNode;
    private final ASTNode ancestorNode;
    private final ASTNode newAncestorNode;
    private final ASTMatcher matcher;

    public EquivalentNodeFinder(ASTNode node, ASTNode ancestorNode, ASTNode newAncestorNode, ASTMatcher matcher) {
        this.originalNode = node;
        this.ancestorNode = ancestorNode;
        this.newAncestorNode = newAncestorNode;
        this.matcher = matcher;
    }

    public ASTNode find() {
        final ASTNode[] foundNode = new ASTNode[1];
        this.newAncestorNode.accept(new ASTVisitor(true){

            public void preVisit(ASTNode visitedNode) {
                if (foundNode[0] != null) {
                    return;
                }
                if (!EquivalentNodeFinder.this.treesMatch(EquivalentNodeFinder.this.originalNode, visitedNode, EquivalentNodeFinder.this.ancestorNode, EquivalentNodeFinder.this.newAncestorNode, EquivalentNodeFinder.this.matcher)) {
                    return;
                }
                foundNode[0] = visitedNode;
            }
        });
        return foundNode[0];
    }

    private int getIndex(ASTNode node) {
        List parentsChildren;
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent != null && locationInParent.isChildListProperty() && (parentsChildren = (List)node.getParent().getStructuralProperty(locationInParent)) != null) {
            return parentsChildren.indexOf(node);
        }
        return -2;
    }

    private boolean indexMatches(ASTNode node, ASTNode otherNode) {
        return this.getIndex(node) == this.getIndex(otherNode);
    }

    private boolean treesMatch(ASTNode node, ASTNode otherNode, ASTNode topmostAncestorNode, ASTNode topmostNewAncestorNode, ASTMatcher matcher) {
        while (node == topmostAncestorNode == (otherNode == topmostNewAncestorNode)) {
            if (node == topmostAncestorNode) {
                return true;
            }
            if (!node.subtreeMatch(matcher, (Object)otherNode)) {
                return false;
            }
            if (!this.indexMatches(node, otherNode)) {
                return false;
            }
            node = node.getParent();
            otherNode = otherNode.getParent();
        }
        return false;
    }
}

