/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.regionupdater;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.refactoring.ChangeUtilities;
import com.google.gwt.eclipse.core.refactoring.RefactoringException;
import com.google.gwt.eclipse.core.refactoring.TextEditUtilities;
import com.google.gwt.eclipse.core.refactoring.regionupdater.ReferenceUpdater;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RegionUpdater;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RegionUpdaterChange
extends CompositeChange {
    private TextFileChange compilationUnitChange;
    private final List<RegionUpdater> regionUpdaters;
    private final ReferenceUpdater referenceUpdater;

    public RegionUpdaterChange(String name, TextFileChange compilationUnitChange, List<RegionUpdater> regionUpdaters, ReferenceUpdater referenceUpdater) {
        super(name);
        assert (compilationUnitChange.getModifiedElement() instanceof ICompilationUnit);
        this.compilationUnitChange = compilationUnitChange;
        this.regionUpdaters = regionUpdaters;
        this.referenceUpdater = referenceUpdater;
        this.markAsSynthetic();
        this.add((Change)compilationUnitChange);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ICompilationUnit cuInterface = (ICompilationUnit)this.compilationUnitChange.getModifiedElement();
        ICompilationUnit updatedCuInterface = this.referenceUpdater.getUpdatedCompilationUnit(cuInterface);
        if (updatedCuInterface != cuInterface) {
            this.remove((Change)this.compilationUnitChange);
            this.compilationUnitChange = ChangeUtilities.cloneCompilationUnitChangeWithDifferentCu(this.compilationUnitChange, updatedCuInterface);
            this.add((Change)this.compilationUnitChange);
        }
        if (updatedCuInterface == null) {
            GWTPluginLog.logWarning(String.format("The compilation unit (%s) is invalid and a corresponding valid compilation unit could not be found.", this.compilationUnitChange.getModifiedElement()));
            return new ChangeUtilities.EmptyChange();
        }
        CompilationUnit cu = JavaASTUtils.parseCompilationUnit((ICompilationUnit)updatedCuInterface);
        for (RegionUpdater regionUpdater : this.regionUpdaters) {
            ReplaceEdit originalEdit = regionUpdater.getOriginalEdit();
            ReplaceEdit newEdit = null;
            try {
                newEdit = regionUpdater.createUpdatedEdit(cu);
            }
            catch (RefactoringException e) {
                GWTPluginLog.logError(e, "Could not get an updated edit region, skipping this edit.");
            }
            if (newEdit == null) {
                this.removeTextEditFromCuChange((TextEdit)originalEdit);
                continue;
            }
            if (TextEditUtilities.replaceTextEdit(TextEditUtilities.getTextEditGroups(this.compilationUnitChange.getChangeGroups()), (TextEdit)originalEdit, (TextEdit)newEdit)) continue;
            GWTPluginLog.logWarning("Could not update the text edit region of a change, skipping this edit.");
            this.removeTextEditFromCuChange((TextEdit)originalEdit);
        }
        return super.perform(pm);
    }

    private void removeTextEditFromCuChange(TextEdit edit) {
        TextEditUtilities.removeTextEdit(edit, TextEditUtilities.findTextEditGroup((TextEditBasedChange)this.compilationUnitChange, edit), (TextEditBasedChange)this.compilationUnitChange);
    }
}

