/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.regionupdater;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.platform.jdt.dom.NodeFinder;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.refactoring.ChangeUtilities;
import com.google.gwt.eclipse.core.refactoring.RefactoringException;
import com.google.gwt.eclipse.core.refactoring.TextEditUtilities;
import com.google.gwt.eclipse.core.refactoring.regionupdater.ReferenceUpdater;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RegionUpdater;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RegionUpdaterChange;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RegionUpdaterFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

public class RegionUpdaterChangeWeavingVisitor
implements ChangeUtilities.ChangeVisitor {
    private final ASTMatcher astMatcher;
    private final ReferenceUpdater referenceUpdater;

    public RegionUpdaterChangeWeavingVisitor(ASTMatcher astMatcher, ReferenceUpdater referenceUpdater) {
        this.astMatcher = astMatcher;
        this.referenceUpdater = referenceUpdater;
    }

    @Override
    public void visit(Change change) {
        if (!(change instanceof TextFileChange)) {
            return;
        }
        final TextFileChange textChange = (TextFileChange)change;
        Object modifiedElement = textChange.getModifiedElement();
        if (!(modifiedElement instanceof ICompilationUnit)) {
            return;
        }
        final CompilationUnit compilationUnit = JavaASTUtils.parseCompilationUnit((ICompilationUnit)((ICompilationUnit)modifiedElement));
        final ArrayList<RegionUpdater> regionUpdaters = new ArrayList<RegionUpdater>();
        TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = textChange.getChangeGroups();
        int n = textEditBasedChangeGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TextEditBasedChangeGroup changeGroup = textEditBasedChangeGroupArray[n2];
            TextEdit[] textEditArray = changeGroup.getTextEdits();
            int n3 = textEditArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TextEdit textEdit = textEditArray[n4];
                textEdit.accept(new TextEditVisitor(){

                    public boolean visit(ReplaceEdit edit) {
                        ASTNode node = NodeFinder.perform((ASTNode)compilationUnit, (int)edit.getOffset(), (int)edit.getLength());
                        try {
                            regionUpdaters.add(RegionUpdaterFactory.newRegionUpdater(edit, node, RegionUpdaterChangeWeavingVisitor.this.referenceUpdater, RegionUpdaterChangeWeavingVisitor.this.astMatcher));
                            return true;
                        }
                        catch (RefactoringException e) {
                            GWTPluginLog.logWarning("Could not create a region updater for a text edit: " + e.getMessage());
                            this.removeTextEdit(textChange, changeGroup, (TextEdit)edit);
                            return false;
                        }
                    }

                    public boolean visitNode(TextEdit edit) {
                        this.removeTextEdit(textChange, changeGroup, edit);
                        return false;
                    }

                    private void removeTextEdit(TextFileChange textChange2, TextEditBasedChangeGroup changeGroup2, TextEdit edit) {
                        if (!TextEditUtilities.removeTextEdit(edit, changeGroup2.getTextEditGroup(), (TextEditBasedChange)textChange2)) {
                            GWTPluginLog.logWarning("Could not remove a text edit from a change.");
                        }
                    }
                });
                ++n4;
            }
            ++n2;
        }
        if (regionUpdaters.size() > 0) {
            this.wrapAndReplaceChange(change, regionUpdaters);
        }
    }

    private void wrapAndReplaceChange(Change change, final List<RegionUpdater> regionUpdaters) {
        ChangeUtilities.replaceChange(change, new ChangeUtilities.ReplacementChangeFactory(){

            @Override
            public Change createChange(Change originalChange) {
                RegionUpdaterChange wrappedChange = new RegionUpdaterChange("", (TextFileChange)originalChange, regionUpdaters, RegionUpdaterChangeWeavingVisitor.this.referenceUpdater);
                return wrappedChange;
            }
        });
    }
}

