/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.regionupdater;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;

public class RenamedElementAstMatcher
extends ASTMatcher {
    private final String oldName;
    private final String newName;

    private static String computeRegexString(String originalString, String oldName, String newName) {
        StringBuilder builder = new StringBuilder(originalString.length());
        String oldNameOrNewNameRegEx = String.format("(%s)|(%s)", Pattern.quote(oldName), Pattern.quote(newName));
        int i = originalString.indexOf(oldName);
        if (i >= 0) {
            int prevI = 0;
            while (i >= 0) {
                builder.append(Pattern.quote(originalString.substring(prevI, i)));
                builder.append(oldNameOrNewNameRegEx);
                prevI = i;
                i = originalString.indexOf(oldName, i + oldName.length());
            }
            builder.append(Pattern.quote(originalString.substring(prevI + oldName.length(), originalString.length())));
        }
        return builder.toString();
    }

    private static boolean regexMatches(String originalString, String newString, String oldName, String newName) {
        Pattern pattern = Pattern.compile(RenamedElementAstMatcher.computeRegexString(originalString, oldName, newName));
        Matcher matcher = pattern.matcher(newString);
        return matcher.matches();
    }

    private static boolean safeRenamedEquals(String string1, String string2, String oldName, String newName) {
        if (string1 == string2) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        if (string1.equals(string2)) {
            return true;
        }
        return RenamedElementAstMatcher.regexMatches(string1, string2, oldName, newName) || RenamedElementAstMatcher.regexMatches(string2, string1, oldName, newName);
    }

    public RenamedElementAstMatcher(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    public boolean match(CharacterLiteral node, Object other) {
        if (!(other instanceof CharacterLiteral)) {
            return false;
        }
        CharacterLiteral o = (CharacterLiteral)other;
        return RenamedElementAstMatcher.safeRenamedEquals(node.getEscapedValue(), o.getEscapedValue(), this.oldName, this.newName);
    }

    public boolean match(SimpleName node, Object other) {
        if (!(other instanceof SimpleName)) {
            return false;
        }
        SimpleName o = (SimpleName)other;
        return RenamedElementAstMatcher.safeRenamedEquals(node.getIdentifier(), o.getIdentifier(), this.oldName, this.newName);
    }

    public boolean match(TagElement node, Object other) {
        if (!(other instanceof TagElement)) {
            return false;
        }
        TagElement o = (TagElement)other;
        return RenamedElementAstMatcher.safeRenamedEquals(node.getTagName(), o.getTagName(), this.oldName, this.newName) && this.safeSubtreeListMatch(node.fragments(), o.fragments());
    }

    public boolean match(TextElement node, Object other) {
        if (!(other instanceof TextElement)) {
            return false;
        }
        TextElement o = (TextElement)other;
        return RenamedElementAstMatcher.safeRenamedEquals(node.getText(), o.getText(), this.oldName, this.newName);
    }
}

