/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.regionupdater;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public class StableBindingResolver {
    private final ASTNode node;
    private ASTNode stableNode;
    private IBinding stableBinding;

    public StableBindingResolver(ASTNode node) {
        this.node = node;
    }

    public IBinding getStableBinding() {
        return this.stableBinding;
    }

    public ASTNode getStableNode() {
        return this.stableNode;
    }

    public boolean resolve() {
        if (this.stableNode != null) {
            return true;
        }
        ASTNode curNode = this.node;
        while (curNode != null) {
            if (curNode instanceof AbstractTypeDeclaration) {
                this.stableBinding = ((AbstractTypeDeclaration)curNode).resolveBinding();
            } else if (this.node instanceof MethodDeclaration) {
                this.stableBinding = ((MethodDeclaration)this.node).resolveBinding();
            }
            if (this.stableBinding != null) {
                this.stableNode = curNode;
                return true;
            }
            curNode = curNode.getParent();
        }
        return false;
    }
}

