/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.regionupdater;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.refactoring.RefactoringException;
import com.google.gwt.eclipse.core.refactoring.regionupdater.EquivalentNodeFinder;
import com.google.gwt.eclipse.core.refactoring.regionupdater.ReferenceUpdater;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RegionUpdater;
import com.google.gwt.eclipse.core.refactoring.regionupdater.StableBindingResolver;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.text.edits.ReplaceEdit;

public abstract class StableNodeBasedRegionUpdater<N extends ASTNode>
extends RegionUpdater {
    private final N originalNode;
    private final ASTMatcher matcher;
    private final boolean isCompilationUnitTheStableNode;
    private final ASTNode originalStableNode;
    private final String originalStableBindingKey;

    public StableNodeBasedRegionUpdater(ReplaceEdit originalEdit, ReferenceUpdater referenceUpdater, N originalNode, ASTMatcher matcher) throws RefactoringException {
        super(originalEdit, referenceUpdater);
        this.originalNode = originalNode;
        this.matcher = matcher;
        StableBindingResolver stableBindingResolver = new StableBindingResolver((ASTNode)originalNode);
        if (stableBindingResolver.resolve()) {
            this.isCompilationUnitTheStableNode = false;
            this.originalStableNode = stableBindingResolver.getStableNode();
            this.originalStableBindingKey = stableBindingResolver.getStableBinding().getKey();
        } else {
            this.isCompilationUnitTheStableNode = true;
            this.originalStableNode = originalNode.getRoot();
            this.originalStableBindingKey = null;
        }
    }

    @Override
    public ReplaceEdit createUpdatedEdit(CompilationUnit newCu) throws RefactoringException {
        ASTNode equivalentStableNode = this.findEquivalentStableNode(newCu);
        EquivalentNodeFinder equivalentNodeFinder = new EquivalentNodeFinder((ASTNode)this.originalNode, this.originalStableNode, equivalentStableNode, this.matcher);
        ASTNode eqNode = equivalentNodeFinder.find();
        if (eqNode == null) {
            GWTPluginLog.logWarning("Could not find equivalent node.");
            return null;
        }
        return this.createUpdatedEditForEquivalentNode(eqNode);
    }

    public N getOriginalNode() {
        return this.originalNode;
    }

    public ASTNode getOriginalStableNode() {
        return this.originalStableNode;
    }

    protected abstract ReplaceEdit createUpdatedEditForEquivalentNode(N var1) throws RefactoringException;

    protected ASTNode findEquivalentStableNode(CompilationUnit newCu) throws RefactoringException {
        if (this.isCompilationUnitTheStableNode) {
            return newCu;
        }
        ASTNode equivalentStableNode = newCu.findDeclaringNode(this.getUpdatedStableBindingKey());
        if (equivalentStableNode == null) {
            throw new RefactoringException("Could not find the equivalent stable node in the post-refactoring AST.");
        }
        return equivalentStableNode;
    }

    private String getUpdatedStableBindingKey() {
        return this.originalStableBindingKey != null ? this.getReferenceUpdater().getUpdatedBindingKey(this.originalStableBindingKey) : null;
    }
}

