/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.rpc;

import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.refactoring.ChangeBuilder;
import com.google.gwt.eclipse.core.refactoring.ChangeUtilities;
import com.google.gwt.eclipse.core.refactoring.GWTRenameTypeParticipant;
import com.google.gwt.eclipse.core.refactoring.NestedRefactoringContext;
import com.google.gwt.eclipse.core.refactoring.RefactoringException;
import com.google.gwt.eclipse.core.refactoring.regionupdater.CompilationUnitRenamedReferenceUpdater;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RegionUpdaterChangeWeavingVisitor;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RenamedElementAstMatcher;
import com.google.gwt.eclipse.core.refactoring.rpc.TypeContainer;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class PairedInterfaceRenameParticipant
extends GWTRenameTypeParticipant {
    private TypeContainer typeContainer;
    private String pairedNewName;
    private RenameTypeProcessor processor;
    private InterfaceRenameRefactoringContext refactoringContext;

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Change change;
        if (!this.updateNewNameMetadata()) {
            return null;
        }
        if (this.typeContainer.getPairedType().equals(this.refactoringContext.visitedType)) {
            return null;
        }
        try {
            change = this.createChangeForInterfaceRename();
        }
        catch (RefactoringException e) {
            GWTPluginLog.logError(e);
            return null;
        }
        if (ChangeUtilities.mergeParticipantTextChanges((RefactoringParticipant)this, change)) {
            return null;
        }
        this.weaveChange(change);
        return change;
    }

    public String getName() {
        return "Rename GWT RPC paired interface";
    }

    @Override
    protected boolean initialize(Object element) {
        block7: {
            if (!super.initialize(element)) {
                return false;
            }
            try {
                this.typeContainer = TypeContainer.createTypeContainer(this.getTypeRefactoringSupport().getOldType());
                if (this.typeContainer != null) break block7;
                return false;
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e, "Error when checking whether a rename type refactoring is renaming a GWT RPC interface");
                return false;
            }
        }
        if (!this.updateNewNameMetadata()) {
            return false;
        }
        JavaRenameProcessor refactoringProcessor = this.getRenameProcessor();
        if (!(refactoringProcessor instanceof RenameTypeProcessor)) {
            GWTPluginLog.logWarning("Not participating in GWT RPC type rename due to invalid processor type: " + refactoringProcessor.getClass().getSimpleName());
            return false;
        }
        this.processor = (RenameTypeProcessor)refactoringProcessor;
        this.refactoringContext = (InterfaceRenameRefactoringContext)NestedRefactoringContext.forProcessor((RefactoringProcessor)refactoringProcessor);
        if (this.refactoringContext == null) {
            this.refactoringContext = InterfaceRenameRefactoringContext.newRootRefactoringContext();
            NestedRefactoringContext.storeForProcessor((RefactoringProcessor)refactoringProcessor, this.refactoringContext);
        }
        return true;
    }

    private Change createChangeForInterfaceRename() throws RefactoringException {
        InterfaceRenameChangeBuilder builder = new InterfaceRenameChangeBuilder(this.typeContainer.getPairedType(), this.pairedNewName, this.processor, this.typeContainer.getPairedType().getJavaProject().getProject().getWorkspace());
        ProcessorBasedRefactoring refactoring = (ProcessorBasedRefactoring)builder.createRefactoring();
        RefactoringProcessor nestedProcessor = refactoring.getProcessor();
        NestedRefactoringContext.storeForProcessor(nestedProcessor, InterfaceRenameRefactoringContext.newNestedRefactoringContext(this.typeContainer.getBaseType()));
        return builder.createChange();
    }

    private boolean updateNewNameMetadata() {
        String newName = this.getTypeRefactoringSupport().getNewElement().getElementName();
        this.pairedNewName = this.typeContainer.isSync() ? RemoteServiceUtilities.computeAsyncTypeName(newName) : RemoteServiceUtilities.computeSyncTypeName(newName);
        return this.pairedNewName != null;
    }

    private void weaveChange(Change change) {
        String oldName = this.typeContainer.getBaseType().getElementName();
        String newName = this.getTypeRefactoringSupport().getNewElement().getElementName();
        RenamedElementAstMatcher astMatcher = new RenamedElementAstMatcher(oldName, newName);
        String oldCuName = this.typeContainer.getBaseType().getCompilationUnit().getElementName();
        String newCuName = this.getTypeRefactoringSupport().getNewType().getCompilationUnit().getElementName();
        CompilationUnitRenamedReferenceUpdater cuValidator = new CompilationUnitRenamedReferenceUpdater(oldName, newName, oldCuName, newCuName);
        ChangeUtilities.acceptOnChange(change, new RegionUpdaterChangeWeavingVisitor(astMatcher, cuValidator));
    }

    private static class InterfaceRenameChangeBuilder
    extends ChangeBuilder<RenameJavaElementDescriptor> {
        private final RenameTypeProcessor processor;
        private final IType pairedType;
        private final String pairedNewName;

        public InterfaceRenameChangeBuilder(IType pairedType, String pairedNewName, RenameTypeProcessor processor, IWorkspace workspace) {
            super(RenameJavaElementDescriptor.class, "org.eclipse.jdt.ui.rename.type", workspace);
            this.processor = processor;
            this.pairedType = pairedType;
            this.pairedNewName = pairedNewName;
        }

        @Override
        protected void configureDescriptor(RenameJavaElementDescriptor descriptor) {
            int strategy;
            descriptor.setJavaElement((IJavaElement)this.pairedType);
            descriptor.setNewName(this.pairedNewName);
            descriptor.setProject(this.pairedType.getJavaProject().getProject().getName());
            String filePatterns = this.processor.getFilePatterns();
            if (filePatterns != null) {
                descriptor.setFileNamePatterns(filePatterns);
            }
            if ((strategy = this.processor.getMatchStrategy()) == 1 || strategy == 2 || strategy == 3) {
                descriptor.setMatchStrategy(strategy);
            }
            descriptor.setUpdateQualifiedNames(this.processor.getUpdateQualifiedNames());
            descriptor.setUpdateReferences(this.processor.getUpdateReferences());
            descriptor.setUpdateSimilarDeclarations(this.processor.getUpdateSimilarDeclarations());
            descriptor.setUpdateTextualOccurrences(this.processor.getUpdateTextualMatches());
        }
    }

    private static class InterfaceRenameRefactoringContext
    extends NestedRefactoringContext {
        private final IType visitedType;

        private static InterfaceRenameRefactoringContext newNestedRefactoringContext(IType visitedType) {
            return new InterfaceRenameRefactoringContext(visitedType);
        }

        private static InterfaceRenameRefactoringContext newRootRefactoringContext() {
            return new InterfaceRenameRefactoringContext(null);
        }

        public InterfaceRenameRefactoringContext(IType visitedType) {
            this.visitedType = visitedType;
        }
    }
}

