/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.rpc;

import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.refactoring.ChangeBuilder;
import com.google.gwt.eclipse.core.refactoring.ChangeUtilities;
import com.google.gwt.eclipse.core.refactoring.GWTRenameMemberParticipant;
import com.google.gwt.eclipse.core.refactoring.NestedRefactoringContext;
import com.google.gwt.eclipse.core.refactoring.RefactoringException;
import com.google.gwt.eclipse.core.refactoring.regionupdater.ReferenceUpdater;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RegionUpdaterChangeWeavingVisitor;
import com.google.gwt.eclipse.core.refactoring.regionupdater.RenamedElementAstMatcher;
import com.google.gwt.eclipse.core.refactoring.rpc.TypeContainer;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceException;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameVirtualMethodProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class PairedMethodRenameParticipant
extends GWTRenameMemberParticipant {
    private TypeContainer typeContainer;
    private IMethod baseMethod;
    private IMethod pairedMethod;
    private RenameVirtualMethodProcessor processor;
    private MethodRenameRefactoringContext refactoringContext;
    private String newMethodName;

    private static void addMethodsFromTopmostHierarchyToSet(IMethod method, Set<IMethod> set) throws CoreException {
        IMethod[] methods = JavaModelSearch.findMethodsFromTopmostHierarchy((IMethod)method);
        set.addAll(Arrays.asList(methods));
    }

    private static IMethod computePairedMethod(TypeContainer typeContainer, IMethod method) throws RemoteServiceException, JavaModelException {
        String[] paramTypeNames = null;
        paramTypeNames = typeContainer.isSync() ? RemoteServiceUtilities.computeAsyncParameterTypes(method) : RemoteServiceUtilities.computeSyncParameterTypes(method);
        String[] paramTypeSigs = new String[paramTypeNames.length];
        int i = 0;
        while (i < paramTypeNames.length) {
            paramTypeSigs[i] = Signature.createTypeSignature((String)paramTypeNames[i], (boolean)true);
            ++i;
        }
        IType pairedType = typeContainer.getPairedType();
        return JavaModelSearch.findMethodInHierarchy((ITypeHierarchy)pairedType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()), (IType)pairedType, (String)method.getElementName(), (String[])paramTypeSigs);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.newMethodName = this.computeNewName();
        if (!this.checkNestedConditions()) {
            return null;
        }
        this.addPairedMethodsOfMyHierarchy();
        if (this.refactoringContext.isRoot) {
            return this.createChangeFromMethodsToRefactor();
        }
        return null;
    }

    public String getName() {
        return "Rename method in a GWT RPC paired interface";
    }

    @Override
    protected boolean initialize(Object element) {
        block8: {
            if (!super.initialize(element) || !(element instanceof IMethod)) {
                return false;
            }
            this.baseMethod = (IMethod)this.getRefactoringSupport().getOldElement();
            this.typeContainer = TypeContainer.createTypeContainer(this.baseMethod.getDeclaringType());
            if (this.typeContainer != null) break block8;
            return false;
        }
        try {
            this.pairedMethod = PairedMethodRenameParticipant.computePairedMethod(this.typeContainer, this.baseMethod);
            if (this.pairedMethod == null) {
                return false;
            }
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e);
            return false;
        }
        catch (RemoteServiceException e) {
            GWTPluginLog.logError(e);
            return false;
        }
        RefactoringProcessor refactoringProcessor = this.getProcessor();
        if (!(refactoringProcessor instanceof RenameVirtualMethodProcessor)) {
            GWTPluginLog.logWarning("Not participating in GWT RPC method rename due to invalid processor type: " + refactoringProcessor.getClass().getSimpleName());
            return false;
        }
        this.processor = (RenameVirtualMethodProcessor)refactoringProcessor;
        this.refactoringContext = (MethodRenameRefactoringContext)NestedRefactoringContext.forProcessor(refactoringProcessor);
        if (this.refactoringContext == null) {
            this.refactoringContext = MethodRenameRefactoringContext.newRootRefactoringContext();
            NestedRefactoringContext.storeForProcessor(refactoringProcessor, this.refactoringContext);
        }
        return true;
    }

    private void addPairedMethodsOfMyHierarchy() {
        ITypeHierarchy myHierarchy;
        try {
            myHierarchy = this.typeContainer.getBaseType().newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            GWTPluginLog.logWarning(e, "There may be some GWT RPC methods that were not renamed.");
            return;
        }
        IType[] iTypeArray = myHierarchy.getAllInterfaces();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType curInterface = iTypeArray[n2];
            try {
                IMethod curPairedMethod;
                TypeContainer curTypeContainer = TypeContainer.createTypeContainer(curInterface);
                if (curTypeContainer != null && (curPairedMethod = PairedMethodRenameParticipant.computePairedMethod(curTypeContainer, this.baseMethod)) != null && !this.refactoringContext.visitedMethods.contains(curPairedMethod) && !this.refactoringContext.toRefactorMethods.contains(curPairedMethod)) {
                    this.refactoringContext.toRefactorMethods.add(curPairedMethod);
                    PairedMethodRenameParticipant.addMethodsFromTopmostHierarchyToSet(curPairedMethod, this.refactoringContext.visitedMethods);
                }
            }
            catch (JavaModelException e) {
                GWTPluginLog.logWarning(e, String.format("Could not search the hierarchy of %1$s for RPC methods to rename.", curInterface.getElementName()));
            }
            catch (RemoteServiceException e) {
                GWTPluginLog.logWarning(e, String.format("Could not search the hierarchy of %1$s for RPC methods to rename.", curInterface.getElementName()));
            }
            catch (CoreException e) {
                GWTPluginLog.logWarning(e, String.format("Could not search the hierarchy of %1$s for RPC methods to rename.", curInterface.getElementName()));
            }
            ++n2;
        }
    }

    private boolean checkNestedConditions() {
        try {
            PairedMethodRenameParticipant.addMethodsFromTopmostHierarchyToSet(this.baseMethod, this.refactoringContext.visitedMethods);
        }
        catch (CoreException e) {
            GWTPluginLog.logWarning("Not refactoring GWT RPC: " + e.getMessage());
            return false;
        }
        return true;
    }

    private String computeNewName() {
        return ((IMethod)this.getRefactoringSupport().getNewElement()).getElementName();
    }

    private Change createChangeForMethodRename(IMethod methodToRename) throws RefactoringException {
        MethodRenameChangeBuilder builder = new MethodRenameChangeBuilder(methodToRename, this.newMethodName, this.processor, methodToRename.getJavaProject().getProject().getWorkspace());
        ProcessorBasedRefactoring refactoring = (ProcessorBasedRefactoring)builder.createRefactoring();
        RefactoringProcessor nestedProcessor = refactoring.getProcessor();
        NestedRefactoringContext.storeForProcessor(nestedProcessor, MethodRenameRefactoringContext.newNestedRefactoringContext(this.refactoringContext));
        return builder.createChange();
    }

    private Change createChangeFromMethodsToRefactor() {
        CompositeChange changes = new CompositeChange("GWT RPC paired method renames");
        changes.markAsSynthetic();
        while (this.refactoringContext.toRefactorMethods.size() > 0) {
            IMethod method = (IMethod)this.refactoringContext.toRefactorMethods.remove(0);
            try {
                Change change = this.createChangeForMethodRename(method);
                if (change == null || ChangeUtilities.mergeParticipantTextChanges((RefactoringParticipant)this, change)) continue;
                ChangeUtilities.acceptOnChange(change, new RegionUpdaterChangeWeavingVisitor(new RenamedElementAstMatcher(this.pairedMethod.getElementName(), this.newMethodName), new ReferenceUpdater()));
                changes.add(change);
            }
            catch (RefactoringException e) {
                GWTPluginLog.logError("Could not rename method " + method);
            }
        }
        return changes.getChildren().length > 0 ? changes : null;
    }

    private static class MethodRenameChangeBuilder
    extends ChangeBuilder<RenameJavaElementDescriptor> {
        private final RenameVirtualMethodProcessor processor;
        private final IMethod method;
        private final String newName;

        public MethodRenameChangeBuilder(IMethod method, String newName, RenameVirtualMethodProcessor processor, IWorkspace workspace) {
            super(RenameJavaElementDescriptor.class, "org.eclipse.jdt.ui.rename.method", workspace);
            this.newName = newName;
            this.processor = processor;
            this.method = method;
        }

        @Override
        protected void configureDescriptor(RenameJavaElementDescriptor descriptor) {
            descriptor.setJavaElement((IJavaElement)this.method);
            descriptor.setNewName(this.newName);
            descriptor.setProject(this.method.getJavaProject().getProject().getName());
            descriptor.setKeepOriginal(this.processor.getDelegateUpdating());
            descriptor.setDeprecateDelegate(this.processor.getDeprecateDelegates());
            descriptor.setUpdateReferences(this.processor.getUpdateReferences());
        }
    }

    private static class MethodRenameRefactoringContext
    extends NestedRefactoringContext {
        private final Set<IMethod> visitedMethods;
        private final List<IMethod> toRefactorMethods;
        private final boolean isRoot;

        private static MethodRenameRefactoringContext newNestedRefactoringContext(MethodRenameRefactoringContext callerData) {
            return new MethodRenameRefactoringContext(callerData.visitedMethods, callerData.toRefactorMethods, false);
        }

        private static MethodRenameRefactoringContext newRootRefactoringContext() {
            return new MethodRenameRefactoringContext(new HashSet<IMethod>(), new ArrayList<IMethod>(), true);
        }

        private MethodRenameRefactoringContext(Set<IMethod> visitedMethods, List<IMethod> toVisitMethods, boolean isNested) {
            this.visitedMethods = visitedMethods;
            this.toRefactorMethods = toVisitMethods;
            this.isRoot = isNested;
        }
    }
}

