/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.refactoring.rpc;

import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

class TypeContainer {
    private final IType baseType;
    private final boolean isSync;
    private final IType pairedType;

    public static TypeContainer createTypeContainer(IType baseType) throws JavaModelException {
        boolean isSync = true;
        IType pairedType = null;
        if (RemoteServiceUtilities.isSyncInterface(baseType)) {
            isSync = true;
            pairedType = RemoteServiceUtilities.resolveAsyncType(baseType);
        } else if (RemoteServiceUtilities.isAsyncInterface(baseType)) {
            isSync = false;
            pairedType = RemoteServiceUtilities.resolveSyncType(baseType);
        }
        return pairedType != null ? new TypeContainer(baseType, isSync, pairedType) : null;
    }

    private TypeContainer(IType baseType, boolean isSync, IType pairedType) {
        this.baseType = baseType;
        this.isSync = isSync;
        this.pairedType = pairedType;
    }

    public IType getBaseType() {
        return this.baseType;
    }

    public IType getPairedType() {
        return this.pairedType;
    }

    public boolean isSync() {
        return this.isSync;
    }
}

