/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.runtime;

import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.util.GwtVersionUtil;
import com.google.gwt.eclipse.core.util.Util;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class GWTJarsRuntime
extends GwtSdk {
    private static final File[] NO_FILES = new File[0];

    public GWTJarsRuntime(String name, IPath location) {
        super(name, location);
    }

    @Override
    public URLClassLoader createClassLoader() throws Sdk.SdkException, MalformedURLException {
        URL[] urls = this.validate().isOK() ? this.getBuildClasspathUrls().toArray(new URL[0]) : new URL[]{};
        return new URLClassLoader(urls, null);
    }

    public IClasspathEntry[] getClasspathEntries() {
        IPath gwtJavadocLocation = this.getInstallationPath().append((IPath)new Path("doc/javadoc"));
        IClasspathAttribute[] extraAttributes = new IClasspathAttribute[]{};
        if (gwtJavadocLocation.toFile().exists()) {
            extraAttributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)gwtJavadocLocation.toFile().toURI().toString())};
        }
        ArrayList<IClasspathEntry> buildClasspathEntries = new ArrayList<IClasspathEntry>();
        if (this.validate().isOK()) {
            List<IPath> buildClasspaths = this.getBuildClasspaths();
            for (IPath buildClasspath : buildClasspaths) {
                if (buildClasspath.lastSegment().startsWith("gwt-")) {
                    buildClasspathEntries.add(JavaCore.newLibraryEntry((IPath)buildClasspath, null, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])extraAttributes, (boolean)false));
                    continue;
                }
                buildClasspathEntries.add(JavaCore.newLibraryEntry((IPath)buildClasspath, (IPath)Util.findSourcesJarForClassesJar(buildClasspath), null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false));
            }
        }
        return buildClasspathEntries.toArray(NO_ICLASSPATH_ENTRIES);
    }

    @Override
    public File getDevJar() {
        File devJar = this.getInstallationPath().append(Util.getDevJarName(this.getInstallationPath())).toFile();
        if (devJar.exists()) {
            return devJar;
        }
        return null;
    }

    public File[] getWebAppClasspathFiles(IProject project) {
        if (this.validate().isOK()) {
            return new File[]{this.getInstallationPath().append("gwt-servlet.jar").toFile()};
        }
        return NO_FILES;
    }

    @Override
    public IStatus validate() {
        IPath sdkLocation = this.getInstallationPath();
        File sdkDir = sdkLocation.toFile();
        if (!sdkDir.exists()) {
            return Util.newErrorStatus("SDK path '" + sdkLocation.toOSString() + "' does not exist");
        }
        IPath gwtUserPath = sdkLocation.append("gwt-user.jar");
        if (!gwtUserPath.toFile().exists()) {
            return Util.newErrorStatus(String.valueOf(gwtUserPath.toOSString()) + " is missing");
        }
        IPath gwtDevPath = sdkLocation.append(Util.getDevJarName(sdkLocation));
        if (!gwtDevPath.toFile().exists()) {
            return Util.newErrorStatus(String.valueOf(gwtDevPath.toOSString()) + " is missing");
        }
        IPath gwtServletPath = sdkLocation.append("gwt-servlet.jar");
        if (!gwtServletPath.toFile().exists()) {
            return Util.newErrorStatus(String.valueOf(gwtServletPath.toOSString()) + " is missing");
        }
        return Status.OK_STATUS;
    }

    private List<IPath> getBuildClasspaths() {
        ArrayList<IPath> classpathEntries = new ArrayList<IPath>();
        classpathEntries.add(this.getInstallationPath().append("gwt-user.jar"));
        if (GwtVersionUtil.isGwtVersionKnownAndAtLeast25(this.getInstallationPath().lastSegment())) {
            classpathEntries.add(this.getInstallationPath().append("gwt-codeserver.jar"));
        }
        classpathEntries.add(this.getInstallationPath().append(Util.getDevJarName(this.getInstallationPath())));
        String[] stringArray = Util.getValidationJarNames(this.getInstallationPath());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String validationJarName = stringArray[n2];
            classpathEntries.add(this.getInstallationPath().append(validationJarName));
            ++n2;
        }
        return classpathEntries;
    }

    private List<URL> getBuildClasspathUrls() {
        List<IPath> buildClasspaths = this.getBuildClasspaths();
        ArrayList<URL> buildClasspathUrls = new ArrayList<URL>();
        for (IPath buildClasspath : buildClasspaths) {
            try {
                buildClasspathUrls.add(buildClasspath.toFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                GWTPluginLog.logError(e);
            }
        }
        return buildClasspathUrls;
    }
}

