/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.runtime;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.GWTProjectUtilities;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.util.Util;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class GWTProjectsRuntime
extends GwtSdk {
    public static final String LOCATION = "Workspace";
    public static final String VERSION = "0.0.0";
    static final String GWT_DEV_FALLBACK_PROJECT_NAME = "gwt-dev";
    static final String STAGING_FOLDER_RELATIVE_LOCATION = "build/staging";
    private static final String GWT_USER_PROJECT_NAME = "gwt-user";
    private static final String JAVADOC_SOURCE_FOLDER_NAME = "javadoc";
    private static final File[] NO_FILES = new File[0];
    private static final URL[] NO_URLS = new URL[0];
    private static final String SUPER_SOURCE_FOLDER_NAME = "super";
    private static final String TEST_SUPER_SOURCE_FOLDER_NAME = "test-super";

    public static List<IRuntimeClasspathEntry> getGWTRuntimeProjectSourceEntries(IJavaProject project, boolean includeTestSourceEntries) throws Sdk.SdkException {
        assert (GWTProjectsRuntime.isGWTRuntimeProject(project) && project.exists());
        String projectName = project.getProject().getName();
        ArrayList<IRuntimeClasspathEntry> sourceEntries = new ArrayList<IRuntimeClasspathEntry>();
        IClasspathEntry[] gwtUserJavaProjClasspathEntries = null;
        try {
            gwtUserJavaProjClasspathEntries = project.getRawClasspath();
        }
        catch (JavaModelException e) {
            throw new Sdk.SdkException("Cannot extract raw classpath from " + projectName + " project.");
        }
        HashSet<IPath> absoluteSuperSourcePaths = new HashSet<IPath>();
        IClasspathEntry[] iClasspathEntryArray = gwtUserJavaProjClasspathEntries;
        int n = gwtUserJavaProjClasspathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IPath sourcePath;
            IClasspathEntry curClasspathEntry = iClasspathEntryArray[n2];
            if (!(curClasspathEntry.getEntryKind() != 3 || GWTProjectsRuntime.isJavadocPath(sourcePath = curClasspathEntry.getPath()) || GWTProjectUtilities.isTestPath(sourcePath) && !includeTestSourceEntries)) {
                sourceEntries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)sourcePath));
                IPath absoluteSuperSourcePath = sourcePath.removeLastSegments(1).append(SUPER_SOURCE_FOLDER_NAME);
                IPath relativeSuperSourcePath = absoluteSuperSourcePath.removeFirstSegments(1);
                if (!absoluteSuperSourcePaths.contains(absoluteSuperSourcePath)) {
                    if (project.getProject().getFolder(relativeSuperSourcePath).exists()) {
                        sourceEntries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)absoluteSuperSourcePath));
                        absoluteSuperSourcePaths.add(absoluteSuperSourcePath);
                    }
                    IPath absoluteTestSuperSourcePath = sourcePath.removeLastSegments(1).append(TEST_SUPER_SOURCE_FOLDER_NAME);
                    IPath relativeTestSuperSourcePath = absoluteTestSuperSourcePath.removeFirstSegments(1);
                    if (!absoluteSuperSourcePaths.contains(absoluteTestSuperSourcePath) && includeTestSourceEntries && project.getProject().getFolder(relativeTestSuperSourcePath).exists()) {
                        sourceEntries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)absoluteTestSuperSourcePath));
                        absoluteSuperSourcePaths.add(absoluteTestSuperSourcePath);
                    }
                }
            }
            ++n2;
        }
        if (absoluteSuperSourcePaths.isEmpty()) {
            GWTPluginLog.logError("There were no super source folders found for the project '{0}'", project.getProject().getName());
        }
        return sourceEntries;
    }

    public static boolean isGWTRuntimeProject(IJavaProject project) {
        String projectName = project.getProject().getName();
        return GWT_USER_PROJECT_NAME.equals(projectName) || projectName.equals(GWT_DEV_FALLBACK_PROJECT_NAME) || projectName.equals(GWTProjectsRuntime.getPlatformSpecificDevProjectName());
    }

    public static GWTProjectsRuntime syntheziseContributorRuntime() {
        return (GWTProjectsRuntime)GwtSdk.getFactory().newInstance("temp contributor SDK", ResourcesPlugin.getWorkspace().getRoot().getLocation());
    }

    static IStatus getGwtDevJarStatus(GwtSdk sdk) {
        try {
            if (sdk.getDevJar() == null) {
                return new Status(4, "com.gwtplugins.gwt.eclipse.core", "The gwt-dev JAR is missing, ensure your GWT trunk has been built from the command line.");
            }
        }
        catch (Sdk.SdkException e) {
            return new Status(4, "com.gwtplugins.gwt.eclipse.core", e.getMessage());
        }
        catch (JavaModelException e) {
            GWTPluginLog.logWarning(e, "Could not get GWT dev JAR status");
        }
        return StatusUtilities.newOkStatus((String)"", (String)"com.gwtplugins.gwt.eclipse.core");
    }

    static String getPlatformSpecificDevProjectName() {
        return "gwt-dev-" + Util.getPlatformName();
    }

    static String getVersionImpl() {
        return VERSION;
    }

    private static IPath getAbsoluteLocation(IPath workspaceRelativePath, IProject project) {
        IPath relativeSourcePath = workspaceRelativePath.removeFirstSegments(1);
        return project.getFolder(relativeSourcePath).getLocation();
    }

    private static boolean isJavadocPath(IPath path) {
        return JAVADOC_SOURCE_FOLDER_NAME.equals(path.lastSegment());
    }

    GWTProjectsRuntime(String name, IPath location) {
        super(name, location);
    }

    @Override
    public URLClassLoader createClassLoader() throws Sdk.SdkException, MalformedURLException {
        IJavaProject userProject = this.findUserProject();
        if (userProject != null) {
            IRuntimeClasspathEntry outputEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)userProject);
            try {
                IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)outputEntry, (IJavaProject)userProject);
                ArrayList<URL> urls = new ArrayList<URL>();
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = resolveRuntimeClasspathEntry;
                int n = resolveRuntimeClasspathEntry.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
                    urls.add(new File(entry.getLocation()).toURI().toURL());
                    ++n2;
                }
                return new URLClassLoader(urls.toArray(NO_URLS), null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public IClasspathEntry[] getClasspathEntries() {
        IJavaProject devProject = this.findDevProject();
        IJavaProject userProject = this.findUserProject();
        if (devProject != null && userProject != null) {
            return new IClasspathEntry[]{JavaCore.newProjectEntry((IPath)devProject.getPath()), JavaCore.newProjectEntry((IPath)userProject.getPath())};
        }
        return NO_ICLASSPATH_ENTRIES;
    }

    @Override
    public File getDevJar() throws Sdk.SdkException, JavaModelException {
        String value;
        IStringVariableManager variableManager = this.getVariableManager();
        IValueVariable valueVariable = variableManager.getValueVariable("gwt_devjar");
        if (valueVariable != null && (value = valueVariable.getValue()) != null) {
            Path path = new Path(value);
            File file = path.toFile();
            if (!file.exists()) {
                throw new Sdk.SdkException("gwt_devjar Run/Debug variable points to a non-existent jar: " + value);
            }
            return file;
        }
        IProject userProject = ResourcesPlugin.getWorkspace().getRoot().getProject(GWT_USER_PROJECT_NAME);
        if (!userProject.exists()) {
            throw new Sdk.SdkException("The project ' " + userProject.getName() + "' does not exist in the workspace.");
        }
        IJavaProject javaUserProject = JavaCore.create((IProject)userProject);
        if (!javaUserProject.exists()) {
            throw new Sdk.SdkException("The project ' " + userProject.getName() + "' is not a Java project.");
        }
        IClasspathEntry[] rawClasspaths = javaUserProject.getRawClasspath();
        File stagingDir = null;
        IPath stagingPathLocation = null;
        IClasspathEntry[] iClasspathEntryArray = rawClasspaths;
        int n = rawClasspaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath sourcePathLocation;
            IClasspathEntry rawClasspath = iClasspathEntryArray[n2];
            if (rawClasspath.getEntryKind() == 3 && (stagingDir = (stagingPathLocation = (sourcePathLocation = GWTProjectsRuntime.getAbsoluteLocation(rawClasspath.getPath(), userProject)).removeLastSegments(2).append(STAGING_FOLDER_RELATIVE_LOCATION)).toFile()).exists()) break;
            ++n2;
        }
        if (stagingPathLocation == null) {
            throw new Sdk.SdkException("Contributor SDK build directory not found; Project '" + userProject.getName() + "' does not have any source folders.");
        }
        if (stagingDir == null || !stagingDir.exists()) {
            throw new Sdk.SdkException("Contributor SDK build directory not found (expected at " + stagingPathLocation.toString() + ")");
        }
        final File[] buildDirs = stagingDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("gwt-");
            }
        });
        if (buildDirs.length == 0) {
            throw new Sdk.SdkException("Contributor SDK build directory not found (expected at " + stagingDir.toString() + File.separator + "gwt-<platform>-<version>)");
        }
        File[] gwtDevJars = buildDirs[0].listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                IPath sdkLocationPath = Path.fromOSString((String)buildDirs[0].getAbsolutePath());
                return name.equalsIgnoreCase(Util.getDevJarName(sdkLocationPath));
            }
        });
        if (gwtDevJars.length == 0) {
            throw new Sdk.SdkException("Contributor SDK build directory missing required JAR files");
        }
        return gwtDevJars[0];
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public File[] getWebAppClasspathFiles(IProject project) {
        try {
            File devJar = this.getDevJar();
            File servletJar = new File(devJar.getParentFile(), "gwt-servlet.jar");
            return new File[]{servletJar};
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (Sdk.SdkException e) {
            e.printStackTrace();
        }
        return NO_FILES;
    }

    @Override
    public boolean usesGwtDevProject() {
        return true;
    }

    @Override
    public IStatus validate() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager pathVariableManager = workspace.getPathVariableManager();
        URI gwtUri = pathVariableManager.getURIValue("GWT_ROOT");
        if (gwtUri == null) {
            return new Status(4, "com.gwtplugins.gwt.eclipse.core", "Path variable 'GWT_ROOT' is not defined");
        }
        IPath gwtRoot = URIUtil.toPath((URI)gwtUri);
        if (gwtRoot == null) {
            return new Status(4, "com.gwtplugins.gwt.eclipse.core", "Path variable 'GWT_ROOT' is not defined");
        }
        if (!gwtRoot.toFile().exists()) {
            return new Status(4, "com.gwtplugins.gwt.eclipse.core", "Path variable 'GWT_ROOT' points to an invalid location");
        }
        if (this.findDevProject() == null) {
            return new Status(4, "com.gwtplugins.gwt.eclipse.core", "Could not find and gwt-dev-* project");
        }
        if (this.findUserProject() == null) {
            return new Status(4, "com.gwtplugins.gwt.eclipse.core", "Could not find the gwt-user project");
        }
        return GWTProjectsRuntime.getGwtDevJarStatus(this);
    }

    private IJavaProject findDevProject() {
        IJavaProject devProject = JavaProjectUtilities.findJavaProject((String)GWTProjectsRuntime.getPlatformSpecificDevProjectName());
        if (devProject == null) {
            devProject = JavaProjectUtilities.findJavaProject((String)GWT_DEV_FALLBACK_PROJECT_NAME);
        }
        return devProject;
    }

    private IJavaProject findUserProject() {
        return JavaProjectUtilities.findJavaProject((String)GWT_USER_PROJECT_NAME);
    }

    private IStringVariableManager getVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }
}

