/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.runtime;

import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.net.MalformedURLException;
import java.net.URLClassLoader;

public class GwtCapabilityChecker {
    private final GwtSdk sdk;

    private static boolean doesGwtClassExist(GwtSdk gwtRuntime, String qualifiedClassName) {
        try {
            URLClassLoader cl = gwtRuntime.createClassLoader();
            cl.loadClass(qualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException cl) {
        }
        catch (MalformedURLException e) {
            GWTPluginLog.logError(e);
        }
        catch (Sdk.SdkException e) {
            GWTPluginLog.logError(e);
        }
        return false;
    }

    public GwtCapabilityChecker(GwtSdk sdk) {
        this.sdk = sdk;
    }

    public boolean doesCompilerAllowMultipleModules() {
        return GwtCapabilityChecker.doesGwtClassExist(this.sdk, "com.google.gwt.dev.Compiler");
    }

    public static class Factory {
        public GwtCapabilityChecker newGwtCapabilityChecker(GwtSdk sdk) {
            return new GwtCapabilityChecker(sdk);
        }
    }
}

