/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.runtime;

import com.google.gdt.eclipse.core.ClasspathUtilities;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.extensions.ExtensionQuery;
import com.google.gdt.eclipse.core.sdk.AbstractSdk;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gdt.eclipse.core.sdk.SdkFactory;
import com.google.gdt.eclipse.core.sdk.SdkUtils;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.preferences.GWTPreferences;
import com.google.gwt.eclipse.core.runtime.GWTJarsRuntime;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.util.Util;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

public abstract class GwtSdk
extends AbstractSdk {
    public static final String GWT_CODESERVER_JAR = "gwt-codeserver.jar";
    public static final String GWT_DEV_NO_PLATFORM_JAR = "gwt-dev.jar";
    public static final String GWT_USER_JAR = "gwt-user.jar";
    public static final String VALIDATION_API_JAR_PREFIX = "validation-api-";
    private static final SdkFactory<GwtSdk> factory = new SdkFactory<GwtSdk>(){

        public GwtSdk newInstance(String name, IPath sdkHome) {
            if (GwtSdk.isProjectBasedSdk(sdkHome)) {
                return new GWTProjectsRuntime(name, sdkHome);
            }
            return new GWTJarsRuntime(name, sdkHome);
        }
    };
    private static final File[] NO_FILES = new File[0];

    public static GwtSdk findSdkFor(IJavaProject javaProject) {
        ExtensionQuery extQuery = new ExtensionQuery("com.gwtplugins.gwt.eclipse.core", "gwtProjectBoundSdkFactory", "class");
        List sdkFactories = extQuery.getData();
        for (ExtensionQuery.Data sdkFactory : sdkFactories) {
            ProjectBoundSdk externalGWTRuntime = ((IProjectBoundSdkFactory)sdkFactory.getExtensionPointData()).newInstance(javaProject);
            if (externalGWTRuntime == null || !((GwtSdk)externalGWTRuntime).validate().isOK()) continue;
            return externalGWTRuntime;
        }
        ProjectBoundSdk projectBoundSdk = new ProjectBoundSdk(javaProject);
        if (projectBoundSdk.getInstallationPath() != null) {
            return projectBoundSdk;
        }
        return null;
    }

    public static SdkFactory<GwtSdk> getFactory() {
        return factory;
    }

    protected static IPath computeStagingDirectoryPath(IPath rootPath) {
        File stagingDirectory = rootPath.toFile();
        File[] buildDirs = stagingDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("gwt-");
            }
        });
        if (buildDirs != null && buildDirs.length > 0) {
            return new Path(buildDirs[0].getAbsolutePath());
        }
        return null;
    }

    private static boolean isProjectBasedSdk(IPath sdkHome) {
        IPath location = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        return location.equals((Object)sdkHome);
    }

    protected GwtSdk(String name, IPath location) {
        super(name, location);
    }

    public abstract URLClassLoader createClassLoader() throws Sdk.SdkException, MalformedURLException;

    public abstract File getDevJar() throws Sdk.SdkException, JavaModelException;

    public String getVersion() {
        String exceptionMessage = "Cannot get version of GWT SDK \"" + this.getName() + "\", ensure it is configured properly";
        try {
            URLClassLoader cl = this.createClassLoader();
            Class<?> about = cl.loadClass("com.google.gwt.dev.About");
            Method method = about.getMethod("getGwtVersionNum", new Class[0]);
            String versionStr = (String)method.invoke(null, new Object[0]);
            return SdkUtils.cleanupVersion((String)versionStr);
        }
        catch (MalformedURLException e) {
            GWTPluginLog.logError(e, exceptionMessage);
        }
        catch (Sdk.SdkException e) {
            GWTPluginLog.logError(e, exceptionMessage);
        }
        catch (ClassNotFoundException e) {
            GWTPluginLog.logError(e, exceptionMessage);
        }
        catch (SecurityException e) {
            GWTPluginLog.logError(e, exceptionMessage);
        }
        catch (IllegalArgumentException e) {
            GWTPluginLog.logError(e, exceptionMessage);
        }
        catch (IllegalAccessException e) {
            GWTPluginLog.logError(e, exceptionMessage);
        }
        catch (NoSuchMethodException e) {
            GWTPluginLog.logError(e, exceptionMessage);
        }
        catch (InvocationTargetException e) {
            GWTPluginLog.logError(e, exceptionMessage);
        }
        return "";
    }

    public boolean usesGwtDevProject() {
        return false;
    }

    public abstract IStatus validate();

    public static interface IProjectBoundSdkFactory {
        public ProjectBoundSdk newInstance(IJavaProject var1);
    }

    public static class ProjectBoundSdk
    extends GwtSdk {
        protected final IJavaProject javaProject;

        private static IPath getAbsoluteLocation(IPath workspaceRelativePath, IProject project) {
            IPath relativeSourcePath = workspaceRelativePath.removeFirstSegments(1);
            return project.getFolder(relativeSourcePath).getLocation();
        }

        protected ProjectBoundSdk(IJavaProject javaProject) {
            super("", null);
            this.javaProject = javaProject;
        }

        @Override
        public URLClassLoader createClassLoader() throws Sdk.SdkException, MalformedURLException {
            try {
                String[] defaultRuntimeClasspath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)this.javaProject);
                URL[] urls = new URL[defaultRuntimeClasspath.length];
                int i = 0;
                while (i < defaultRuntimeClasspath.length) {
                    File file = new File(defaultRuntimeClasspath[i]);
                    urls[i] = file.toURI().toURL();
                    ++i;
                }
                return new URLClassLoader(urls);
            }
            catch (CoreException e) {
                throw new Sdk.SdkException((Throwable)e);
            }
        }

        public IClasspathEntry[] getClasspathEntries() {
            try {
                IClasspathEntry gwtCodeServer;
                IClasspathEntry gwtUser;
                HashSet<IClasspathEntry> classpathEntries = new HashSet<IClasspathEntry>();
                IClasspathEntry gwtDev = this.findGwtDevClasspathEntry();
                if (gwtDev != null) {
                    classpathEntries.add(gwtDev);
                }
                if ((gwtUser = this.findGwtUserClasspathEntry()) != null) {
                    classpathEntries.add(gwtUser);
                }
                if ((gwtCodeServer = this.findGwtCodeServerClasspathEntry()) != null) {
                    classpathEntries.add(gwtCodeServer);
                }
                final List<IClasspathEntry> rawClasspath = Arrays.asList(this.javaProject.getRawClasspath());
                IClasspathEntry[] classpathEntryArray = classpathEntries.toArray(NO_ICLASSPATH_ENTRIES);
                Collections.sort(Arrays.asList(classpathEntryArray), new Comparator<IClasspathEntry>(){

                    @Override
                    public int compare(IClasspathEntry o1, IClasspathEntry o2) {
                        return rawClasspath.indexOf(o1) - rawClasspath.indexOf(o2);
                    }
                });
                return classpathEntryArray;
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
                return AbstractSdk.NO_ICLASSPATH_ENTRIES;
            }
        }

        @Override
        public File getDevJar() throws Sdk.SdkException, JavaModelException {
            IPath installPath = this.computeInstallPath();
            if (installPath != null) {
                return installPath.append(Util.getDevJarName(installPath)).toFile();
            }
            return null;
        }

        public IPath getInstallationPath() {
            if (this.usesGwtDevProject()) {
                return ResourcesPlugin.getWorkspace().getRoot().getLocation();
            }
            return this.computeInstallPath();
        }

        public String getName() {
            IPath installationPath = this.getInstallationPath();
            if (installationPath != null) {
                return installationPath.toOSString();
            }
            return "Unknown";
        }

        public File[] getWebAppClasspathFiles(IProject project) {
            IPath installPath = this.computeInstallPath();
            if (installPath != null) {
                return new File[]{installPath.append("gwt-servlet.jar").toFile()};
            }
            return NO_FILES;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean usesGwtDevProject() {
            try {
                IClasspathEntry[] resolvedClasspath;
                IClasspathEntry[] iClasspathEntryArray = resolvedClasspath = this.javaProject.getResolvedClasspath(true);
                int n = resolvedClasspath.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IClasspathEntry resolvedClasspathEntry = iClasspathEntryArray[n2];
                    String projectName = resolvedClasspathEntry.getPath().segment(0);
                    if (projectName.equals("gwt-dev")) return true;
                    if (projectName.equals(GWTProjectsRuntime.getPlatformSpecificDevProjectName())) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
            }
            return false;
        }

        @Override
        public IStatus validate() {
            IStatus status;
            if (this.getInstallationPath() == null) {
                return StatusUtilities.newErrorStatus((String)"Could not determine an installation path based on the project's classpath.", (String)"com.gwtplugins.gwt.eclipse.core");
            }
            if (this.usesGwtDevProject() && !(status = GWTProjectsRuntime.getGwtDevJarStatus(this)).isOK()) {
                return status;
            }
            return StatusUtilities.OK_STATUS;
        }

        private IPath computeGwtDevJarVariableValue() {
            String value;
            IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
            IValueVariable valueVariable = variableManager.getValueVariable("gwt_devjar");
            if (valueVariable != null && (value = valueVariable.getValue()) != null) {
                Path path = new Path(value);
                return path.removeLastSegments(1);
            }
            return null;
        }

        private IPath computeInstallPath() {
            try {
                IClasspathEntry classpathEntry = this.findGwtDevClasspathEntry();
                if (classpathEntry == null) {
                    classpathEntry = this.findGwtUserClasspathEntry();
                }
                if (classpathEntry != null) {
                    return this.computeInstallPath(classpathEntry);
                }
                return null;
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
                return null;
            }
        }

        private IPath computeInstallPath(IClasspathEntry classpathEntry) throws JavaModelException {
            IPath installPath = null;
            switch (classpathEntry.getEntryKind()) {
                case 5: {
                    IClasspathEntry[] classpathEntries;
                    GwtSdk sdk = (GwtSdk)GWTPreferences.getSdkManager().findSdkForPath(classpathEntry.getPath());
                    if (sdk == null || (classpathEntries = sdk.getClasspathEntries()).length <= 0) break;
                    installPath = this.computeInstallPath(classpathEntries[0]);
                    break;
                }
                case 1: {
                    installPath = classpathEntry.getPath().removeLastSegments(1);
                    break;
                }
                case 2: 
                case 3: {
                    installPath = this.computeGwtDevJarVariableValue();
                    if (installPath != null) break;
                    installPath = this.computeInstallPathFromProjectOrSourceClasspathEntry(classpathEntry);
                    break;
                }
            }
            return installPath;
        }

        private IPath computeInstallPathFromProject(IJavaProject jProject) throws JavaModelException {
            IPath buildStagingDirectory = null;
            IClasspathEntry[] iClasspathEntryArray = jProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry rawClasspath = iClasspathEntryArray[n2];
                if (rawClasspath.getEntryKind() == 3) {
                    IPath sourcePathLocation = ProjectBoundSdk.getAbsoluteLocation(rawClasspath.getPath(), jProject.getProject());
                    IPath outputLocation = sourcePathLocation.removeLastSegments(3).append("build/staging");
                    if (!outputLocation.toFile().exists()) {
                        outputLocation = sourcePathLocation.removeLastSegments(2).append("build/staging");
                    }
                    if (outputLocation.toFile().exists()) {
                        buildStagingDirectory = outputLocation;
                        break;
                    }
                }
                ++n2;
            }
            if (buildStagingDirectory != null) {
                return ProjectBoundSdk.computeStagingDirectoryPath(buildStagingDirectory);
            }
            return null;
        }

        private IPath computeInstallPathFromProjectOrSourceClasspathEntry(IClasspathEntry classpathEntry) throws JavaModelException {
            IPath entryPath = classpathEntry.getPath();
            String projectName = entryPath.segment(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IJavaProject jProject = JavaCore.create((IProject)project);
            IPath installPath = this.computeInstallPathFromProject(jProject);
            return installPath;
        }

        private IClasspathEntry findGwtCodeServerClasspathEntry() throws JavaModelException {
            IClasspathEntry entry = ClasspathUtilities.findRawClasspathEntryFor((IJavaProject)this.javaProject, (String)"com.google.gwt.dev.codeserver.CodeServer");
            return entry;
        }

        private IClasspathEntry findGwtDevClasspathEntry() throws JavaModelException {
            IClasspathEntry gwtDev = ClasspathUtilities.findRawClasspathEntryFor((IJavaProject)this.javaProject, (String)"com.google.gwt.dev.About");
            return gwtDev;
        }

        private IClasspathEntry findGwtUserClasspathEntry() throws JavaModelException {
            IClasspathEntry gwtUser = ClasspathUtilities.findRawClasspathEntryFor((IJavaProject)this.javaProject, (String)"com.google.gwt.core.client.GWT");
            return gwtUser;
        }
    }
}

