/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.runtime;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gwt.eclipse.core.preferences.GWTPreferences;
import com.google.gwt.eclipse.core.runtime.GWTProjectsRuntime;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class RuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver {
    private static final IRuntimeClasspathEntry[] NO_ENTRIES = new IRuntimeClasspathEntry[0];

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        GwtSdk gwtSdk = this.findGWTSdk(entry);
        if (gwtSdk == null) {
            return NO_ENTRIES;
        }
        IClasspathEntry[] classpathEntries = gwtSdk.getClasspathEntries();
        return this.resolveClasspathEntries(Arrays.asList(classpathEntries));
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        GwtSdk gwtSdk = this.findGWTSdk(entry);
        if (gwtSdk == null) {
            return NO_ENTRIES;
        }
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>(Arrays.asList(gwtSdk.getClasspathEntries()));
        return this.resolveClasspathEntries(classpathEntries);
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) {
        return null;
    }

    private List<IRuntimeClasspathEntry> dependenciesForProject(IJavaProject project) throws CoreException {
        String[] deps;
        ArrayList<IRuntimeClasspathEntry> out = new ArrayList<IRuntimeClasspathEntry>();
        String[] stringArray = deps = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        int n = deps.length;
        int n2 = 0;
        while (n2 < n) {
            String dep = stringArray[n2];
            IRuntimeClasspathEntry cpEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(dep));
            out.add(cpEntry);
            ++n2;
        }
        return out;
    }

    private GwtSdk findGWTSdk(IRuntimeClasspathEntry entry) {
        GwtSdk gwtSdk = (GwtSdk)GWTPreferences.getSdkManager().findSdkForPath(entry.getPath());
        if (gwtSdk != null) {
            return gwtSdk;
        }
        if (entry.getType() != 1) {
            return null;
        }
        String entryProjectName = entry.getPath().lastSegment();
        IJavaProject entryJavaProject = JavaProjectUtilities.findJavaProject((String)entryProjectName);
        if (entryJavaProject != null && GWTProjectsRuntime.isGWTRuntimeProject(entryJavaProject) && (gwtSdk = GWTProjectsRuntime.syntheziseContributorRuntime()).validate().isOK()) {
            return gwtSdk;
        }
        return null;
    }

    private IRuntimeClasspathEntry[] resolveClasspathEntries(List<IClasspathEntry> classpathEntries) throws CoreException {
        LinkedHashSet<IRuntimeClasspathEntry> runtimeClasspathEntries = new LinkedHashSet<IRuntimeClasspathEntry>();
        for (IClasspathEntry classpathEntry : classpathEntries) {
            if (classpathEntry.getEntryKind() == 2) {
                String projectName = classpathEntry.getPath().lastSegment();
                IJavaProject theproject = JavaProjectUtilities.findJavaProject((String)projectName);
                IRuntimeClasspathEntry projectEntry = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)theproject);
                runtimeClasspathEntries.add(projectEntry);
                runtimeClasspathEntries.addAll(this.dependenciesForProject(theproject));
                continue;
            }
            runtimeClasspathEntries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)classpathEntry.getPath()));
        }
        return runtimeClasspathEntries.toArray(NO_ENTRIES);
    }
}

