/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.runtime.tools;

import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gdt.eclipse.core.sdk.SdkClasspathContainer;
import com.google.gdt.eclipse.core.sdk.UpdateProjectSdkCommand;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.runtime.tools.WebAppProjectCreatorRunner;
import com.google.gwt.eclipse.core.sdk.GWTUpdateProjectSdkCommand;
import com.google.gwt.eclipse.core.sdk.GWTUpdateWebInfFolderCommand;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class NewProjectCreatorTool {
    public static IJavaProject createProject(IProgressMonitor progressMonitor, GwtSdk runtime, SdkClasspathContainer.Type containerType, String projectName, String packageName, String outDirPath) throws Exception {
        String entryPoint = projectName;
        String qualifiedModuleName = String.valueOf(packageName) + "." + entryPoint;
        File gwtDevJar = runtime.getDevJar();
        System.setProperty("gwt.devjar", gwtDevJar.toString());
        File outDir = new File(outDirPath);
        WebAppProjectCreatorRunner.createProject(qualifiedModuleName, outDir.getAbsolutePath(), runtime, progressMonitor, null, "sample", "eclipse");
        progressMonitor.worked(1);
        IProject project = NewProjectCreatorTool.importProject(projectName, outDirPath);
        progressMonitor.worked(1);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        GwtSdk oldSdk = GwtSdk.findSdkFor(javaProject);
        GWTUpdateWebInfFolderCommand updateWebInfCommand = new GWTUpdateWebInfFolderCommand(javaProject, (Sdk)runtime);
        GWTUpdateProjectSdkCommand updateProjectSdkCommand = new GWTUpdateProjectSdkCommand(javaProject, oldSdk, runtime, containerType == SdkClasspathContainer.Type.DEFAULT ? UpdateProjectSdkCommand.UpdateType.DEFAULT_CONTAINER : UpdateProjectSdkCommand.UpdateType.NAMED_CONTAINER, updateWebInfCommand);
        updateProjectSdkCommand.execute();
        progressMonitor.worked(1);
        NewProjectCreatorTool.removeLaunchConfig(entryPoint);
        progressMonitor.done();
        return javaProject;
    }

    private static IProject importProject(String projectName, String directory) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath path = new Path(directory).append(".project");
        try {
            IProjectDescription projectFile = workspace.loadProjectDescription(path);
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
            projectDescription.setLocation(path);
            IProject project = workspace.getRoot().getProject(projectName);
            project.create(projectFile, null);
            project.open(null);
            GWTNature.addNatureToProject(project);
            return project;
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
            throw new Exception("Could not import new GWT project");
        }
    }

    private static void removeLaunchConfig(String launchConfigName) throws Exception {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfiguration[] launchConfigs;
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigs = manager.getLaunchConfigurations();
            int n = launchConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
                if (launchConfig.getName().equals(launchConfigName)) {
                    launchConfig.delete();
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
            throw new Exception("Could not remove existing Java launch configuration");
        }
    }
}

