/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.runtime.tools;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gdt.eclipse.core.ProcessUtilities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gdt.eclipse.core.sdk.SdkUtils;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class WebAppProjectCreatorRunner {
    public static final String GWT_VERSION_WITH_TEMPLATES = "2.3.0";

    public static void createProject(String qualifiedModuleName, String outDir, GwtSdk gwtRuntime, IProgressMonitor monitor, String[] extraClassPath, String ... templates) throws CoreException {
        try {
            int processStatus = ProcessUtilities.launchProcessAndWaitFor(WebAppProjectCreatorRunner.computeWebAppCreatorCommandLine(qualifiedModuleName, outDir, gwtRuntime, templates, extraClassPath), null, (OutputStream)System.out, null);
            if (processStatus != 0) {
                throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", "Invocation of " + WebAppProjectCreatorRunner.computeWebAppCreatorClassName() + " failed. See the error log for more details."));
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", e.getLocalizedMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private static String computeClasspath(GwtSdk gwtRuntime, String[] extraClassPath) throws CoreException {
        ArrayList<String> cpPaths = new ArrayList<String>();
        IClasspathEntry[] iClasspathEntryArray = gwtRuntime.getClasspathEntries();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry c = iClasspathEntryArray[n2];
            if (c.getEntryKind() == 2) {
                IRuntimeClasspathEntry[] resolvedEntries;
                IJavaProject javaProject = JavaProjectUtilities.findJavaProject((String)c.getPath().toOSString());
                IRuntimeClasspathEntry projectRuntimeEntry = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)javaProject);
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = resolvedEntries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)projectRuntimeEntry, (IJavaProject)javaProject);
                int n3 = resolvedEntries.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRuntimeClasspathEntry resolvedEntry = iRuntimeClasspathEntryArray[n4];
                    cpPaths.add(resolvedEntry.getLocation());
                    ++n4;
                }
            } else {
                cpPaths.add(c.getPath().toFile().getAbsolutePath());
            }
            ++n2;
        }
        if (extraClassPath != null) {
            cpPaths.addAll(Arrays.asList(extraClassPath));
        }
        return ProcessUtilities.buildClasspathString(cpPaths);
    }

    private static String computeWebAppCreatorClassName() {
        return "com.google.gwt.user.tools.WebAppCreator";
    }

    private static List<String> computeWebAppCreatorCommandLine(String qualifiedModuleName, String outDir, GwtSdk gwtRuntime, String[] templates, String[] extraClassPath) throws CoreException {
        ArrayList<String> commandLine = new ArrayList<String>();
        String javaExecutable = ProcessUtilities.findJavaExecutableForEclipse();
        commandLine.add(javaExecutable);
        try {
            commandLine.add("-Dgwt.devjar=" + gwtRuntime.getDevJar().getAbsolutePath());
        }
        catch (Sdk.SdkException e) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", e.getLocalizedMessage(), (Throwable)e));
        }
        commandLine.add("-cp");
        commandLine.add(WebAppProjectCreatorRunner.computeClasspath(gwtRuntime, extraClassPath));
        commandLine.add(WebAppProjectCreatorRunner.computeWebAppCreatorClassName());
        commandLine.addAll(WebAppProjectCreatorRunner.computeWebAppCreatorOptions(qualifiedModuleName, outDir, templates, gwtRuntime));
        return commandLine;
    }

    private static List<String> computeWebAppCreatorOptions(String qualifiedModuleName, String outDir, String[] templates, GwtSdk gwtRuntime) throws CoreException {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-out");
        options.add(outDir);
        String version = gwtRuntime.getVersion();
        if (SdkUtils.isInternal((String)version) || SdkUtils.compareVersionStrings((String)version, (String)GWT_VERSION_WITH_TEMPLATES) >= 0) {
            String templatesList;
            if (templates != null && templates.length != 0) {
                templatesList = templates[0];
                int i = 1;
                while (i < templates.length) {
                    templatesList = String.valueOf(templatesList) + "," + templates[i];
                    ++i;
                }
            } else {
                templatesList = "sample";
            }
            options.add("-templates");
            options.add(templatesList);
        } else if (templates != null && templates.length != 1 && !templates[0].equals("sample")) {
            throw new CoreException((IStatus)new Status(4, "com.gwtplugins.gwt.eclipse.core", "Invocation of " + WebAppProjectCreatorRunner.computeWebAppCreatorClassName() + " failed. GWT before " + GWT_VERSION_WITH_TEMPLATES + " does not support templates."));
        }
        options.add(qualifiedModuleName);
        return options;
    }
}

