/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.sdk.ui;

import com.google.gdt.eclipse.core.sdk.SdkFactory;
import com.google.gdt.eclipse.core.sdk.SdkSet;
import com.google.gdt.eclipse.core.ui.AddSdkDialog;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddGwtSdkDialog
extends AddSdkDialog<GwtSdk> {
    private final boolean contribRuntimeAvailable;
    private Button contribButton;

    public AddGwtSdkDialog(Shell parentShell, SdkSet<GwtSdk> sdkSet, String pluginId, String shellTitle, SdkFactory<GwtSdk> sdkFactory) {
        super(parentShell, sdkSet, pluginId, shellTitle, sdkFactory);
        IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        GwtSdk runtime = (GwtSdk)GwtSdk.getFactory().newInstance("", workspace);
        IStatus status = runtime.validate();
        this.contribRuntimeAvailable = status.isOK();
    }

    protected void createDirectoryArea(Composite container) {
        if (this.contribRuntimeAvailable) {
            Button jarsButton = new Button(container, 16);
            jarsButton.setText("Installation directory:");
            jarsButton.setSelection(true);
        } else {
            Label jarsLabel = new Label(container, 0);
            jarsLabel.setText("Installation directory:");
        }
        this.directoryText = new Text(container, 2048);
        GridData directoryTextGridData = new GridData(4, 0x1000000, true, false);
        directoryTextGridData.widthHint = 300;
        this.directoryText.setLayoutData((Object)directoryTextGridData);
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGwtSdkDialog.this.validate();
            }
        });
        this.browseButton = new Button(container, 0);
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory = AddGwtSdkDialog.this.browseForDirectory();
                if (directory != null) {
                    AddGwtSdkDialog.this.directoryText.setText(directory);
                    if (AddGwtSdkDialog.this.nameText.getText().length() == 0) {
                        AddGwtSdkDialog.this.nameText.setText(new Path(directory).lastSegment());
                    }
                }
            }
        });
        if (this.contribRuntimeAvailable) {
            this.contribButton = new Button(container, 16);
            GridData contribButtonGridData = new GridData(16384, 0x1000000, false, false, 3, 1);
            this.contribButton.setLayoutData((Object)contribButtonGridData);
            this.contribButton.setText("Use GWT source projects in my workspace");
            this.contribButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddGwtSdkDialog.this.updateControls();
                    AddGwtSdkDialog.this.validate();
                }
            });
            Label spacer = new Label(container, 0);
            spacer.setText(" ");
            spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        }
    }

    protected IPath getSdkHome(String directory) {
        if (this.isContribRuntimeSelected()) {
            return ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        return super.getSdkHome(directory);
    }

    protected boolean validateDirectory() {
        if (this.isContribRuntimeSelected()) {
            return true;
        }
        return super.validateDirectory();
    }

    private boolean isContribRuntimeSelected() {
        return this.contribButton != null && this.contribButton.getSelection();
    }

    private void updateControls() {
        boolean jarRuntime = !this.isContribRuntimeSelected();
        this.directoryText.setEnabled(jarRuntime);
        this.browseButton.setEnabled(jarRuntime);
    }
}

